<?php
/**
@brief ѤΥѡƥե륿
@version $Id: AdminPartyFilter.php,v 1.4 2004/07/26 13:59:55 minahito Exp $
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

class AdminPartyFilter extends exAbstractFilterForm {
	var $end_=false;
	var $sort_=array ("id","uid","private","update_date","event_date","limit_date","title","status");

	function fetch()
	{
		$this->end_=(bool)($this->getPositiveIntger('end'));
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);

		if($this->end_) {
			$criteria->add(new Criteria("event_date",time(),"<"));
		}
		return $criteria;
	}

	function getExtra()
	{
		$ret=array();
		$ret['end']=($this->end_) ? 1 : 0;
		return $ret;
	}
}

class AdminPartyTableModel extends exListTableModel {
	var $_column_=array("ID","TITLE","PRIVATE","UPDATE_DATE","EVENT_DATE","LIMIT_DATE","STATUS","ACTION");
	var $filter_;

	function AdminPartyTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new AdminPartyFilter();
	}

	function init() {
		$handler = bxParty::getHandler('party');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$objs = $handler->getObjects($this->listController_->getCriteria());

		foreach ( $objs as $obj ) {
			$this->_row_data_[]=$obj->getArray();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtChk($arr)
	{
		return "<input type='checkbox' name='id[]' value='".$arr['id']."'>";
	}

	function getValueAtInput_date($arr)
	{
		return formatTimestamp($arr['input_date']);
	}

	function getValueAtUpdate_date($arr)
	{
		return formatTimestamp($arr['update_date']);
	}

	function getValueAtLimit_date($arr)
	{
		if($arr['limit_date']<time())
			return @sprintf("<font color='red'>%s</font>",formatTimestamp($arr['limit_date']));
		else
			return formatTimestamp($arr['limit_date']);
	}

	function getValueAtEvent_date($arr)
	{
		if($arr['event_date']<time())
			return @sprintf("<font color='red'>%s</font>",formatTimestamp($arr['event_date']));
		else
			return formatTimestamp($arr['event_date']);
	}

	function getValueAtStatus($arr)
	{
		$handler=&bxParty::getHandler('status');
		$status=$handler->get($arr['status']);

		return is_object($status) ? $status->getVar('name') : "&nbsp";
	}
	
	function getValueAtAction($arr)
	{
		$ret=@sprintf("<a href='%s'>%s</a> | ","../submit.php?id=".$arr['id'],_MD_A_BXPARTY_LANG_EDIT).
			@sprintf("<a href='%s'>%s</a> | ","entry.php?id=".$arr['id'],_MD_A_BXPARTY_LANG_ENTRY).
			@sprintf("<a href='%s'>%s</a>","../party_delete.php?id=".$arr['id'],_MD_A_BXPARTY_LANG_DELETE);
		return $ret;
	}
}

class AdminPartyListTableRender extends exListTableRender {
	function _fetchHtmlHead ()
	{
		$ret=@sprintf("[<a href='index.php?end=0'>%s</a>]",_MD_A_BXPARTY_LANG_NOW_PARTY).
			@sprintf("[<a href='index.php?end=1'>%s</a>]",_MD_A_BXPARTY_LANG_ALL_PARTY);
		$ret.=parent::_fetchHtmlHead();
		return $ret;
	}
}

?>