/* $Id: googlemap_location.js,v 1.3 2012/05/09 14:02:15 ohwada Exp $ */

/* ========================================================
 * Googlemap Netcommons : API V3
 * 2012/05/01 K.OHWADA
 * http://code.google.com/intl/en/apis/maps/documentation/javascript/
 * ========================================================
 */

/* constant */
var GOOGLEMAP_ZOOM_MIN = 0;
var GOOGLEMAP_ZOOM_MAX = 17;
var GOOGLEMAP_ZOOM_DEFAULT = 12;
var GOOGLEMAP_SMALL_ICON  = "marker_small.png";
var GOOGLEMAP_DRAG_ICON   = "marker_drag.png";

/* system */
var googlemap_marker_url = "";

/* element id */
var googlemap_ele_id_list   = "googlemap_map_list";
var googlemap_ele_id_search = "googlemap_map_search";
var googlemap_ele_id_current_location = "googlemap_map_current_location";
var googlemap_ele_id_current_address  = "googlemap_map_current_address";
var googlemap_ele_id_parent_latitude  = "googlemap_map_latitude";
var googlemap_ele_id_parent_longitude = "googlemap_map_longitude";
var googlemap_ele_id_parent_zoom      = "googlemap_map_zoom";
var googlemap_ele_id_parent_address   = "googlemap_map_address";

/* setter */
var googlemap_opener_mode  = "";
var googlemap_region = "";
var googlemap_use_search_marker    = true;
var googlemap_use_draggable_marker = false;
var googlemap_use_center_marker    = false;
var googlemap_use_current_location = true;
var googlemap_use_current_address  = false;
var googlemap_use_parent_location  = false;

/* local object */
var googlemap_map = null;
var googlemap_geocoder = null;
var googlemap_marker_list = null;
var googlemap_bounds = null;
var googlemap_draggable_marker = null;
var googlemap_is_set_parent_ddress = false;

/* lang */
var googlemap_lang_latitude  = "Latitude";
var googlemap_lang_longitude = "Longitude";
var googlemap_lang_zoom      = "Zoom Level";
var googlemap_lang_not_successful = "Geocode was not successful for the following reason";
var googlemap_lang_no_match_place = "There are no place to match the address";

/* ========================================================
 * geoxml
 * ========================================================
 */
/* param: xml_url */
function googlemap_geoxml( param ) 
{
	var map = googlemap_init( param );
	var layer = new google.maps.KmlLayer( param["xml_url"] );
	layer.setMap( map );
}

/* param: map_div_id, latitude, longitude, zoom, etc */
function googlemap_init( param ) 
{
	if ( param["map_div_id"] == null ) {
		alert( "NO map div id" );
	}
	if ( param["latitude"] == null ) {
		alert( "NO latitude" );
	}
	if ( param["longitude"] == null ) {
		alert( "NO longitude" );
	}
	if ( param["zoom"] == null ) {
		alert( "NO zoom" );
	}

	var element = document.getElementById( param["map_div_id"] );
    var center  = googlemap_getLatLng( param["latitude"], param["longitude"] );
	var zoom    = googlemap_getIntZoom( param["zoom"] );

/* pan_control */
	var pan_control = true;
	if ( param["pan_control"] != null ) {
		pan_control = Boolean( param["pan_control"] );
	}

/* zoom_control */
	var zoom_control = true;
	if ( param["zoom_control"] != null ) {
		zoom_control = Boolean( param["zoom_control"] );
	}

/* map_type_control */
	var map_type_control = true;
	if ( param["map_type_control"] != null ) {
		map_type_control = Boolean( param["map_type_control"] );
	}

/* street_view_control */
	var street_view_control = true;
	if ( param["street_view_control"] != null ) {
		street_view_control = Boolean( param["street_view_control"] );
	}

/* scale_control */
	var scale_control = false;
	if ( param["scale_control"] != null ) {
		scale_control = Boolean( param["scale_control"] );
	}

/* overview_map_control */
	var overview_map_control = false;
	if ( param["overview_map_control"] != null ) {
		overview_map_control = Boolean( param["overview_map_control"] );
	}

/* overview_map_control_opened */
	var overview_map_control_opened = false;
	if ( param["overview_map_control_opened"] != null ) {
		overview_map_control_opened =  Boolean( param["overview_map_control_opened"] );
	}

/* map type */
	var map_type = "normal";
	if ( param["map_type"] != null ) {
		map_type = param["map_type"];
	}
	var map_type_id = google.maps.MapTypeId.ROADMAP;
	if ( map_type == "satellite" ) {
		map_type_id = google.maps.MapTypeId.SATELLITE;
	} else if ( map_type == "hybrid" ) {
		map_type_id = google.maps.MapTypeId.HYBRID;
	} else if ( map_type == "terrain" ) {
		map_type_id = google.maps.MapTypeId.TERRAIN;
	}

/* map_type_control_style */
	var param_map_type_control_style = "default";
	if ( param["map_type_control_style"] != null ) {
		param_map_type_control_style = param["map_type_control_style"];
	}
	var	map_type_control_style = google.maps.MapTypeControlStyle.DEFAULT;
	if ( param_map_type_control_style == "horizontal" ) {
		map_type_control_style = google.maps.MapTypeControlStyle.HORIZONTAL_BAR ;
	} else if ( param_map_type_control_style == "dropdown" ) {
		map_type_control_style = google.maps.MapTypeControlStyle.DROPDOWN_MENU;
	}

/* zoom_control_style */
	var param_zoom_control_style = "default";
	if ( param["zoom_control_style"] != null ) {
		param_zoom_control_style = param["zoom_control_style"];
	}
	var	zoom_control_style = google.maps.ZoomControlStyle.DEFAULT;
	if ( param_zoom_control_style == "small" ) {
		zoom_control_style = google.maps.ZoomControlStyle.SMALL;
	} else if ( param_zoom_control_style == "large" ) {
		zoom_control_style = google.maps.ZoomControlStyle.LARGE;
	}

    var options = {
      	center: center,
      	zoom: zoom,
  		mapTypeControl: map_type_control,
    	mapTypeControlOptions: {
      		style: map_type_control_style
    	},
      	mapTypeId: map_type_id,
  		zoomControl: zoom_control,
  		zoomControlOptions: {
    		style: zoom_control_style
  		},
  		overviewMapControl: overview_map_control,
		overviewMapControlOptions: {
      		opened: overview_map_control_opened
    	},
  		panControl: pan_control,
  		streetViewControl: street_view_control,
  		scaleControl: scale_control
    };

    var map = new google.maps.Map( element, options );
	return map;
}

function googlemap_getLatLng( lat, lng ) 
{
    var latlng = new google.maps.LatLng( parseFloat( lat ) , parseFloat( lng ) );
	return latlng;
}

function googlemap_getIntZoom( zoom ) 
{
	return Math.floor( zoom );
}

/* ========================================================
 * markers
 * ========================================================
 */
function googlemap_markers( param, marker_array, icon_array ) 
{
	var map = googlemap_init( param );

	var icons   = new Array();
	var shadows = new Array();
	if ( icon_array.length > 0 ) {
		for( i = 0 ; i < icon_array.length ; i++ ) {
			var icon_i  = icon_array[i] ;
			var icon_id = icon_i["id"];
			icons[ icon_id ]   = googlemap_createIconForMarkers( icon_i ) ;
			shadows[ icon_id ] = googlemap_createShadowForMarkers( icon_i ) ;
		}
	}

	if ( marker_array.length > 0 ) {
		for( i = 0 ; i < marker_array.length ; i++ ) {
			googlemap_createMarkerForMarkers( map, marker_array[i], icons, shadows );
		}
	}
}

/* param: image_url, image_width, image_height, anchor_x, anchor_y */
function googlemap_createIconForMarkers( param ) 
{
	if ( param["image_url"] == null ) {
		return null;
	}

	var size   = new google.maps.Size( parseInt( param["image_width"] ), parseInt( param["image_height"] ) );
	var anchor = new google.maps.Point( parseInt( param["anchor_x"] ), parseInt( param["anchor_y"] ) );
    var origin = new google.maps.Point(0, 0);
	var icon   = new google.maps.MarkerImage(
		param["image_url"], size, origin, anchor );
	return icon;
}

/* param: shadow_url, shadow_width, shadow_height */
function googlemap_createShadowForMarkers( param ) 
{
	if (( param["shadow_url"] == null )||( param["shadow_url"] == '' )) {
		return null;
	}

	var size   = new google.maps.Size( parseInt( param["shadow_width"] ), parseInt( param["shadow_height"] ) );
	var anchor = new google.maps.Point( parseInt( param["anchor_x"] ), parseInt( param["anchor_y"] ) ); 
    var origin = new google.maps.Point(0, 0);
	var icon   = new google.maps.MarkerImage(
		param["shadow_url"], size, origin, anchor );
	return icon;
}

/* param: icon_id, latitude, longitude, info */
function googlemap_createMarkerForMarkers( map, param, icons, shadows ) 
{
/* icon */
	var icon_id = parseInt( param["icon_id"] );
	var icon   = null;
	var shadow = null;

	if ( icon_id > 0 ) {
		if ( icons[ icon_id ] != null ) {
			icon = icons[ icon_id ];
		}
		if ( shadows[ icon_id ] != null ) {
			shadow = shadows[ icon_id ];
		}
	}

/* marker */
	var position = googlemap_getLatLng( param["latitude"], param["longitude"] );
	var marker_param = {
		icon:    icon,
		shadow:  shadow,
		content: param["info"]
	};
	googlemap_createMarker( map, position, marker_param );
}

/* param: icon, content */
function googlemap_createMarker( map, position, param ) 
{
	var options = {
        map:      map,
        position: position
	};

// if icon exist
	if ( param["icon"] != null ) {
		options.icon = param["icon"];
	}

// if shadow exist
	if ( param["shadow"] != null ) {
		options.shadow = param["shadow"];
	}

    var marker = new google.maps.Marker( options );

// if content exist
	if ( param["content"] != null ) {
	    var infowindow = new google.maps.InfoWindow({
    	    content: param["content"]
    	});

    	google.maps.event.addListener( marker, 'click', function() {
			infowindow.open( map, marker );
    	});
	}

	return marker;
}


/* ========================================================
 * search
 * ========================================================
 */
function googlemap_search( param ) 
{
    googlemap_geocoder = new google.maps.Geocoder();
	googlemap_marker_list = new google.maps.MVCArray();
	googlemap_map = googlemap_init( param );
}

/* --------------------------------------------------------
 * map center
 * --------------------------------------------------------
 */
/* get map center */
function googlemap_getCenterZoom()
{
	var center = googlemap_map.getCenter();
	var lat  = center.lat();
	var lng  = center.lng();
	var zoom = googlemap_map.getZoom();
	arr = new Array( lat, lng, zoom, center );
	return arr;
}

function googlemap_moveCenterZoom( lat, lng, zoom )
{
/* map */
	var center = googlemap_getLatLng( lat, lng );
	googlemap_map.setCenter( center );
	googlemap_map.setZoom( Math.floor( zoom ) );
	googlemap_map.panTo( center );

/* draggable marker */
	if ( googlemap_use_draggable_marker ) {
		googlemap_draggable_marker.setPosition( center );
	}
}

/* ========================================================
 * get location
 * ========================================================
 */
function googlemap_get_location( param ) 
{
    googlemap_geocoder = new google.maps.Geocoder();
	googlemap_marker_list = new google.maps.MVCArray();

	var lat    = param["latitude"] ;
	var lng    = param["longitude"] ;
	var zoom   = param["zoom"] ;
    var center = googlemap_getLatLng( lat, lng );

	googlemap_map = googlemap_init( param );

/* rewrite current location */
	if ( googlemap_use_current_location ) {
		googlemap_rewriteCurrentLocation( lat, lng, zoom );
	}

/* draggable maker */
	if ( googlemap_use_draggable_marker ) {
		googlemap_draggable_marker = googlemap_createDraggableMarker( center );
		googlemap_eventDraggableMarkerDragend();
	}

/* center maker */
	if ( googlemap_use_center_marker ) {
		googlemap_createCenterMarker( center );
	}

/* map event */
	googlemap_eventMapDragend();
}

/* --------------------------------------------------------
 * map event
 * --------------------------------------------------------
 */
/* Listener : map dragend */
function googlemap_eventMapDragend() 
{
	google.maps.event.addListener( googlemap_map, 'dragend', function() {

/* get map center */
		var arr = googlemap_getCenterZoom();
		var lat    = arr[0];
		var lng    = arr[1];
		var zoom   = arr[2];
		var center = arr[3];

/* move draggable_marker */
		if ( googlemap_use_draggable_marker ) {
			 googlemap_draggable_marker.setPosition( center );
		}

/* rewrite current location */
		if ( googlemap_use_current_location ) {
			googlemap_rewriteCurrentLocation( lat, lng, zoom );
		}

/* rewrite parent location */
		if ( googlemap_use_parent_location ) {
			 googlemap_setParentLatitude( lat, lng, zoom );
		}

	} );

}

/* --------------------------------------------------------
 * draggable marker
 * --------------------------------------------------------
 */
function googlemap_createDraggableMarker( center ) 
{
	var icon   = googlemap_marker_url + "/" + GOOGLEMAP_DRAG_ICON;
    var marker = new google.maps.Marker({
        map: googlemap_map,
        position: center,
        icon: icon,
		draggable: true
    });
	return marker;
}

/* Listener : draggable marker dragend */
function googlemap_eventDraggableMarkerDragend() 
{
	google.maps.event.addListener( googlemap_draggable_marker, "dragend", function() {

		window.setTimeout( function() {

/* move to the position of draggable marker at the center of map */
			var position = googlemap_draggable_marker.getPosition();
			googlemap_map.panTo( position );
		}, 

/* after 0.5 sec */
		500 );
	});
}

/* --------------------------------------------------------
 * center marker
 * --------------------------------------------------------
 */
function googlemap_createCenterMarker( center ) 
{
    var marker = new google.maps.Marker({
        map: googlemap_map,
        position: center
    });
	return marker;
}

/* --------------------------------------------------------
 * rewrite current
 * --------------------------------------------------------
 */
/* rewrite current location */
function googlemap_rewriteCurrentLocation( lat, lng, zoom ) 
{
	var ele = document.getElementById( googlemap_ele_id_current_location );
	if ( ele != null ) {
		var location = googlemap_lang_latitude + ': ' ;
		location += lat + ' / ' ;
		location += googlemap_lang_longitude + ': ';
		location += lng + ' / ' ;
		location += googlemap_lang_zoom + ': ';
		location += zoom + ' / ' ;
		ele.innerHTML = location.googlemap_htmlspecialchars();
	}
}

/* rewrite current address */
function googlemap_rewriteCurrentAddress( addr ) 
{
	var ele = document.getElementById( googlemap_ele_id_current_address );
	if ( ele != null ) {
		ele.innerHTML = addr.googlemap_htmlspecialchars(); 
	}
	if ( googlemap_is_set_parent_ddress ) {
		googlemap_setParentAddress( addr );
	}
	googlemap_is_set_parent_ddress = false;
}

/* --------------------------------------------------------
 * set & get parent
 * --------------------------------------------------------
 */
/* set location */
function googlemap_setParentCenterLocation()
{
	var arr = googlemap_getCenterZoom();
	googlemap_setParentLatitude( arr[0], arr[1], arr[2] );
}

/* set address */
function googlemap_setParentCurrentAddress()
{
	googlemap_is_set_parent_ddress = true;
	var center = googlemap_map.getCenter();
	googlemap_reverseGeocoding( center );
}

/* set & get parent */
function googlemap_getParentLatitude() 
{
	var ele_lat  = null;
	var ele_lng  = null;
	var ele_zoom = null;
	var lat  = 0;
	var lng  = 0;
	var zoom = 0;
	var flag = false;

/* self */
	if ( googlemap_opener_mode == 'self' ) {
		ele_lat  = document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = document.getElementById( googlemap_ele_id_parent_zoom );

/* opener */
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		ele_lat  = opener.document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = opener.document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = opener.document.getElementById( googlemap_ele_id_parent_zoom );

/* parent */
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		ele_lat  = parent.document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = parent.document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = parent.document.getElementById( googlemap_ele_id_parent_zoom );
	}

/* if element exist */
	if ( ele_lat != null ) {
		lat  = ele_lat.value;
	}
	if ( ele_lng != null ) {
		lng  = ele_lng.value;
	}
	if ( ele_zoom != null ) {
		zoom = ele_zoom.value;
	}

/* if parent param is set */
	if( (lat != 0) || (lng != 0) || (zoom != 0) ) {
		flag = true;
	}

	arr = new Array(flag, lat, lng, zoom);
	return arr;
}

function googlemap_setParentLatitude( latitude , longitude , zoom )
{
	var ele_lat  = null;
	var ele_lng  = null;
	var ele_zoom = null;

/* self */
	if ( googlemap_opener_mode == 'self' ) {
		ele_lat  = document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = document.getElementById( googlemap_ele_id_parent_zoom );

/* opener */
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		ele_lat  = opener.document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = opener.document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = opener.document.getElementById( googlemap_ele_id_parent_zoom );

/* parent */
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		ele_lat  = parent.document.getElementById( googlemap_ele_id_parent_latitude );
		ele_lng  = parent.document.getElementById( googlemap_ele_id_parent_longitude );
		ele_zoom = parent.document.getElementById( googlemap_ele_id_parent_zoom );
	}

/* if element exist */
	if ( ele_lat != null ) {
		ele_lat.value = parseFloat( latitude );
	}
	if ( ele_lng != null ) {
		ele_lng.value = parseFloat( longitude );
	}
	if ( ele_zoom != null ) {
		ele_zoom.value = Math.floor( zoom );
	}
}

function googlemap_getParentAddress()
{
	var ele_addr = null;
	var addr = '';

/* self */
	if ( googlemap_opener_mode == 'self' ) {
		ele_addr = document.getElementById( googlemap_ele_id_parent_address );

/* opener */
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		ele_addr = opener.document.getElementById( googlemap_ele_id_parent_address );

/* parent */
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		ele_addr = parent.document.getElementById( googlemap_ele_id_parent_address );
	}

/* if element exist */
	if ( ele_addr != null ) {
		addr = ele_addr.value;
	}

	return addr;
}

function googlemap_setParentAddress( addr )
{
	var ele_addr = null;

/* self */
	if ( googlemap_opener_mode == 'self' ) {
		ele_addr = document.getElementById( googlemap_ele_id_parent_address );

/* opener */
	} else if (( googlemap_opener_mode == 'opener' )&&( opener != null )) {
		ele_addr = opener.document.getElementById( googlemap_ele_id_parent_address );

/* parent */
	} else if (( googlemap_opener_mode == 'parent' )&&( parent != null )) {
		ele_addr = parent.document.getElementById( googlemap_ele_id_parent_address );
	}

/* if element exist */
	if (( ele_addr != null )&&( addr != null )&&( addr != '' )) {
		ele_addr.value = addr.googlemap_htmlspecialchars();
	}
}

/* --------------------------------------------------------
 * geocoding
 * --------------------------------------------------------
 */
function googlemap_searchAddress( address ) 
{
	googlemap_geocoding( address );
}

function googlemap_geocoding( address ) 
{
	var request = { 'address': address };
	if ( googlemap_region != '' ) {
		request = { 'address': address, 'region': googlemap_region };
	}

    googlemap_geocoder.geocode( request, function( results, status ) {
      if ( status == google.maps.GeocoderStatus.OK ) {
		googlemap_geocodingResult( results );

      } else {
		/* error */
		var msg = googlemap_lang_not_successful + ": " + status;
		googlemap_writeListHtmlspecialchars( msg );
      }
    });
}

function googlemap_geocodingResult( results )
{
/* remove all marker */
	googlemap_removeSearchMarkers();
	googlemap_bounds = null;

	var length = results.length;

/* error */
	if ( length == 0 ) {
		googlemap_writeListHtmlspecialchars( googlemap_lang_no_match_place );
		return;
	}

/* --- start --- */
	var center = null;
	var	r    = null;
	var	addr = "";
	var	loc  = null;
	var	lat  = 0;
	var	lng  = 0;
	var list = '<ol>';

	for(var i = 0; i< length; i++) {

/* location */
		r    = results[i];
		addr = r.formatted_address;
		loc  = r.geometry.location;
		lat  = loc.lat();
		lng  = loc.lng();
		
		if ( i == 0 ) {
			center = loc;
		}

/* list */
		html = googlemap_getSearchHtml( i, lat, lng, GOOGLEMAP_ZOOM_DEFAULT, addr );
		list += '<li>' + html + '</li>' + "\n";

/* add marker */
		if ( googlemap_use_search_marker ) {
			 googlemap_addSearchMarker( i, loc, html );
		}
		googlemap_setBound( loc );
	}

	list += '</ol>';
/* --- end --- */

	googlemap_fitBounds();
	googlemap_writeList( list );

/* draggable marker */
	if ( googlemap_use_draggable_marker && (center != null) ) {
		 googlemap_draggable_marker.setPosition( center );
	}
}

function googlemap_getSearchHtml( index, lat, lng, zoom, addr )
{
	letter = googlemap_getCapitalLetter( index );
	if ( letter == '' ) {
		letter = index + 1;
	}

	func = "googlemap_moveCenterZoom(" + lat + ', '  + lng + ', ' + zoom + ")";
	link = '<a href="javascript:void(0)" onClick="' + func + '">' + addr.googlemap_htmlspecialchars() + '</a>';
	html = '<b>' + letter + '</b> ' + link;
	return html;
}

function googlemap_getCapitalLetter( index ) 
{
	var char = '';
	if (index < 26) {
		char = String.fromCharCode("A".charCodeAt(0) + index);
	}
	return char;
}

function googlemap_getSmallLetter( index ) 
{
	var char = '';
	if (index < 26) {
		char = String.fromCharCode("a".charCodeAt(0) + index);
	}
	return char;
}

function googlemap_setBound( point )
{
	// Only the first
	if ( googlemap_bounds == null ) {
		 googlemap_bounds = new google.maps.LatLngBounds();
	}
	googlemap_bounds.extend( point );
}

function googlemap_fitBounds( length )
{
	googlemap_map.fitBounds( googlemap_bounds );

	// one big size
	var zoom = googlemap_map.getZoom();
	zoom --;
	if ( zoom < GOOGLEMAP_ZOOM_MIN ) {
		 zoom = GOOGLEMAP_ZOOM_MIN;
	}
	if ( zoom > GOOGLEMAP_ZOOM_MAX ) {
		 zoom = GOOGLEMAP_ZOOM_MAX;
	}

	googlemap_map.setZoom( zoom );
}

function googlemap_addSearchMarker( index, position, content )
{
/* icon */
	var icon = googlemap_marker_url + "/". GOOGLEMAP_SMALL_ICON;
	var letter = googlemap_getSmallLetter( index );
	if ( letter ) {
		var icon = googlemap_marker_url + "/marker_" + letter + ".png";
	}

/* marker */
	var param = {
		icon: icon,
		content: content
	};
	var marker = googlemap_createMarker( googlemap_map, position, param ); 

/* marker list */
	googlemap_marker_list.push( marker );
}

/* http://googlemaps.googlermania.com/google_maps_api_v3/map_example_remove_all_markers.html */
function googlemap_removeSearchMarkers() 
{
    googlemap_marker_list.forEach( function( marker, idx ) {
		marker.setMap( null );
    });
}

function googlemap_writeListHtmlspecialchars( msg )
{
	googlemap_writeList( msg.googlemap_htmlspecialchars() )
}

function googlemap_writeList( msg )
{
	var ele = document.getElementById( googlemap_ele_id_list );
	if ( ele != null ) {
		 ele.innerHTML = msg;
	}
}

/* --------------------------------------------------------
 * reverse geocoding
 * --------------------------------------------------------
 */
function googlemap_searchReverse()
{
	var center = googlemap_map.getCenter();
	googlemap_reverseGeocoding( center );
}

function googlemap_reverseGeocoding( latlng )
{
    googlemap_geocoder.geocode({'latLng': latlng}, function(results, status) {
      if (status == google.maps.GeocoderStatus.OK) {
		googlemap_reverseGeocodingResult( results );

      } else {
		/* error */
		var msg = googlemap_lang_not_successful + ": " + status;
		googlemap_writeList( msg );
      }
    });
}

function googlemap_reverseGeocodingResult( results )
{
	if ( results[1] ) {
		var addr = results[1].formatted_address;

/* rewrite current location */
		if ( googlemap_use_current_address ) {
			googlemap_rewriteCurrentAddress( addr );
		}
	}
}

/* --------------------------------------------------------
 * String.prototype
 * --------------------------------------------------------
 */
/* reference: mygmap module's mygmap.js */
String.prototype.googlemap_htmlspecialchars = function() {
	var str = this.toString();
	str = str.replace(/\//g, "");
	str = str.replace(/&/g, "&amp;");
	str = str.replace(/"/g, "&quot;");
	str = str.replace(/'/g, "&#39;");
	str = str.replace(/</g, "&lt;");
	str = str.replace(/>/g, "&gt;");
	return str;
}

