<?php
// $Id: map.php,v 1.1.1.1 2012/03/17 09:28:13 ohwada Exp $

//=========================================================
// webmap3 module
// 2012-03-01 K.OHWADA
//=========================================================

if( ! defined( 'XOOPS_TRUST_PATH' ) ) die( 'not permit' ) ;

//=========================================================
// class webmap3_view_map
//=========================================================
class webmap3_view_map
{
	var $_xoops_param ;
	var $_map_class;
	var $_language_class;
	var $_header_class;

	var $_DIRNAME;

	var $_map_div_id = '' ;
	var $_map_func   = '' ;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function webmap3_view_map( $dirname )
{
	$this->_DIRNAME = $dirname ;
	$this->_xoops_param    =& webmap3_xoops_param::getInstance();
	$this->_map_class      =& webmap3_api_map::getSingleton( $dirname );
	$this->_language_class =& webmap3_d3_language::getSingleton(  $dirname );
	$this->_header_class   =& webmap3_xoops_header::getSingleton( $dirname );

	$this->_map_div_id = $dirname.'_map_main_0' ;
	$this->_map_func   = $dirname.'_load_map_main_0' ;
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function build_main()
{
	$this->_header_class->assign_or_get_default_css( true ) ;

	$arr = array(
		'xoops_dirname'    => $this->_DIRNAME ,
		'mydirname'        => $this->_DIRNAME ,
		'module_name'      => $this->_xoops_param->get_module_name() ,
		'is_module_admin'  => $this->_xoops_param->is_module_admin() ,

		'lang_title_search'        => $this->get_lang('TITLE_SEARCH') ,
		'lang_title_location'      => $this->get_lang('TITLE_LOCATION') ,
		'lang_title_location_desc' => $this->get_lang('TITLE_LOCATION_DESC') ,
		'lang_title_georss'        => $this->get_lang('TITLE_GEORSS') ,
		'lang_title_search_desc'   => $this->get_lang('TITLE_SEARCH_DESC') ,
		'lang_title_get_location'  => $this->get_lang('TITLE_GET_LOCATION') ,
		'lang_title_demo'          => $this->get_lang('TITLE_DEMO') ,
		'lang_search'              => $this->get_lang('SEARCH') ,
		'lang_search_list'         => $this->get_lang('SEARCH_LIST') ,
		'lang_current_location'    => $this->get_lang('CURRENT_LOCATION') ,
		'lang_current_address'     => $this->get_lang('CURRENT_ADDRESS') ,
		'lang_no_match_place'      => $this->get_lang('NO_MATCH_PLACE') ,
		'lang_address'             => $this->get_lang('ADDRESS') ,
		'lang_latitude'            => $this->get_lang('LATITUDE') ,
		'lang_longitude'           => $this->get_lang('LONGITUDE'),
		'lang_zoom'                => $this->get_lang('ZOOM') ,
		'lang_js_invalid'          => $this->get_lang('JS_INVALID') ,
		'lang_not_compatible'      => $this->get_lang('NOT_COMPATIBLE') ,
		'lang_download_kml'        => $this->get_lang('DOWNLOAD_KML') ,
		'lang_get_location'        => $this->get_lang('GET_LOCATION') ,

	);
	return $arr;
}

function init_map( $id=0, $flag_header=true )
{
	$this->_map_class->init();

	$this->_map_class->assign_google_map_js_to_head( true );
	$this->_map_class->assign_map_js_to_head(    true );
	$this->_map_class->assign_search_js_to_head( true );

	$this->_map_class->set_latitude(  $this->get_config('latitude') );
	$this->_map_class->set_longitude( $this->get_config('longitude') );
	$this->_map_class->set_zoom(      $this->get_config('zoom') );

	$this->_map_class->set_map_type_control(            $this->get_config('map_type_control') );	
	$this->_map_class->set_zoom_control(                $this->get_config('zoom_control') );	
	$this->_map_class->set_pan_control(                 $this->get_config('pan_control') );
	$this->_map_class->set_street_view_control(         $this->get_config('street_view_control') );
	$this->_map_class->set_scale_control(               $this->get_config('scale_control') );
	$this->_map_class->set_overview_map_control(        $this->get_config('overview_map_control') );
	$this->_map_class->set_overview_map_control_opened( $this->get_config('overview_map_opened') );
	$this->_map_class->set_map_type_control_style(      $this->get_config('map_type_control_style') );
	$this->_map_class->set_zoom_control_style(          $this->get_config('zoom_control_style') );
	$this->_map_class->set_map_type(                    $this->get_config('map_type') );

	$this->_map_class->set_map_div_id( $this->_map_div_id ) ;
	$this->_map_class->set_map_func(   $this->_map_func ) ;

}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function sanitize( $str )
{
	return htmlspecialchars( $str, ENT_QUOTES );
}

//---------------------------------------------------------
// config
//---------------------------------------------------------
function get_config( $name )
{
	return $this->_xoops_param->get_module_config_by_name( $name );
}

function get_config_text( $name )
{
	return $this->_xoops_param->get_module_config_text_by_name( $name );
}

//---------------------------------------------------------
// language
//---------------------------------------------------------
function get_lang( $name )
{
	return $this->_language_class->get_constant( $name );
}

// --- class end ---
}

?>