<?php
// $Id: callback.php,v 1.1.1.1 2011/12/15 02:50:13 ohwada Exp $

//================================================================
// GooglePlus Module
// 2011-12-12 K.OHWADA
//================================================================

include 'header.php';

$service  =& googleplus_xoops_service::getInstance();
$callback =  $service->get_session_callback();

if ( $callback == 2 ) {
	googleplus_callback_2();
} else {
	googleplus_callback_1();
}

exit();
// === main end ===

function googleplus_callback_1()
{
	$code = isset($_GET['code']) ? $_GET['code'] : null;

	if (defined('XOOPS_CUBE_LEGACY')) {
   		$url = XOOPS_URL . '/user.php?op=login&exauth=googleplus';
	}  else {
   		$url = XOOPS_URL . '/modules/exauth/login.php?exauth=googleplus';
	}

	$url .= '&code='.$code;

	header('Location: ' . $url );
	exit();
}

function googleplus_callback_2()
{
	global $xoopsUser;

	$REDIRECT_URL = XOOPS_URL.'/modules/googleplus/index.php';
	$REDIRECT_TIME_SUCCESS = 1;

	if (empty($xoopsUser)) {
		googleplus_callback_error( _GOOGLEPLUS_ERR_SOMETHING .' (1)' );
		exit();
	}

	$uid = $xoopsUser->getVar('uid');

	$service =& googleplus_xoops_service::getInstance();
	$exauth  =& $service->get_exauth_Instance();

	$ret = $service->init();
	if ( !$ret ) {
		googleplus_callback_error( _GOOGLEPLUS_ERR_SOMETHING .' (2)' );
		exit();
	}

	$param_callback = $service->callback( 2 );
	if ( !is_array($param_callback) ) {

		$msg  = _GOOGLEPLUS_ERR_CALLBACK ;
		$msg .= "<br />\n";
		$msg .= $service->get_error_code();
		$msg .= ' : ';
		$msg .= $service->get_error_msg();
		googleplus_callback_error( $msg );
		exit();
	}

	$user_id = $param_callback['user_id'] ;
	$token   = $param_callback['token'] ;

	$exauth_id = $exauth->get_exauth_id( $uid );
	if ( !$exauth_id ) {
		googleplus_callback_error( _GOOGLEPLUS_ERR_SOMETHING .' (3)' );
		exit();
	}

	if ( $user_id != $exauth_id ) {
		googleplus_callback_error( _GOOGLEPLUS_ERR_SOMETHING .' (4)' );
		exit();
	}

// set token if NOT set
	$token_old = $exauth->get_user_token( $uid );
	if( empty($token_old) ) {
		$ret = $exauth->set_user_token( $uid, $token );
		if( !$ret ) {
			googleplus_callback_error( _GOOGLEPLUS_ERR_SOMETHING .' (6)' );
			exit();
		}
	}

	redirect_header( $REDIRECT_URL, $REDIRECT_TIME_SUCCESS, _GOOGLEPLUS_LOGINED );
	exit();
}

function googleplus_callback_error( $msg )
{
	$REDIRECT_URL = XOOPS_URL.'/modules/googleplus/index.php';
	$REDIRECT_TIME_ERROR  = 5;

	redirect_header( $REDIRECT_URL, $REDIRECT_TIME_ERROR, $msg );
	exit();
}

?>