<?php
// $Id: Register.class.php,v 1.1 2011/03/19 15:55:35 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Register extends Exauth_Common
{
    // コンポーネント
	var	$_db           = null;
	var $_usersAction  = null;
	var $_pagesView    = null;
	var $_pagesAction  = null;
	var	$_fileUpload   = null;
	var $_mailMain     = null;
	var $_timezoneMain = null;
	var $_blocksAction = null;
	var $_uploadsAction       = null;
	var $_authoritiesView     = null;
	var $_monthlynumberAction = null;

	// ローカル変数
	var $_user_id      = null;
	var $_config_general = null;
	var $_timezone_data  = null;

	// 言語変数
	var $_lang_err_pass_disaccord  = null ;
	var $_lang_err_mes_disclaimer  = null ;
	var $_lang_err_mes_input_key   = null ;
	var $_lang_mes_error_duplicate = null ;
	var $_lang_err_file_upload_noability = null ;

	// 定数
	var	$_ACTIVATE_KEY_LEN = 8 ;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Register() 
	{
		$this->Exauth_Common();

		$this->init_dicontainer('register.dicon.ini');
		$this->init_component_common();
		$this->init_component();
		$this->init_smarty_assign('register.maple.ini');

		$this->init_exauthadmin_config();
	}

    function set_dirname_register( $dirname )
	{
		$this->set_dirname( $dirname );

		$this->set_lang_common();
		$this->set_lang_login();
		$this->set_lang_by_dirname( $dirname );
	}

    function set_lang_by_dirname( $dirname )
	{
		// dummy
	}

	function set_lang_login() 
	{
		$this->_lang_err_pass_disaccord  = EXAUTH_ERR_PASS_DISACCORD ;
		$this->_lang_err_mes_disclaimer  = EXAUTH_ERR_MES_DISCLAIMER ;
		$this->_lang_err_mes_input_key   = EXAUTH_ERR_MES_INPUT_KEY ;
		$this->_lang_mes_error_duplicate = EXAUTH_MES_ERROR_DUPLICATE ;
		$this->_lang_err_file_upload_noability = EXAUTH_ERR_FILE_UPLOAD_NOABILITY ;
	}

    function init_component()
    {
		$this->_db           =& $this->_container->getComponent("DbObject");
		$this->_usersAction  =& $this->_container->getComponent("usersAction");
		$this->_pagesView    =& $this->_container->getComponent("pagesView");
		$this->_pagesAction  =& $this->_container->getComponent("pagesAction");
		$this->_fileUpload   =& $this->_container->getComponent("FileUpload");
		$this->_mailMain     =& $this->_container->getComponent("mailMain");
		$this->_timezoneMain =& $this->_container->getComponent("timezoneMain");
		$this->_blocksAction =& $this->_container->getComponent("blocksAction");
		$this->_uploadsAction       =& $this->_container->getComponent("uploadsAction");
		$this->_authoritiesView     =& $this->_container->getComponent("authoritiesView");
		$this->_monthlynumberAction =& $this->_container->getComponent("monthlynumberAction");
	}

//---------------------------------------------------------
// ユーザ登録する
//---------------------------------------------------------
    function register( $param_input )
	{

// token が正しくないなら、登録画面を再表示する
		if ( ! $this->check_token() ) {
			$this->set_error_msg( $this->_lang_err_someting.' (1)' );
			return -1;	// retry form
		}

		$param_valid = $this->register_validate( $param_input, true );

// 入力が正しくないなら、登録画面を再表示する
		if ( !$param_valid ) {
			return -1;	// retry form
		}

// 登録と同時に承認する
		$param_valid['autoregist_approver'] = _AUTOREGIST_AUTO ;

		$param_register = $this->register_excute( $param_input + $param_valid );

// 登録できないときは、登録画面を再表示する
		if ( !isset( $param_register['user_id'] ) ) {
			return -1;	// retry form
		}

		$this->_user_id = $param_register['user_id'];
		return 0;	// OK
	}

    function get_user_id()
    {
		return $this->_user_id;
	}

//---------------------------------------------------------
// 新規登録の検査
// 参照 Login_Validator_ItemsInputs
//---------------------------------------------------------
    function register_validate( $p, $flag_allow=false )
    {
		$p_items                  = $p['items'];
		$items_public             = $p['items_public'];
		$items_reception          = $p['items_reception'];
		$items_password_confirm   = $p['items_password_confirm'];
		$autoregist_disclaimer_ok = $p['autoregist_disclaimer_ok'];
		$autoregist_input_key     = $p['autoregist_input_key'];
		$param0                   = $p['param0'];

		$config = $this->get_config_enter_exit();

    	if ($config['autoregist_use']['conf_value'] != _ON) {
			$this->set_error_code( 21 );
			return false;
    	}

    	$show_items =& $this->get_users_items_admin();
    	if ($show_items === false) {
			$this->set_error_code( 22 );
			return false;
    	}

// 外部認証のときは 特定の項目のみを処理する
		if ( $flag_allow ) {
			$show_items = $this->build_users_allow( $show_items );
		}

    	$autoregist_use_items = explode("|", $config['autoregist_use_items']['conf_value']);
    	foreach($autoregist_use_items as $autoregist_use_item) 
		{
    		$buf_arr = explode(":", $autoregist_use_item);
    		if(isset($buf_arr[0]) && $buf_arr[0] != "") {
    			$autoregist_use_items[$buf_arr[0]] = $buf_arr[0];

// 外部認証のときは 特定の項目のみを処理する
				if ( ! $flag_allow ) {
    				$autoregist_use_items_req[$buf_arr[0]] = $buf_arr[1];
    			}
			}
    	}

    	$files = $this->get_file_original_name();
    	$files_key = array_keys($files);			
    	
    	foreach ($show_items as $show_items_key => $s_items) 
		{
    		if(!isset($autoregist_use_items[$s_items['item_id']])) {
    			// 自動ログインの項目ではない
    			if(isset($p_items) && isset($p_items[$s_items['item_id']])) {
					$this->set_error_code( 23 );
					return false;
    			}
    			continue;	
    		}
    		$err_prefix = $s_items['item_id'].":";
    		if($s_items['define_flag'] == _ON && defined($s_items['item_name'])) {
    			$s_items['item_name'] = constant($s_items['item_name']);
    			$show_items[$show_items_key]['item_name'] = $s_items['item_name'];
    		}
			if($s_items['type'] == "file") {
				// File
				// 必須入力チェック
				if($s_items['require_flag'] == _ON || (isset($autoregist_use_items_req[$s_items['item_id']]) && $autoregist_use_items_req[$s_items['item_id']] == _ON)) {
					
					$error_flag = true;
					foreach($files_key as $file_key) {
						if($s_items['item_id'] == $file_key && ($files[$file_key] != "" && $files[$file_key] != null)) {
							$error_flag = false;
							break;
						}
					}
					if($error_flag) {
						//ファイルアップロード未対応携帯なのに、このファイルは必須扱いになっている...
						//
						//つまり、この携帯からは登録できないので、PCから登録していただくか、
						//管理者にお願いして、必須から任意にかえていただくことを薦めます。
						//
						if (empty($files)) {
							$this->set_error_msg(  $err_prefix.$this->_lang_err_file_upload_noability );
							$this->set_error_code( 24 );
							return false;
						} else {
							$this->set_error_msg(  $err_prefix.sprintf(_REQUIRED, $s_items['item_name']) );	
							$this->set_error_code( 25 );
							return false;
						}
					}
				}
				continue;
			}
    		
    		if(isset($p_items) && isset($p_items[$s_items['item_id']])) {
    			$content = $p_items[$s_items['item_id']];
    		} else {
    			$content = "";
    		}
    		
    		// 必須入力チェック
    		if($s_items['require_flag'] == _ON || (isset($autoregist_use_items_req[$s_items['item_id']]) && $autoregist_use_items_req[$s_items['item_id']] == _ON)) {
    			// 必須項目
    			if ($content == "") {
 					$this->set_error_msg(  $err_prefix.sprintf(_REQUIRED, $s_items['item_name']) );
					$this->set_error_code( 26 );
					continue;
    			}
    		}
    		
    		if($s_items['tag_name'] == "login_id") {
	 			// 入力文字チェック
	 			$login_id = $content;
	 			$login_len = strlen($content);
		    	if($login_len < USER_LOGIN_ID_MINSIZE || $login_len > USER_LOGIN_ID_MAXSIZE) {
 					$this->set_error_msg(  $err_prefix.sprintf(_MAXRANGE_ERROR, USER_ITEM_LOGIN, USER_LOGIN_ID_MINSIZE, USER_LOGIN_ID_MAXSIZE) );
					$this->set_error_code( 27 );
					continue;
		    	}
		    	
		    	// 半角英数または、記号
		    	if(preg_match(_REGEXP_ALLOW_HALFSIZE_SYMBOL, $login_id)) {
 					$this->set_error_msg(  $err_prefix.sprintf(_HALFSIZESYMBOL_ERROR, USER_ITEM_LOGIN) );
					$this->set_error_code( 28 );
					continue;
		    	}
	 			
	 			// 重複チェック
	 			$count = $this->get_users_count_by_login_id( $login_id );
	 			if($count >= 1) {
 					$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, USER_ITEM_LOGIN, USER_ITEM_LOGIN) );
					$this->set_error_code( 29 );
					continue;
	 			}

	 		} else if($s_items['tag_name'] == "password") {
		    	$new_password = $content;
		    	// 入力文字チェック
		    	$pass_len = strlen($new_password);
		    	if($pass_len < USER_PASSWORD_MINSIZE || $pass_len > USER_PASSWORD_MAXSIZE) {
 					$this->set_error_msg(  $err_prefix.sprintf(_MAXRANGE_ERROR, USER_ITEM_PASSWORD, USER_PASSWORD_MINSIZE, USER_PASSWORD_MAXSIZE) );
					$this->set_error_code( 31 );
					continue;
		    	}
		    	
		    	if(!isset($items_password_confirm[$s_items['item_id']]) || $new_password != $items_password_confirm[$s_items['item_id']]) {
 					$this->set_error_msg(  $err_prefix.$this->_lang_err_pass_disaccord );
					$this->set_error_code( 32 );
					continue;
	    		}
		    	// 半角英数または、記号
		    	if(preg_match(_REGEXP_ALLOW_HALFSIZE_SYMBOL, $new_password)) {
 					$this->set_error_msg(  $err_prefix.sprintf(_HALFSIZESYMBOL_ERROR, USER_ITEM_PASSWORD) );
					$this->set_error_code( 33 );
					continue;
		    	}

	 		} else if($s_items['tag_name'] == "handle") {
	 			// 重複チェック
	 			$count = $this->get_users_count_by_handle( $content );
	 			if($count >= 1) {
 					$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, USER_ITEM_HANDLE, USER_ITEM_HANDLE) );
					$this->set_error_code( 34 );
					continue;
	 			}
	 		}
	 		if($s_items['type'] == "email" || $s_items['type'] == "mobile_email") {
	 			$email = $content;
	 			
	 			// 入力文字チェック
	 			if ( $email != "" && !strpos($email, "@") ) {
 					$this->set_error_msg(  $err_prefix.sprintf(_FORMAT_WRONG_ERROR, $s_items['item_name']) );
					$this->set_error_code( 35 );
					continue;
	 			}
	 			// 重複チェック
	 			if($email != "") {
					$count = $this->get_users_count_by_email( $email );
		 			if($count >= 1) {
 						$this->set_error_msg(  $err_prefix.sprintf($this->_lang_mes_error_duplicate, $s_items['item_name'] , $s_items['item_name'] ) );
						$this->set_error_code( 36 );
						continue;
		 			}
	 			}
	 			// メール受信可否
	 			if(isset($items_reception) && isset($items_reception[$s_items['item_id']])) {
		 			if($s_items['allow_email_reception_flag'] == _OFF || 
		 				!($items_reception[$s_items['item_id']] == _ON || 
		 					$items_reception[$s_items['item_id']] == _OFF)) {

 						$this->set_error_msg(  $err_prefix._INVALID_INPUT );
						$this->set_error_code( 37 );
						continue;
		 			}
	 			}
	 			
	 		}
 			
	 		// 公開設定
	 		if(isset($items_public) && isset($items_public[$s_items['item_id']])) {
	 			if($s_items['allow_public_flag'] == _OFF || 
	 				!($items_public[$s_items['item_id']] == _ON || 
	 					$items_public[$s_items['item_id']] == _OFF)) {
					$this->set_error_msg(  $err_prefix._INVALID_INPUT );
					$this->set_error_code( 38 );
					continue;
	 			}
 			}
    	}
    	
    	// 利用許諾
    	if(!isset($autoregist_disclaimer_ok)) {
 			$this->set_error_msg(  $this->_lang_err_mes_disclaimer );
			$this->set_error_code( 39 );
    	}

 		if ( $this->_error_code ) {
			return false;
		}

    	// 入力キー
    	if ($config['autoregist_use_input_key']['conf_value'] == _ON && 
    		$config['autoregist_input_key']['conf_value'] != $autoregist_input_key) {

 			$this->set_error_msg(  $this->_lang_err_mes_input_key );
			$this->set_error_code( 41 );
			return false;
    	}
    	
    	// File
    	$filelist = $this->get_uploads_filelist();
    	
		foreach($filelist as $key => $file) {
			if(isset($file['error_mes']) && $file['error_mes'] != "" && $file['error_mes'] != _FILE_UPLOAD_ERR_UPLOAD_NOFILE) {
				$err_prefix = $key.":";
 				$this->set_error_msg(  $err_prefix.$file['error_mes'] );
				$this->set_error_code( 42 );
				return false;

            }
		}

    	if( isset($param0) && $param0 ) {
    		$name_show_items = $param0 ;
		} else {
			$name_show_items = 'show_items';
		}

		$param = array(
			$name_show_items      => $show_items,
			'autoregist_approver' => $config['autoregist_approver']['conf_value'],
			'autoregist_author'   => $config['autoregist_author']['conf_value'],
			'autoregist_defroom'  => $config['autoregist_defroom']['conf_value'],
			'config'              => $config,
			'filelist'            => $filelist,
		);

		return $param;
    }
        
	/**
	 * fetch時コールバックメソッド
	 * @param result adodb object
	 * @return array items
	 * @access	private
	 */
	function &_getItemsFetchcallback($result) 
	{
		$ret = array();
		while ($row = $result->fetchRow()) {
			$ret[$row['item_id']] = $row;
		}
		return $ret;
	}

    function get_users_items_admin()
	{
    	$where_params = array(
    		"user_authority_id" => _AUTH_ADMIN		// 管理者固定
    	);
    	$show_items =& $this->_usersView->getItems($where_params, null, null, null, array($this, "_getItemsFetchcallback"));
		return $show_items;
	}

    function get_users_count_by_login_id( $login_id )
	{
	 	// 重複チェック
	 	$where_params = array("login_id" => $login_id);
	 	$users =& $this->_usersView->getUsers($where_params);
	 	$count = count($users);
		return $count;
	}

    function get_users_count_by_handle( $handle )
	{
		// 重複チェック
	 	$where_params = array("handle" => $handle);
	 	$users =& $this->_usersView->getUsers($where_params);
	 	$count = count($users);
		return $count;
	}

    function get_users_count_by_email( $email )
	{
		// 重複チェック
		$where_param = array(
			"({items}.type = 'email' OR {items}.type = 'mobile_email')  " => null,
			"{users_items_link}.content" => $email
		);
		$chk_items =& $this->_usersView->getItems($where_param);
		$count = count($chk_items);
		return $count;
	}

	function get_file_original_name()
	{
    	return $this->_fileUpload->getOriginalName();
	}

	function get_uploads_filelist()
	{
    	return $this->_uploadsAction->uploads( _OFF );
	}

//---------------------------------------------------------
// 新規登録の処理
// 参照 Login_Action_Main_Autoregist
//---------------------------------------------------------
    function register_excute( $p )
    {
		$autoregist_approver = $p['autoregist_approver'];
		$autoregist_author   = $p['autoregist_author'];
		$autoregist_defroom  = $p['autoregist_defroom'];

		$this->_config_general = $this->get_config_general();
		$this->_timezone_data  = timezone_date();

    	// ----------------------------------------------------------------------
		// --- 基本項目(usersテーブル)                                        ---
		// ----------------------------------------------------------------------
		$user_param = $this->get_register_user_param( $p );
		$user           = $user_param['user'];
		$handle         = $user_param['handle'];
		$post_mail_body = $user_param['post_mail_body'];

		$new_user_id = $this->set_user( $user );
		if ($new_user_id === false) {
			$this->set_error_code( 43 );
			return false;
		}

		// ----------------------------------------------------------------------
		// --- 詳細項目(users_items_linkデータ登録)                           ---
		// ----------------------------------------------------------------------
		$email_arr = $this->set_users_items_link( $new_user_id, $p, $user_param );
		if ($email_arr === false) {
			$this->set_error_code( 44 );
			return false;
		}

    	$authoritiy = $this->get_authority_by_id( intval($autoregist_author) );

    	if ($autoregist_defroom == _OFF) {
    		// ----------------------------------------------------------------------
			// ---参加ルーム(pages_users_link登録)                          　　  ---
			// ----------------------------------------------------------------------
			// 自動登録時にデフォルトのルームに参加するかどうか
    		// 参加させない場合、不参加で登録する
			$result = $this->set_pages_default_room( $new_user_id );
			if ($result === false) { 
				$this->set_error_code( 45 );
				return false;
			}

    	} else {
    		// ----------------------------------------------------------------------
			// ---参加ルーム(pages_users_link登録)                          　　  ---
			// ----------------------------------------------------------------------
			// 自動登録時にデフォルトのルームに参加し、デフォルトの参加が一般で、登録会員のベース権限がゲスト権限の場合、
			// ゲストとして参加させる必要がある。
    		if($authoritiy !== false && $authoritiy['user_authority_id'] == _AUTH_GUEST) {
				$result = $this->set_pages_default_guest();
		    	if ($result === false) {
					$this->set_error_code( 46 );
					return false;
				}
			}
    	}

    	// ----------------------------------------------------------------------
		// --- プライベートスペース作成                                       ---
		// ----------------------------------------------------------------------

		$permalink_handle = preg_replace( _PERMALINK_PROHIBITION, _PERMALINK_PROHIBITION_REPLACE, $handle );

		$private_page_id = $this->set_page_private( $new_user_id, $user, $handle, $permalink_handle, $authoritiy );
    	if ($private_page_id === false) {
			$this->set_error_code( 47 );
			return false;
		}

    	// ----------------------------------------------------------------------
		// --- 月別アクセス回数初期値登録		                              ---
		// ----------------------------------------------------------------------
		$result = $this->set_monthly_number( $new_user_id, $private_page_id );
		if ($result === false) {
			$this->set_error_code( 48 );
    		return false;
    	}

    	// ----------------------------------------------------------------------
		// --- 初期ページ追加　　　　　　		                              ---
		// ----------------------------------------------------------------------
		$result = $this->set_private_room( $private_page_id, $new_user_id, $handle );
		if($result === false)  {
			$this->set_error_code( 49 );
    		return false;
    	}

    	// ----------------------------------------------------------------------
		// --- マイポータル作成　　　　　　		                              ---
		// ----------------------------------------------------------------------
		$open_private_space = $this->_config_general['open_private_space']['conf_value'];
		if( $open_private_space == _OPEN_PRIVATE_SPACE_MYPORTAL_GROUP ||
			$open_private_space == _OPEN_PRIVATE_SPACE_MYPORTAL_PUBLIC ) {

			$result = $this->set_page_mypotal( $user, $permalink_handle, $authoritiy );
    		if($result === false)  {
				$this->set_error_code( 51 );
	    		return false;
	    	}
		}

    	// ----------------------------------------------------------------------
		// --- メール送信処理            		                              ---
		// ----------------------------------------------------------------------
		$this->send_mail( $new_user_id, $autoregist_approver, $user_param, $email_arr );

		$ret = array(
			'user_id'        => $new_user_id ,
			'use_ssl'        => $this->_config_general['use_ssl']['conf_value'] ,
		 	'post_mail_body' => $post_mail_body ,
		);
		return $ret;
    }

//---------------------------------------------------------
// 基本項目 (usersテーブル) 設定
//---------------------------------------------------------
	function get_register_user_param( $p )
	{
		$items               = $p['items'];
		$items_public        = $p['items_public'];
		$items_reception     = $p['items_reception'];
		$show_items          = $p['show_items'];
		$filelist            = $p['filelist'];
		$config              = $p['config'];
		$autoregist_approver = $p['autoregist_approver'];
		$autoregist_author   = $p['autoregist_author'];

		$handle = null;
		$post_mail_body = null;

		if ($autoregist_approver == _AUTOREGIST_SELF) {
			$active_flag = _USER_ACTIVE_FLAG_MAILED;
			$activate_key = $this->_getActivateKey(LOGIN_ACTIVATE_KYE_LEN);

			$mail_autoregist_subject = $config['mail_approval_subject']['conf_value'];
			$mail_autoregist_body = $config['mail_approval_body']['conf_value']."<br />";

		} else if($autoregist_approver == _AUTOREGIST_AUTO) {
			$active_flag = _USER_ACTIVE_FLAG_ON;
			$activate_key = "";

			$mail_autoregist_subject = "";
			$mail_autoregist_body = "";

		} else {
			$active_flag = _USER_ACTIVE_FLAG_PENDING;
			$activate_key = $this->_getActivateKey(	$this->_ACTIVATE_KEY_LEN );

			$mail_autoregist_subject = $config['mail_add_announce_subject']['conf_value'];
			$mail_autoregist_body = $config['mail_add_announce_body']['conf_value']."<br />";
		}

		$user = array(
			"role_authority_id" => intval($autoregist_author),
			"activate_key" => $activate_key,
			"active_flag" => $active_flag,
			"password_regist_time" =>  $this->_timezone_data,
			"last_login_time" => "",
			"previous_login_time" => "",
			"lang_dirname" => $this->_config_general['language']['conf_value'],
			"timezone_offset" => $this->_config_general['default_TZ']['conf_value']
		);

		$users_items_link = array();
		$users_items_link_flag_arr = array();
		$files_key = array_keys( $this->get_file_original_name() );

		foreach($show_items as $item_id => $item) 
		{
			if(!isset($items[$item_id]) && !(isset($filelist[$item_id]['upload_id']))) {
				continue;
			}

			$users_items_link[$item_id] = array(
				"user_id" => 0,
				"item_id" => $item_id,
				"public_flag" => _OFF,
				"email_reception_flag" => _OFF
			);

			if($item['tag_name'] != "" && $item['tag_name'] != "user_name"  &&
					$item['tag_name'] != "email") {
				$tag_name = $item['tag_name'];
				switch ($item['tag_name']) {
					//case "role_authority_name":
					//	$tag_name = "role_authority_id";
					//	break;
					//case "active_flag_lang":
					//	$tag_name = "active_flag";
					//	break;
					case "handle":
						$handle = $items[$item_id];
						break;
					case "lang_dirname_lang":
						$tag_name = "lang_dirname";
						break;
					case "timezone_offset_lang":
						$tag_name = "timezone_offset";
						if(defined($items[$item_id])) {
							$items[$item_id] = $this->get_float_timezone( $items[$item_id] );
						}
						break;
				}
				$users_items_link_flag_arr[$item_id] = false;

				if($item['tag_name'] == "password") {
					$items[$item_id] = md5($items[$item_id]);
				} else {
					$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
				}
				$user[$tag_name] = $items[$item_id];

			} else {
				// users_items_linkデータ
				if($item['type'] == "radio" || $item['type'] == "checkbox" ||
					$item['type'] == "select") {
					if(is_array($items[$item_id])) {
						$users_items_link[$item_id]['content'] = implode("|", $items[$item_id]);
						$post_mail_body .= $item['item_name']._SEPARATOR2.implode(",", $items[$item_id])."\n";
					} else if($items[$item_id] == "") {
						$users_items_link[$item_id]['content'] = "";
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					} else {
						$users_items_link[$item_id]['content'] = $items[$item_id] . "|";
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					}
				} else {
					if(isset($filelist[$item_id]['upload_id'])) {
						$users_items_link[$item_id]['content'] = "?action=common_download_user&upload_id=".$filelist[$item_id]['upload_id'];
					} else {
						$users_items_link[$item_id]['content'] = $items[$item_id];
						$post_mail_body .= $item['item_name']._SEPARATOR2.$items[$item_id]."\n";
					}
				}
				$users_items_link_flag_arr[$item_id] = true;
			}

			if($item['allow_public_flag'] ==_ON && isset($items_public[$item_id]) &&
				$items_public[$item_id] == _ON) {
				$users_items_link[$item_id]['public_flag'] = _ON;
			}
			if($item['allow_email_reception_flag'] ==_ON && isset($items_reception[$item_id]) &&
				 $items_reception[$item_id] == _ON) {
				$users_items_link[$item_id]['email_reception_flag'] = _ON;
			}
		}

		if ( $handle == "" ) {
			$handle = _PRIVATE_SPACE_NAME;
		}

		$user_param = array( 
			'active_flag'               => $active_flag,
			'activate_key'              => $activate_key,
			'user'                      => $user, 
			'users_items_link'          => $users_items_link, 
			'users_items_link_flag_arr' => $users_items_link_flag_arr, 
			'handle'                    => $handle,
			'mail_autoregist_subject'   => $mail_autoregist_subject,
			'mail_autoregist_body'      => $mail_autoregist_body,
			'post_mail_body'            => $post_mail_body,
		);

		return $user_param;
	}

	function get_float_timezone( $str )
	{
		return $this->_timezoneMain->getFloatTimeZone( constant($str) );
	}

    /**
	 * アクティベーションキーを取得
	 *
	 * @param string $length 生成するアクティベーションキーの桁数
	 * @return string	アクティベーションキー
	 * @access	public
	 */
	function _getActivateKey($length) 
	{
		$duplicationFlag = true;

		$sql = "SELECT activate_key FROM {users} WHERE activate_key = ?";

		while ($duplicationFlag) {
			$activateKey = md5(uniqid(mt_rand(), 1));
			$activateKey = substr($activateKey, 0, $length);
			$user_params = array(
				$activateKey
			);

			$recordSet = $this->_db->execute($sql, $user_params);
			if ($recordSet === false) {
				$this->_db->addError();
				return false;
			}

			if (empty($recordSet)) {
				$duplicationFlag = false;
			}
		}

		return $activateKey;
	}

//---------------------------------------------------------
// 基本項目 (usersテーブル) 設定
//---------------------------------------------------------
	function set_user( $user )
	{
		$new_user_id = $this->_usersAction->insUser( $user );
		if ($new_user_id === false) {
			$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
			return false;
		}
		return $new_user_id;
	}

//---------------------------------------------------------
// 詳細項目 (users_items_link) 設定
//---------------------------------------------------------
	function set_users_items_link( $new_user_id, $p, $user_param )
	{
		$show_items = $p['show_items'];
		$filelist   = $p['filelist'];

		$users_items_link          = $user_param['users_items_link'];
		$users_items_link_flag_arr = $user_param['users_items_link_flag_arr'];

		//$email = "";
		$email_arr = array();
    	foreach ( $users_items_link as $item_id => $users_item_link ) 
		{
    		//$users_item_link[]
    		// users_items_linkが変更ないか、users_items_linkがなく初期値であれば
    		if ( $users_items_link_flag_arr[$item_id] == true  ) {
    			if(($users_items_link[$item_id]['content'] == '' &&
					   $users_items_link[$item_id]['public_flag'] == _OFF &&
					   $users_items_link[$item_id]['email_reception_flag'] == _OFF
					)) {
						//初期値のまま
						continue;
				}

				// 新規追加
				$users_item_link['user_id'] = $new_user_id;

    			$content = $users_item_link['content'];

    			$result = $this->_usersAction->insUserItemLink($users_item_link);
				if($result === false) {
					$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
					return false;
				}

    			if ($show_items[$item_id]['type'] == "file") {
					$upload_result = $this->set_avatar( $new_user_id, $filelist, $item_id );
					if ($upload_result === false) {
						return false;
					}

    			//} else if($show_items[$item_id]['tag_name'] == "email") {
    			} else if($show_items[$item_id]['type'] == "email" || $show_items[$item_id]['type'] == "mobile_email") {
    				$email_arr[] = $content;
    			}
			}
    	}
		return $email_arr;
	}

	function set_avatar( $new_user_id, $filelist, $item_id )
	{
		$upload_id = $filelist[$item_id]['upload_id'];
		$upload_params = array(
			"unique_id" => $new_user_id
		);
		$upload_where_params = array(
			"upload_id" => $upload_id,
		);
		$upload_result = $this->_uploadsAction->updUploads($upload_params, $upload_where_params);
		if ( $upload_result === false ) {
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// 自動登録時にデフォルトのルームに参加する
// 参加させない場合、不参加で登録する
//---------------------------------------------------------
	function set_pages_default_room( $new_user_id )
	{
		$pages =& $this->get_pages_default_room();
		if ($pages === false) { 
			return false;
		}
		if ($pages == null) {
			return true;
		}

		foreach ($pages as $page) 
		{
			// 不参加として登録
			$user_params = array(
	    		"room_id" => $page['page_id'],
	    		"user_id" => $new_user_id,
	    		"role_authority_id" => _ROLE_AUTH_OTHER,
	    		"createroom_flag" => _OFF
	    	);
			$result = $this->_pagesAction->insPageUsersLink($user_params);
		    if ($result === false) {
				return false;
			}
		}
		return true;
	}

	function get_pages_default_room()
	{
		$where_params = array(
			"default_entry_flag" => _ON,
			"space_type" => _SPACE_TYPE_GROUP,
			"private_flag" => _OFF,
			"page_id = room_id" => null
		);
		$pages =& $this->_db->selectExecute("pages", $where_params);
		return $pages;
	}

//---------------------------------------------------------
// 自動登録時にデフォルトのルームに参加し、デフォルトの参加が一般で、登録会員のベース権限がゲスト権限の場合、
// ゲストとして参加させる必要がある。
//---------------------------------------------------------
	function set_pages_default_guest()
	{
		$pages =& $this->get_pages_default_guest();
		if ($pages === false) {
			return false;
		}
		foreach($pages as $page) 
		{
			$user_params = array(
				"room_id" => $page['page_id'],
		    	"user_id" => $new_user_id,
		    	"role_authority_id" => _ROLE_AUTH_GUEST,
		    	"createroom_flag" => _OFF
		    );
			$result = $this->_pagesAction->insPageUsersLink($user_params);
			if ($result === false) {
				return false;
			}
		}
		return true;
	}

	function get_pages_default_guest()
	{
		$pages = null;
		$where_params = null;

		$auth_public = $this->_session->getParameter("_default_entry_auth_public");
		$auth_group  = $this->_session->getParameter("_default_entry_auth_group");

		//$this->_session->getParameter("_default_entry_auth_private")

		if ( $auth_public == _AUTH_GENERAL &&
			 $auth_group == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF
			);
		
		} elseif ( $auth_public == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF,
				"space_type" => _SPACE_TYPE_PUBLIC
			);

		} elseif ( $auth_group == _AUTH_GENERAL ) {
			$where_params = array(
				"page_id = room_id" => null,
				"default_entry_flag" => _ON,
				"private_flag" => _OFF,
				"space_type" => _SPACE_TYPE_GROUP
			);
		}

		if($where_params != null) {
			$pages =& $this->_db->selectExecute("pages", $where_params);
		}
		return $pages;
	}

//---------------------------------------------------------
// プライベートスペースを作成する
//---------------------------------------------------------
	function set_page_private( $new_user_id, $user, $handle, $permalink_handle, $authoritiy )
	{
   		//権限テーブルのmyroom_use_flagにかかわらずプライベートスペース作成

    	if($authoritiy !== false && $authoritiy['myroom_use_flag'] == _ON) {
    		$myroom_display_flag = _ON;
    	} else {
    		$myroom_display_flag = _PAGES_DISPLAY_FLAG_DISABLED;
    	}

		//
		// ページテーブル追加
		//
		$buf_page_private =& $this->get_page_private();
		if ($buf_page_private === false) {
			return false;
		}

		$display_sequence = $buf_page_private['display_sequence'];

		// プライベートスペース名称取得
		if(!isset($handle) || $handle == "") $handle = _PRIVATE_SPACE_NAME;

		$private_space_name = str_replace("{X-HANDLE}", $handle, $this->_config_general['add_private_space_name']['conf_value']);
		//if($this->_config_general['open_private_space']['conf_value'] == _ON) {
		//	// プライベートスペースが公開していれば、default_entry_flagをonにする
		//	$default_entry_flag = _ON;
		//} else {
			$default_entry_flag = _OFF;
		//}

		$permalink_handle = preg_replace(_PERMALINK_PROHIBITION, _PERMALINK_PROHIBITION_REPLACE, $handle);

		if(_PERMALINK_PRIVATE_PREFIX_NAME != '') {
    		$permalink = _PERMALINK_PRIVATE_PREFIX_NAME.'/'.$permalink_handle;
    	} else {
    		$permalink = $permalink_handle;
    	}
    	$permalink = $this->_pagesAction->getRenamePermaLink($permalink);

		$user_params = array(
    		"site_id" => $this->_session->getParameter("_site_id"),
    		"root_id" => 0,
    		"parent_id" => 0,
    		"thread_num" => 0,
    		"display_sequence" => $display_sequence,
    		"action_name" => DEFAULT_ACTION,
    		"parameters" => "",
    		"page_name" => $private_space_name,
    		"permalink" => $permalink,
    		"show_count" => 0,
    		"private_flag" => _ON,
    		"default_entry_flag" => $default_entry_flag,
    		"space_type" => _SPACE_TYPE_GROUP,
    		"node_flag" => _ON,
    		"shortcut_flag" => _OFF,
    		"copyprotect_flag" => _OFF,
    		"display_scope" => _DISPLAY_SCOPE_NONE,
    		"display_position" => _DISPLAY_POSITION_CENTER,
    		"display_flag" => $myroom_display_flag,
			"insert_time" => $this->_timezone_data,
			"insert_site_id" => $this->_session->getParameter("_site_id"),
			"insert_user_id" => $new_user_id,
			"insert_user_name" => $user["handle"],
			"update_time" => $this->_timezone_data,
			"update_site_id" => $this->_session->getParameter("_site_id"),
			"update_user_id" => $new_user_id,
			"update_user_name" => $user["handle"]
    	);
    	$private_page_id = $this->_pagesAction->insPage($user_params, true, false);
    	if ($private_page_id === false) {
			return false;
		}

    	//
		// ページユーザリンクテーブル追加
		//
		$user_params = array(
			"room_id" => $private_page_id,
			"user_id" => $new_user_id,
			"role_authority_id" => _ROLE_AUTH_CHIEF,
			"createroom_flag" => _OFF
		);
		$result = $this->_pagesAction->insPageUsersLink($user_params);
    	if ($result === false) {
			return false;
		}

		return $private_page_id;
	}

	function get_page_private()
	{
		$private_where_params = array(
			"thread_num" => 0,
			"private_flag" => _ON,
			"display_sequence!=0" => null
		);
		$buf_page_private =& $this->_pagesView->getPages($private_where_params, null, 1);
		if ($buf_page_private === false) {
			return false;
		}
		if(!isset($buf_page_private[0])) {
			$this->set_db_error();
			return false;
		}
		return $buf_page_private[0];
	}

//---------------------------------------------------------
// 月別アクセス回数初期値登録
//---------------------------------------------------------
	function set_monthly_number( $new_user_id, $private_page_id )
	{
		$name = "_hit_number";
		$time = timezone_date();
		$year = intval(substr($this->_timezone_data, 0, 4));
		$month = intval(substr($this->_timezone_data, 4, 2));
		$user_params = array(
			"user_id" => $new_user_id,
			"room_id" => $private_page_id,
			"module_id" => 0,
			"name" => $name,
			"year" => $year,
			"month" => $month,
			"number" => 0
		);
		$result = $this->_monthlynumberAction->insMonthlynumber($user_params);
		if($result === false)  {
    		return false;
    	}
		return true;
	}

//---------------------------------------------------------
// 初期ページ追加
//---------------------------------------------------------
	function set_private_room( $private_page_id, $new_user_id, $handle )
	{
		$result = $this->_blocksAction->defaultPrivateRoomInsert( 
			$private_page_id, $new_user_id, $handle );
		if($result === false) {
    		return false;
    	}
		return true;
	}

//---------------------------------------------------------
// マイポータル作成
//---------------------------------------------------------
	function set_page_mypotal( $user, $permalink_handle, $authoritiy )
	{
		//
		// display_sequence取得
		//
		$buf_page_private =& $this->get_page_mypotal();
		if ($buf_page_private === false) {
			return false;
		}

		if(isset($authoritiy['myportal_use_flag']) && $authoritiy['myportal_use_flag'] == _ON) {
			$display_flag = _ON;
		} else {
			$display_flag = _PAGES_DISPLAY_FLAG_DISABLED;
		}

		$display_sequence = $buf_page_private['display_sequence'];

		//
		// ページテーブル追加
		//
		$pages_params['page_name'] = $user["handle"];

		if(_PERMALINK_MYPORTAL_PREFIX_NAME != '') {
	    	$permalink = _PERMALINK_MYPORTAL_PREFIX_NAME.'/'.$permalink_handle;
	    } else {
	    	$permalink = $permalink_handle;
	    }
	    $permalink = $this->_pagesAction->getRenamePermaLink($permalink);
 
		$pages_params['permalink'] = $permalink;
		$pages_params['default_entry_flag'] = _ON;
		$pages_params['display_flag'] = $display_flag;
		$pages_params['display_sequence'] = $display_sequence;

		$private_page_id = $this->_pagesAction->insPage($pages_params, true, false);
	    if ($private_page_id === false) {
			return false;
		}

    	//
		// ページユーザリンクテーブル追加
		//
		$pages_users_link_params['room_id'] = $private_page_id;
		$result = $this->_pagesAction->insPageUsersLink($pages_users_link_params);
	    if ($private_page_id === false) {
			return false;
		}

		//
		// 月別アクセス回数初期値登録
		//
		$monthlynumber_params['room_id'] = $private_page_id;
		$result = $this->monthlynumberAction->insMonthlynumber($monthlynumber_params);
		if($result === false) {
    		return false;
    	}
		return true;
	}

	function get_page_mypotal()
	{
		$private_where_params = array(
			"thread_num" => 0,
			"private_flag" => _ON,
			"display_sequence!=0" => null,
			"default_entry_flag" => _ON
		);
		$buf_page_private =& $this->_pagesView->getPages($private_where_params, null, 1);
		if ($buf_page_private === false) {
			return false;
		}
		if(!isset($buf_page_private[0])) {
			$this->set_db_error();
			return false;
		}
		return $buf_page_private[0];
	}

//---------------------------------------------------------
// メール送信処理
//---------------------------------------------------------
	function send_mail( $new_user_id, $autoregist_approver, $user_param, $email_arr )
	{
		$activate_key            = $user_param['activate_key'];
		$user                    = $user_param['user'];
		$mail_autoregist_subject = $user_param['mail_autoregist_subject'];
		$mail_autoregist_body    = $user_param['mail_autoregist_body'];
		$post_mail_body          = $user_param['post_mail_body'];

		if ( $mail_autoregist_subject == "" || count($email_arr) == 0) {
			return true;
		}

		if ( $autoregist_approver == _AUTOREGIST_SELF) {
			// ユーザ自身の確認が必要
			$mail_autoregist_body .= "<br />".BASE_URL. INDEX_FILE_NAME.
						"?action=login_action_main_approver" .
						"&user_id=" . $new_user_id . "&activate_key=". $activate_key."&_header="._OFF. "<br />";

			foreach($email_arr as $email) 
			{
				$user['email'] = $email;
				$user['type'] = "text";	// Text固定(html or text)
				$this->_mailMain->addToUser($user);
			}

		} else {
			// 管理者の承認が必要
			$mail_autoregist_body .= $post_mail_body."<br />".BASE_URL. INDEX_FILE_NAME.
						"?action=login_action_main_approver" .
						"&user_id=" . $new_user_id . "&activate_key=". $activate_key."&_header="._OFF. "<br />";
			// 管理者取得
			$users = $this->get_send_mail_users_admin();
			$this->_mailMain->setToUsers($users);
		}

		$this->_mailMain->setSubject($mail_autoregist_subject);
		$this->_mailMain->setBody($mail_autoregist_body);

		$meta =& $this->_session->getParameter("_meta");
		$tags["X-SITE_NAME"] = htmlspecialchars($meta['sitename']);

		$this->_mailMain->assign($tags);
		$this->_mailMain->send();

		return true;
	}

	function get_send_mail_users_admin()
	{
		$this->_usersView =& $this->_container->getComponent("usersView");
		$users = $this->_usersView->getSendMailUsers(null, _AUTH_ADMIN, "text");
		return $users;
	}

//---------------------------------------------------------
// user 情報を取得する
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_login_user_param( $user_id )
	{
		$user = $this->get_user_by_user_id( $user_id );
		return $this->get_user_param_extra( $user );
	}

	function get_user_by_user_id( $user_id )
	{
		$result = $this->_db->execute("SELECT login_id,handle,role_authority_id,timezone_offset,last_login_time,system_flag,lang_dirname,password FROM {users} WHERE user_id=? AND active_flag="._USER_ACTIVE_FLAG_ON,array($user_id),0,null,false);
		if( !is_array($result) ) {
			$this->set_error_admin( $this->_db->ErrorMsg() );
			$this->set_error_code( 52 );
			return false;
		}

		if( !isset($result[0][0]) ) {
			$this->set_error_code( 53 );
			return false;
		}

		$ret = array(
			"user_id"             => $user_id,
			"login_id"            => $result[0][0],
			"handle"              => $result[0][1],
			"role_authority_id"   => $result[0][2],
			"timezone_offset"     => $result[0][3],
			"last_login_time"     => $result[0][4],
			"system_flag"         => $result[0][5],
			"lang_dirname"        => $result[0][6],
			"password_md5"        => $result[0][7],
		);
		return $ret;
	}

//---------------------------------------------------------
// DBエラーを設定する
//---------------------------------------------------------
	function set_db_error()
	{
		$this->_db->addError(get_class($this), sprintf(_INVALID_SELECTDB, "pages"));
	}

//---------------------------------------------------------
// 権限を取得する
//---------------------------------------------------------
	function get_authority_by_id( $id )
	{
    	return $this->_authoritiesView->getAuthorityById( $id );
	}

//---------------------------------------------------------
// パスワードを自動生成する
//---------------------------------------------------------
    function create_password( $length=10, $type='pronounceable', $chars='' )
	{
   		require_once 'Text/Password.php';
		$str = Text_Password::create( $length, $type, $chars );
		return $str;
	}

//---------------------------------------------------------
// 外部認証のときの処理
//---------------------------------------------------------
    function build_exauth_items( $items )
    {
		$id_login    = $this->get_item_id_by_name( 'USER_ITEM_LOGIN' );
		$id_handle   = $this->get_item_id_by_name( 'USER_ITEM_HANDLE' );
		$id_password = $this->get_item_id_by_name( 'USER_ITEM_PASSWORD' );

		$config_handle = $this->get_allow_config( 'handle' );

// パスワードを自動生成する
		$items[ $id_password ] = $this->create_password();

// ハンドル名がなければ、ログイン名で代用する
		if ( !isset( $items[ $id_handle ] ) || empty( $items[ $id_handle ] )) {
			$items[ $id_handle ] = $items[ $id_login ];
		}

		return $items;
	}

	function build_users_allow( $items )
	{
		$arr = array();
    	foreach ( $items as $key => $item ) 
		{
			if ( $this->is_allow_user_item( $item ) ) {
				$arr[ $key ] = $this->build_user_item( $item );
			}
		}
		return $arr;
	}

	function is_allow_user_item( $item )
	{
		$tag_name = $item['tag_name'] ;
		$ret = false;

		switch ( $tag_name )
		{
			case 'login_id':
			case 'handle':
				$ret = true;
				break;

			case 'email':
				if ( $this->get_allow_config( $tag_name ) > 0 ) {
					$ret = true;
				}
				break;
		}
		return $ret;
	}

	function build_user_item( $item )
	{
		return $this->build_user_item_require_flag( $item );
	}

// === class end ===
}
?>