<?php
// $Id: Login.class.php,v 1.2 2011/03/19 15:55:18 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Login extends Exauth_Common
{
    // コンポーネント
	var $_usersAction     = null;
	var $_pagesView       = null;
	var $_authoritiesView = null;
	var $_mobileAction    = null;
	var	$_db              = null;

	// ローカル変数
	var $_user_id  = null;
	var $_login_redirect_url = null;

	// 言語変数
	var $_lang_action_closesite = null ;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Login() 
	{
		$this->Exauth_Common();

		$this->init_dicontainer('login.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('login.maple.ini');
	}

    function set_dirname_login( $dirname )
	{
		$this->set_dirname( $dirname );

		$this->set_lang_common();
		$this->set_lang_login();
		$this->set_lang_by_dirname( $dirname );
	}

    function set_lang_by_dirname( $dirname )
	{
		// dummy
	}

	function set_lang_login() 
	{
		$this->_lang_action_closesite    = EXAUTH_ACTION_CLOSESITE ;
	}

    function init_component()
    {
		$this->_db           =& $this->_container->getComponent("DbObject");

		$this->_usersAction  =& $this->_container->getComponent("usersAction");
		$this->_pagesView    =& $this->_container->getComponent("pagesView");

		$this->_mobileAction =& $this->_container->getComponent("mobileAction");
		$this->_authoritiesView =& $this->_container->getComponent("authoritiesView");
	}

//---------------------------------------------------------
// ログインする
//---------------------------------------------------------
    function login_by_param( $param_input )
	{
		$login_id = $param_input['login_id'] ;
		$password = $param_input['password'] ;

// token が正しくないなら、ログイン画面を再表示する
		if ( ! $this->check_token() ) {
			$this->set_error_msg( $this->_lang_err_someting.' (1)' );
			return -1;	// retry form
		}

// 入力が正しくないなら、ログイン画面を再表示する
		if ( empty($login_id) || empty($password) ) {
			$this->set_error_msg( $this->_lang_err_someting.' (2)' );
			return -1;	// retry form
		}

// ログイン認証
		$user = $this->get_user_by_login_password( $login_id, $password );
		if ( !isset($user['user_id']) ) {
			$this->set_error_msg( $this->_lang_err_someting.' (3)' );
			return -1;	// retry form
		}

		$this->_user_id = $user['user_id'];
		$param_user = $this->get_user_param_extra( $user );

// user 情報が取得できないときは、エラー表示
		if ( !$param_user ) {
			return -2;	// error
		}

// リダイレクト先の設定
		if ( isset( $param_input['redirect_url'] )) {
			$param_user['redirect_url'] = $param_input['redirect_url'];
		}

// ログイン処理
		$this->login_excute( $param_user );
		return 0;	// OK
	}

    function get_user_id()
    {
		return $this->_user_id;
	}

//---------------------------------------------------------
// ログインする
//---------------------------------------------------------
    function login_by_userid( $user_id, $redirect_url )
	{
		$param_user = $this->get_login_user_param( $user_id );

// user 情報が取得できないときは、エラー表示
		if ( !isset( $param_user['user_id'] ) ) {
			return -2;	// error
		}

// リダイレクト先の設定
		if ( $redirect_url ) {
			$param_user['redirect_url'] = $redirect_url;
		}

// ログイン処理
		$this->login_excute( $param_user );
		return 0;	// OK
	}

//---------------------------------------------------------
// ログイン処理
// 参照 Login_Action_Main_Init
//---------------------------------------------------------
	function login_excute( $p )
	{
		$user_id         = $p['user_id'] ;
		$login_id        = $p['login_id'] ;
		$last_login_time = $p['last_login_time'];
		$redirect_url    = isset($p['redirect_url']) ? $p['redirect_url'] : null ;

		$mobile_flag = $this->_session->getParameter("_mobile_flag");

		$this->set_session_in_login( $p );

		$ret = $this->update_last_login_time( $user_id, $last_login_time );
		if ( ( $mobile_flag != _ON ) && $ret ) {
			$this->set_cookie_in_login( $login_id );
		}

		$this->_login_redirect_url = 
			$this->get_login_redirect_url_by_userid( 
				$user_id, $redirect_url );
		return true;
	}

	function get_login_redirect_url()	
	{
		return $this->_login_redirect_url;
	}

	function set_session_in_login( $p )
	{
		$login_id            = $p['login_id'] ;
		$user_id             = $p['user_id'] ;
		$handle              = $p['handle'] ;
		$role_authority_id   = $p['role_authority_id'] ;
		$timezone_offset     = $p['timezone_offset'] ;
		$last_login_time     = $p['last_login_time'] ;
		$system_flag         = $p['system_flag'] ;
		$lang_dirname        = $p['lang_dirname'] ;
		$user_authority_id   = $p['user_authority_id'] ;
		$allow_attachment    = $p['allow_attachment'] ;
		$allow_htmltag_flag  = $p['allow_htmltag_flag'] ;
		$role_authority_name = $p['role_authority_name'] ;
		$allow_attachment    = $p['allow_attachment'] ;
		$allow_layout_flag   = $p['allow_layout_flag'] ;
		$max_size            = $p['max_size'] ;
		$allow_video         = $p['allow_video'] ;

   		$this->_session->setParameter("_user_id", $user_id);  
   		$this->_session->setParameter("_login_id", $login_id);
		$this->_session->setParameter("_site_id", 0);
		$this->_session->setParameter("_handle", $handle);
		$this->_session->setParameter("_role_auth_id", $role_authority_id);
		$this->_session->setParameter("_timezone_offset", $timezone_offset);

	//role_authority_idよりデフォルト権限をセッションにセット
		$this->_session->setParameter("_role_authority_name", $role_authority_name);
		$this->_session->setParameter("_user_auth_id", $user_authority_id);

		if( !empty($lang_dirname) ) {
			$this->_session->setParameter("_lang", $lang_dirname);
		}

	// 添付関連をセッションに保存
		$this->_session->setParameter("_allow_attachment_flag", $allow_attachment);
    	$this->_session->setParameter("_allow_htmltag_flag", $allow_htmltag_flag);
    	$this->_session->setParameter("_allow_video_flag", $allow_video);

    // レイアウトできるかどうか(ヘッダー、左右カラムの表示非表示切り替え)
    // この値がON＋主担であれば切り替え可能
    	$this->_session->setParameter("_allow_layout_flag", $allow_layout_flag);

    // プライベートスペースに対する
	// アップロードの最大容量
    	$this->_session->setParameter("_private_max_size", $max_size);

	}

	function set_cookie_in_login( $login_id, $rememberme=false, $flag_pass=false )
	{
		$config = $this->get_config_general();

		$path = ini_get("session.cookie_path");
		$domain = ini_get("session.cookie_domain");
		$secure = ini_get("session.cookie_secure");

		$lifetime = time() + _AUTOLOGIN_LIFETIME; 	// 1 week default
		$autologin_login_cookie_name = $config['autologin_login_cookie_name']['conf_value'];
		$autologin_pass_cookie_name = $config['autologin_pass_cookie_name']['conf_value'];

		if( ($config['autologin_use']['conf_value'] == _AUTOLOGIN_LOGIN_ID || $config['autologin_use']['conf_value'] == _AUTOLOGIN_OK) &&
			$autologin_login_cookie_name != "") {
			setcookie($autologin_login_cookie_name, $login_id, $lifetime, $path, $domain, $secure);
		}

		if( $rememberme == _ON && $config['autologin_use']['conf_value'] == _AUTOLOGIN_OK &&
			$autologin_login_cookie_name != "" && $autologin_pass_cookie_name != "") {
			if ( $flag_pass ) {
				setcookie($autologin_pass_cookie_name, md5($this->password), $lifetime, $path, $domain, $secure);
			}
			setcookie($autologin_login_cookie_name, $login_id, $lifetime, $path, $domain, $secure);
		}
	}

//---------------------------------------------------------
// ログイン後のリダイレクト先を取得する
// 参照 Login_Action_Main_Init
//---------------------------------------------------------
	function get_login_redirect_url_by_userid( $user_id, $redirect_url=null )
	{
		$myroom_page = $this->get_myroom_page( $user_id );
		if( $myroom_page ) {
			$this->_session->setParameter("_self_myroom_page", $myroom_page );
		}

		if ( $redirect_url ) {
			return $redirect_url;
		}

	// リダイレクト先がないならば、デフォルト表示するページIDを取得
		$active_page = $this->_getDefaultPage();
		if ( $active_page['permalink'] != "" ) {
		 	 $active_page['permalink'] .= '/';
		}

		$permalink_flag = $this->_session->getParameter("_permalink_flag");
		if ( $permalink_flag ) {
			$url = $active_page['permalink'];
		} else {
			$url = "index.php?".ACTION_KEY."=".$active_page['action_name']."&page_id=".$active_page['page_id'].$active_page['parameters'] ;
		}

		$url = BASE_URL.'/'.$url;
		return $url;
	}

	function get_myroom_page( $user_id )
	{
		$result = $this->_db->selectExecute("pages", array("private_flag" => _ON, "thread_num" => 0, "insert_user_id" => $user_id), array("default_entry_flag" => "ASC"), 2, 0);
		if( isset($result[0]) ) {
			return $result[0];
		}
		return false;
	}

/**
 * デフォルトのpage_idを取得
 * 
 * @return array page
 * @access  public
 */
	function _getDefaultPage() 
	{
		$getData   =& $this->_container->getComponent("GetData");

    	$page = array();
    	$page_id_arr = array();
    	$_user_id = $this->_session->getParameter("_user_id");
		$config = $getData->getParameter("config");
		$first_choice_startpage = intval($config[_GENERAL_CONF_CATID]['first_choice_startpage']['conf_value']);
  		$second_choice_startpage = intval($config[_GENERAL_CONF_CATID]['second_choice_startpage']['conf_value']);
  		$third_choice_startpage = intval($config[_GENERAL_CONF_CATID]['third_choice_startpage']['conf_value']);
		$default_private_space = 0;
		
  		if ($first_choice_startpage == 0) {
  			//指定なし
  			;
  		} elseif($first_choice_startpage != -1) {
  			$page_id_arr[] = $first_choice_startpage;
  		} else {
  			//プライベートスペース
  			$default_private_space = 1;
  		}

		if($second_choice_startpage == 0) {
			//指定なし
			;
		} elseif($second_choice_startpage != -1) {
			$page_id_arr[] = $second_choice_startpage;
		} else {
			//プライベートスペース
			if($default_private_space == 0) $default_private_space = 2;
		}

		if($third_choice_startpage == 0) {
			//指定なし
		;
		} elseif($third_choice_startpage != -1) {
			$page_id_arr[] = $third_choice_startpage;
		} else {
			//プライベートスペース
			if($default_private_space == 0) $default_private_space = 3;
		}

		$buf_pages_obj =& $this->_pagesView->getPageById($page_id_arr);
		$buf_page_obj = "";
		$show_page_id = 0;
		$set_default_private_space = 4;

		foreach($buf_pages_obj as $page_obj) {
			if(($page_obj['space_type'] == _SPACE_TYPE_PUBLIC && $page_obj['display_flag'] == _ON) ||
				($page_obj['space_type'] == _SPACE_TYPE_GROUP && $page_obj['default_entry_flag'] == _ON && $page_obj['display_flag'] == _ON && $_user_id != "0" && 
				(!isset($page_obj['role_authority_id']) || $page_obj['role_authority_id'] != _ROLE_AUTH_OTHER)) ||
				($page_obj['space_type'] == _SPACE_TYPE_GROUP && $page_obj['display_flag'] == _ON && $_user_id != "0") && (isset($page_obj['authority_id']))) {

				//閲覧できるpage_id有
				if($first_choice_startpage == $page_obj['page_id']) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 1;
				} else if($second_choice_startpage == $page_obj['page_id'] && $set_default_private_space > 2) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 2;
				} else if($third_choice_startpage == $page_obj['page_id'] && $set_default_private_space > 3) {
					$show_page_id = $page_obj['page_id'];
					$buf_pages_obj[$show_page_id] = $page_obj;
					$set_default_private_space = 3;
				}
			}
		}

	//優先順位がプライベートスペースのほうが高い場合
		if(($set_default_private_space == _OFF || $set_default_private_space > $default_private_space) && $default_private_space != 0 && $_user_id != "0") {
			//マイページからpage_id取得
			$buf_page_obj_private =& $this->_pagesView->getPrivateSpaceByUserId($_user_id, 1);
			if($buf_page_obj_private) {
				$show_page_id = $buf_page_obj_private[0]['page_id'];
				$buf_pages_obj[$show_page_id] = $buf_page_obj_private[0];
			}
		}

		if($show_page_id != 0) {
			$page_id = $show_page_id;
			$page = $buf_pages_obj[$page_id];
		}

		if(isset($page_id) && $page_id != 0){
			if(isset($buf_pages_obj[$page_id]) && $buf_pages_obj[$page_id]['node_flag'] == _ON && $buf_pages_obj[$page_id]['action_name'] == "") {
				//指定したpage_idがnodeであるならば
				//nodeの子供のうち最も近いページIDを取得
				if($buf_pages_obj[$page_id]['root_id'] == 0) {
					$root_id = $buf_pages_obj[$page_id]['page_id'];
				} else {
					$root_id = $buf_pages_obj[$page_id]['root_id'];
				}
				$where_params = array(
					"action_name!=''"=>null,
					"display_sequence!=0"=>null,
					"display_flag"=>_ON,
					"root_id"=>$root_id,
					"display_position"=>$buf_pages_obj[$page_id]['display_position'],
					"thread_num>".$buf_pages_obj[$page_id]['thread_num']=>null
				);
				$order_params =array(
					"{pages}.thread_num" => "ASC",
					"{pages}.display_sequence" => "ASC"
				);

				$buf_pages_obj_child =& $this->_pagesView->getShowPagesList($where_params, $order_params, 1, 0, array($this->_pagesView, 'fetchcallback'));

				if($buf_pages_obj_child && isset($buf_pages_obj_child[0])) {
					//親ノードの子供
					$page_id = $buf_pages_obj_child[0]['page_id'];
					$buf_pages_obj[$page_id] = $buf_pages_obj_child[0];
					$page = $buf_pages_obj[$page_id];
				}
			}
		}

		if(!isset($page_id)) {
			//デフォルトページがみつからない
			//見れるページIDを取得
			$where_params = array(
				"action_name!=''"=>null,
				"display_flag"=>_ON,
				"display_sequence!"=>0
			);
			$order_params =array(
				"{pages}.thread_num" => "ASC",
				"{pages}.display_sequence" => "ASC"
			);
			$buf_pages_obj_sub =& $this->_pagesView->getShowPagesList($where_params, $order_params, 1, 0, array($this->_pagesView, 'fetchcallback'));
			
			//少なくともバブリックページは１ページはあるとして処理
			$page_id = $buf_pages_obj_sub[0]['page_id'];
			$buf_pages_obj[$page_id] = $buf_pages_obj_sub[0];
			$page = $buf_pages_obj[$page_id];
		}

		return $page;
	}

	function update_last_login_time( $user_id, $last_login_time )
	{
		//最終ログイン日時、前回ログイン日時更新
		$params = array(
			"last_login_time"     => timezone_date(),
			"previous_login_time" => $last_login_time
		);
		$where_params = array("user_id" => $user_id);

		$ret = $this->_usersAction->updUsers($params, $where_params, false);
		if ( !$ret ) {
			$this->set_error_admin(  $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 11 );
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// ログイン認証を行う
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_user_by_login_password( $login_id, $password )
	{
		$password_md5 = md5( $password );
		$params = array(
			"login_id" => $login_id ,
			"password" => $password_md5
		);

		$result = $this->_db->execute("SELECT user_id,handle,role_authority_id,timezone_offset,last_login_time,system_flag,lang_dirname FROM {users} WHERE login_id=? AND password=? AND active_flag="._USER_ACTIVE_FLAG_ON,$params,0,null,false);

		if( !is_array($result) ) {
			$this->set_error_admin( $this->_db->ErrorMsg() );
			$this->set_error_code( 12 );
			return false;
		}

		if( !isset($result[0][0]) ) {
			$this->set_error_code( 13 );
			return false;
		}

		$ret = array(
			"login_id"            => $login_id,
			"password_md5"        => $password_md5,
			"user_id"             => $result[0][0],
			"handle"              => $result[0][1],
			"role_authority_id"   => $result[0][2],
			"timezone_offset"     => $result[0][3],
			"last_login_time"     => $result[0][4],
			"system_flag"         => $result[0][5],
			"lang_dirname"        => $result[0][6],
		);

		return $ret;
	}

//---------------------------------------------------------
// user 情報を取得する
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_login_user_param( $user_id )
	{
		$user = $this->get_user_by_user_id( $user_id );
		return $this->get_user_param_extra( $user );
	}

	function get_user_by_user_id( $user_id )
	{
		$result = $this->_db->execute("SELECT login_id,handle,role_authority_id,timezone_offset,last_login_time,system_flag,lang_dirname,password FROM {users} WHERE user_id=? AND active_flag="._USER_ACTIVE_FLAG_ON,array($user_id),0,null,false);
		if( !is_array($result) ) {
			$this->set_error_admin( $this->_db->ErrorMsg() );
			$this->set_error_code( 234 );
			return false;
		}

		if( !isset($result[0][0]) ) {
			$this->set_error_code( 235 );
			return false;
		}

		$ret = array(
			"user_id"             => $user_id,
			"login_id"            => $result[0][0],
			"handle"              => $result[0][1],
			"role_authority_id"   => $result[0][2],
			"timezone_offset"     => $result[0][3],
			"last_login_time"     => $result[0][4],
			"system_flag"         => $result[0][5],
			"lang_dirname"        => $result[0][6],
			"password_md5"        => $result[0][7],
		);
		return $ret;
	}

//---------------------------------------------------------
// user 拡張情報を取得する
// 参照 Login_Validator_Logincheck
//---------------------------------------------------------
	function get_user_param_extra( $p )
	{
		$user_id      = $p['user_id'] ;
		$login_id     = $p['login_id'] ;
		$handle       = $p['handle'] ;
		$password_md5 = $p['password_md5'] ;
		$role_authority_id = $p['role_authority_id'] ;

		$authorities =& $this->get_authority_by_id( $role_authority_id );

		if( $authorities === false || !isset($authorities['user_authority_id']) ) {
			$this->set_error_code( 14 );
			return false;
		}

		$config = $this->get_config_general();
		if( $config['closesite']['conf_value'] == _ON && $authorities['user_authority_id'] < $config['closesite_okgrp']['conf_value']) {
			// return LOGIN_ACTION_CLOSESITE;
			$this->set_error_msg( $this->_lang_action_closesite );
			$this->set_error_code( 15 );
			return false;
		}

		$this->_mobileAction->setLogin( $user_id, $login_id, $password_md5, $handle );

		if( $authorities['allow_video'] != _OFF ) {
			$module = $this->_modulesView->getModuleByDirname("multimedia");
		   	if(isset($module['module_id'])) {
				$allow_video = 2 ;
			} else {
				$allow_video =_ON ;
			}
		} else {
			$allow_video = $authorities['allow_video'] ;
		}

		$ret = array(
			"user_id"             => $user_id ,
			"login_id"            => $p['login_id'] ,
			"handle"              => $handle ,
			"role_authority_id"   => $role_authority_id ,
			"timezone_offset"     => $p['timezone_offset'] ,
			"last_login_time"     => $p['last_login_time'] ,
			"system_flag"         => $p['system_flag'] ,
			"lang_dirname"        => $p['lang_dirname'] ,
			"user_authority_id"   => $authorities['user_authority_id'],
			"allow_attachment"    => $authorities['allow_attachment'],
			"allow_htmltag_flag"  => $authorities['allow_htmltag_flag'],
			"role_authority_name" => $authorities['role_authority_name'],
			"allow_attachment"    => $authorities['allow_attachment'],
			"allow_layout_flag"   => $authorities['allow_layout_flag'],
			"max_size"            => $authorities['max_size'],
			"allow_video"         => $allow_video ,
		);

		return $ret;
	}


//---------------------------------------------------------
// 権限を取得する
//---------------------------------------------------------
	function get_authority_by_id( $id )
	{
    	return $this->_authoritiesView->getAuthorityById( $id );
	}

// === class end ===
}
?>