<?php
// $Id: Install.class.php,v 1.1 2011/03/16 13:50:10 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Install extends Exauth_Common
{
    // コンポーネント
	var $_db = null;
	var $_usersAction = null;

	var	$_flag_uploads_path = false;
	var $_uploads_sub_paths = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Install()
	{
		$this->Exauth_Common();

		$this->init_dicontainer('install.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('install.maple.ini');
	}

    function init_component()
    {
		$this->_db          =& $this->_container->getComponent("DbObject");
		$this->_usersAction =& $this->_container->getComponent("usersAction");
	}

    function set_uploads_sub_paths( $v=null )
	{
		$this->_flag_uploads_path = true;
		if ( is_array($v) ) {
			$this->_uploads_sub_paths = $v;
		} elseif ( $v ) {
			$this->_uploads_sub_paths[] = $v;
		}
	}

//---------------------------------------------------------
// インストールを行う
// false を返しても エラーメッセージが出来るが インストールされる
//---------------------------------------------------------
	function execute_install()
	{
		$items = $this->get_module_item_name_list();
		if ( !is_array($items) || !count($items) ) {
			echo "item name が取得できない : Exauth_Install <br />\n";
			return false;
		}

		$ret = $this->add_user_items( $items );
		if ( !$ret ) {
			return false;
		}

		$ret = $this->add_uploads_path();
		if ( !$ret ) {
			return false;
		}

		return true;
	}

//---------------------------------------------------------
// ユーザ項目を追加する
//---------------------------------------------------------
	function add_user_items( $add_items )
	{
		$error = false;
		$user_items = $this->get_user_items();

		$flags = array();
		foreach ( $add_items as $name ) {
			$flags[ $name ] = true;
		}

		foreach ( $user_items as $item )
		{
			foreach ( $add_items as $name ) 
			{
				if ( $item['item_name'] == $name ) {
					$flags[ $name ] = false;
				}
			}
		}

		foreach ( $add_items as $name ) 
		{
			if ( $flags[ $name ] ) {
				$ret = $this->add_user_item( $name, 'text' );
				if ( !$ret ) {
					$error = true;
					echo "item name: $name が設定できない : Exauth_Install <br />\n";
				}
			}
		}

		if ( $error ) {
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// ユーザ項目を取得する
//---------------------------------------------------------
	function get_user_items()
	{
		return $this->_usersView->getItems();
	}

//---------------------------------------------------------
// ユーザ項目を設定する
// 参照 User_Action_Admin_Additem
//---------------------------------------------------------
	function add_user_item( $item_name, $type )
	{
		$max_row = $this->_db->maxExecute("items", "row_num") + 1;

		$type = 'text';
		$require_flag = 0;	// 必須項目にするか
		$define_flag  = 0;
		$allow_public_flag = 0;
		$allow_email_reception_flag = 0;

		$param = array(
			"item_name" => $item_name,
			"type" => $type,
			"tag_name" => "",			//固定
			"system_flag" => _OFF,		//固定
			"require_flag" => intval($require_flag),
			"define_flag" => intval($define_flag),
			"display_flag" => _ON,		//固定
			"allow_public_flag" => intval($allow_public_flag),
			"allow_email_reception_flag" => $allow_email_reception_flag,
			"col_num" => 1,				//固定
			"row_num" => $max_row
		);

		// 追加
		$item_id = $this->_usersAction->insItem($param);
		if ($item_id === false) {
			return false;
		}
			
		//
		// items_authorities_link デフォルト値登録
		//
		$param = array(
			"item_id"           => $item_id ,
			'under_public_flag' => USER_NO_PUBLIC ,
			'self_public_flag'  => USER_NO_PUBLIC ,
			'over_public_flag'  => USER_NO_PUBLIC ,
		);

		// 管理者
		$param_admin = $param ;
		$param_admin['user_authority_id'] = _AUTH_ADMIN;
		$param_admin['self_public_flag']  = USER_EDIT;
		$param_admin['over_public_flag']  = USER_EDIT;

		$result = $this->_usersAction->insItemsAuthLink($param_admin);
		if ($result === false) {
			return false;
		}

		// 主担 
		$param['user_authority_id'] = _AUTH_CHIEF;
			
		$result = $this->_usersAction->insItemsAuthLink($param);
		if ($result === false) {
			return false;
		}

		// モデレータ
		$param['user_authority_id'] = _AUTH_MODERATE;
			
		$result = $this->_usersAction->insItemsAuthLink($param);
		if ($result === false) {
			return false;
		}
			
		// 一般
		$param['user_authority_id'] = _AUTH_GENERAL;
			
		$result = $this->_usersAction->insItemsAuthLink($param);
		if ($result === false) {
			return false;
		}

		// ゲスト
		$param['user_authority_id'] = _AUTH_GUEST;

		$result = $this->_usersAction->insItemsAuthLink($param);
		if ($result === false) {
			return false;
		}

		return true;
	}

//---------------------------------------------------------
// uploads の ディレクトリを追加する
//---------------------------------------------------------
	function add_uploads_path()
	{
		if ( !$this->_flag_uploads_path ) {
			return true;
		}

		$dir = $this->get_module_uploads_dir();

		if ( is_array($this->_uploads_sub_paths) ) {
			foreach ( $this->_uploads_sub_paths as $path ) {
				$dir .= $path .'/' ;
			}
		}

		$mode = 0777;
		$recursive = true;

		if ( file_exists($dir) ) {
			return true;
		}

		$ret = mkdir( $dir, $mode, $recursive );
		if ( !$ret ) {
			echo "ディレクトリ: $dir が作成できない : Exauth_Install <br />\n";
		}
		return $ret;
	}

// === class end ===
}
?>