<?php
// $Id: Validator_GooglemapView.class.php,v 1.2 2010/05/11 22:51:02 ohwada Exp $

//=========================================================
// Googlemap Netcommons
// 2009-01-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlemap表示チェックバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
/**
 *  caller: Googlemap_View_Main_Init, Googlemap_View_Edit_Modify, Googlemap_View_Edit_Preview
 */
class Googlemap_Validator_GooglemapView extends Validator
{
    /**
     * Googlemap表示チェックバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {
// partsレコードの取得
		$container   =& DIContainerFactory::getContainer();
		$actionChain =& $container->getComponent("ActionChain");
		$actionName =   $actionChain->getCurActionName();
		$googlemapView =& $container->getComponent("googlemapView");

		if ($actionName == "googlemap_view_main_init") {
			$parts_data = $googlemapView->getCurPartsData();
		} else {
			$parts_data = $googlemapView->getPartsData();
		}
		if ( empty($parts_data) ) {
			return $errStr;
		}

// サニタイズ
		$parts_data["parts_info"] = $this->sanitize_parts_info( $parts_data["parts_info"] );

		$request =& $container->getComponent("Request");
		$request->setParameter("parts_data", $parts_data);

// Config変数の取得
		$config = $googlemapView->getConfig();
		$request->setParameter("apikey", $config['apikey'] );

        return;
    }

//---------------------------------------------------------
// TAB \x09 \t
// LF  \xOA \n
// CR  \xOD \r
//---------------------------------------------------------
    function sanitize_parts_info( $str )
	{
		$str = $this->replace_control_code( $str );
		$str = $this->escape_double_quote( $str );
		return $str;
	}
    function replace_control_code( $str, $replace='' )
	{
		return preg_replace( "/\t|\n|\r/", $replace, $str );
	}
    function escape_double_quote( $str )
	{
		return str_replace( '"', '\"', $str );
	}

}
?>