<?php
// $Id: index.php,v 1.1.1.1 2011/05/10 13:37:44 ohwada Exp $

//=========================================================
// メール受信
// 2011-05-01 K.OHWADA
//=========================================================

//---------------------------------------------------------
$host = 'ssl://pop.gmail.com:995';
$user = 'pop.ohwada';
$pass = '';
//---------------------------------------------------------

$pear_dir = dirname( __FILE__ ) .'/PEAR';
set_include_path( get_include_path() . PATH_SEPARATOR . $pear_dir );

require_once 'Net/POP3.php';
require_once 'Mail/mimeDecode.php';

require_once 'class/mail_pop3.php';
require_once 'class/mail_decode.php';

$flag = false;

if ( isset($_POST['submit']) ) {
	$host = $_POST['host'];
	$user = $_POST['user'];
	$pass = $_POST['pass'];
	$flag = true;
}

$host_html = htmlspecialchars( $host );
$user_html = htmlspecialchars( $user );
$pass_html = htmlspecialchars( $pass );

$header = <<<EOF
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>メール受信のデモ</title>
</head>
<body>
EOF;

$text = <<<EOF
<h3>メール受信のデモ</h3>
POP サーバーからメールを受信するデモです<br>
<br>
Gmail にテスト用のアカウントを用意しています<br>
ユーザ名は ｐｏｐ．ｏｈｗａｄａ です<br>
パスワードは ７ｚＩＺｈ６ｕｄｋ です<br>
全角で表示していますが半角文字です<br>
ここに何か送信してから、受信してください<br>
<br>
<form action="index.php" method="post">
ホスト名　 <input type="text" name="host" value="$host_html" size="40"><br>
ユーザ名　 <input type="text" name="user" value="$user_html" size="40"><br>
パスワード <input type="text" name="pass" value="$pass_html" size="40"><br>
<input type="submit" name="submit" value="メール受信"><br>
</form>
EOF;

$footer = <<<EOF
<h4>解説</h4>
PHP の PEAR ライブラリを使用しています<br>
丸数字 ①② などの機種依存文字に対応しています<br>
添付ファイルに対応しています<br>
画像の場合はブラウザに表示されます<br>
<br>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=519" target="_blank">
メール受信 POP3 PEAR/Net_POP3</a><br>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=521" target="_blank">
メール解析 PEAR/Mail_mimeDecode</a><br>
</body></html>
EOF;

echo $header;
echo $text;

if ( $flag ) {
	if ( $host && $user && $pass ) {
		mail_receive($host, $user, $pass);
	} else {
		if ( empty($host) ) {
			echo 'ホスト名を入力してください<br>';
		}
		if ( empty($user) ) {
			echo 'ユーザ名を入力してください<br>';
		}
		if ( empty($pass) ) {
			echo 'パスワードを入力してください<br>';
		}
	}
}

echo $footer;
exit();

function mail_receive($host, $user, $pass)
{
	$pop3   =& pear_mail_pop3::getInstance();
	$decode =& pear_mail_decode::getInstance();

	$msg     = '';
	$subject = '';
	$from    = '';
	$body    = '';
	$name    = '';
	$content = '';
	$ctype   = '';
	$src     = '';

	$pop3->set_max_mail(1);
	$pop3->set_host( $host );
	$pop3->set_user( $user );
	$pop3->set_pass( $pass );

	$num = $pop3->recv_mails();
	if ( $num === false ) {
		echo 'エラー <br>';
		echo implode( '<br>', $pop3->get_errors() );
		return;
	}
	if ( $num == 0 ) {
		echo 'メールなし <br>';
		return;
	}

	$mails = $pop3->get_mails();
	if ( isset($mails[0]) ) {
		$mail = $mails[0];
	} else {
		echo '何か変です <br>';
		return;
	}

	$param = $decode->decode( $mail );

	if ( isset($param['headers']['subject']) ) {
		$subject = $param['headers']['subject'];
	}
	if ( isset($param['headers']['from']) ) {
		$from = $param['headers']['from'];
	}
	if ( isset($param['body']['body_converted']) ) {
		$body = $param['body']['body_converted'];
	}
	if ( isset($param['attaches'][0]) ) {
		$attach  = $param['attaches'][0];
		if ( isset($attach['name']) ) {
			$name = $attach['name'];
		}
		if ( isset($attach['body']) ) {
			$content = $attach['body'];
		}
		if ( isset($attach['ctype_primary']) ) {
			$ctype = $attach['ctype_primary'];
		}
		if ( $name && $content ) {
			$src = 'tmp/'.rawurlencode($name);
			file_put_contents($src, $content);
		}
	}

$subject = htmlspecialchars( $subject );
$from    = htmlspecialchars( $from );
$body    = htmlspecialchars( $body );
$body    = nl2br( $body );

$text = <<<EOF
<h3>メール受信</h3>
Subject: $subject<br>
From: $from <br>
<br>
$body <br>
<br>
EOF;

$img = <<<EOF
<img src="$src" width="320"><br>
EOF;

	echo $text;
	if ($ctype == 'image') {
		echo $img;
	}
}

?>