<?php
// $Id: index.php,v 1.1.1.1 2011/05/05 12:45:36 ohwada Exp $

//=========================================================
// 日本語ファイル名でダウンロードする
// 2011-05-01 K.OHWADA
//=========================================================

$name_default = 'あい ab 12 #$%& 表能 \ / : * ? " < > |';
//---------------------------------------------------------
// あい ab 12
// 通常の文字
//
// #$%&
// 記号：通常の文字として扱われるもの
//
// 表能
// 5C文字
// http://ja.wikipedia.org/wiki/Shift_JIS
//
// \ / : * ? " < > |
// ファイル名で使えない文字
// http://www.sharp.co.jp/support/mebius/tips/tips-zz16.htm
//---------------------------------------------------------

$name_alt = 'sample.zip';
$file     = 'sample.zip';

// 投稿されたときは、ダウンロード処理へ
if ( isset($_POST['name']) ) {
	$name = $_POST['name'];
	if ($name) {
		$name .= '.zip';
		include 'download.php';
		download( $file, $name, $name_alt );
	}
}

// フォーム画面の表示
$value = htmlspecialchars($name_default,ENT_QUOTES);

$html = <<< EOF
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>日本語ファイル名でダウンロードする</title>
</head>
<body>
<h3>日本語ファイル名でダウンロードする</h3>
ファイル名となる日本語を入力します<br>
拡張子は不要です 内部で .zip が追加されます<br>
<br>
<form action="index.php" method="post">
<input type="text" name="name" value="$value" size="60">
<br>
<input type="submit" value="submit">
</form>
<h4>例の説明</h4>
あい ab 12 #$%& 表能 \ / : * ? &quot; &lt; &gt; |
<br><br>
あい ab 12<br>
通常の文字<br>
<br>
#$%& <br>
記号：通常の文字として扱われるもの<br>
<br>
表能<br>
<a href="http://ja.wikipedia.org/wiki/Shift_JIS" target="_blank">
5C文字</a><br>
<br>
\ / : * ? &quot; &lt; &gt; | <br>
<a href="http://www.sharp.co.jp/support/mebius/tips/tips-zz16.htm" target="_blank">
ファイル名で使えない文字</a><br>
<h4>参考</h4>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=516" target="_blank">
解説：日本語ファイル名でダウンロードする</a><br>
</body>
</html>
EOF;

echo $html;
exit();

?>