<?php
// $Id: download.php,v 1.1.1.1 2011/05/05 12:45:36 ohwada Exp $

//=========================================================
// 日本語ファイル名のダウンロード
// 2011-05-01 K.OHWADA
//=========================================================

//---------------------------------------------------------
// 参考
//
// 日本語ファイル名
// http://oku.edu.mie-u.ac.jp/~okumura/php/filename.php
//
// ファイル名で使えない文字
// http://www.sharp.co.jp/support/mebius/tips/tips-zz16.htm
//---------------------------------------------------------

function download( $file, $name, $name_alt )
{
	$is_rfc2231 = false;

// ファイル名で使えない文字 をアンダーバーにする
// \ / : * ? " < > |
	$search  = array('\\','/',':','*','?','"','<','>','|');
	$replace = array('_', '_','_','_','_','_','_','_','_');
	$name = str_replace( $search, $replace, $name );

// 全角空白を半角空白に
	$name = mb_convert_kana( $name, 's' );

// 半角空白をアンダーバーにする
	$name = str_replace( ' ', '_', $name );

// ブラウザを判定する
	$ua = $_SERVER['HTTP_USER_AGENT'];

	$browser = 'unknown';
	if (strstr($ua, 'MSIE') && !strstr($ua, 'Opera')) {
		$browser = 'msie';
	} elseif (strstr($ua, 'Opera')) {
		$browser = 'opera';
	} elseif (strstr($ua, 'Firefox')) {
		$browser = 'firefox';
	} elseif (strstr($ua, "Chrome")) {
		$browser = 'chrome';
	} elseif (strstr($ua, "Safari")) {
		$browser = 'safari';
	}

// 英数字だけかを判定する
	$ascii = mb_convert_encoding($name, "US-ASCII", "UTF-8");
	if ( $ascii == $name ) {
		$browser = 'ascii';
	}

// ブラウザに応じた処理
	switch ( $browser )
	{
// urlencode する
		case 'ascii':
			$name = str_replace(' ','_',$name);
			$name = rawurlencode($name);
			break;

// SJIS に変換する
		case 'msie':
			$name = mb_convert_encoding($name, "SJIS", "UTF-8");
			break;

// RFC2231形式を使用する
		case 'firefox':
		case 'chrome':
		case 'opera':
			$name = "utf-8'ja'".rawurlencode($name);
			$is_rfc2231 = true;
			break;

// UTF-8 のまま
		case 'safari':
			break;

// 諦めて代替えを使う
		default:
			$name = $name_alt;
			$name = str_replace(' ','_',$name);
			$name = rawurlencode($name);
			break;
	}

	$size = filesize( $file );
	$mime = 'application/octet-stream';

	if ( $is_rfc2231 ) {;
		$dis = 'Content-Disposition: attachment; filename*=';
	} else {
		$dis = 'Content-Disposition: attachment; filename=';
	}

	ini_set('zlib.output_compression', 'Off'); 
	mb_http_output('pass');

// ヘッダー出力
	header('Pragma: public');
	header('Cache-Control: must-revaitem_idate, post-check=0, pre-check=0');
	header('Content-Description: File Transfer');
	header('Content-Type: '. $mime );
	header('Content-Length: '. $size );
	header($dis . $name );

// ファイル出力
	ob_clean();
	flush();
	readfile($file);
	exit();
}

?>