<?php
// $Id: tweet.php,v 1.1.1.1 2010/08/30 12:51:59 ohwada Exp $

//================================================================
// Twitter Module
// 2010-08-01 K.OHWADA
//================================================================

//---------------------------------------------------------
// change log
// 2011-05-01 K.OHWADA
// set_user_param()
//---------------------------------------------------------

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$REDIRECT_URL = XOOPS_URL.'/modules/twitter/index.php';

$code = 0;
$msg  = '';

if (empty($xoopsUser)) {
	twitter_tweet_error( _TWITTER_ERR_SOMETHING .' (1)' );
	exit();
}

if ( ! $xoopsGTicket->check( true , '',  false ) ) {
	twitter_tweet_error( 'Token Error' );
	exit();
}

$uid     =  $xoopsUser->getVar('uid');
$service =& twitter_xoops_service::getInstance();

$ret = $service->init();
if ( !$ret ) {
	twitter_tweet_error( _TWITTER_ERR_SOMETHING .' (2)' );
	exit();
}

$ret = $service->set_user_param( $uid );
if ( !$ret ) {
	twitter_tweet_error( _TWITTER_ERR_SOMETHING .' (3)' );
	exit();
}

if ( !isset($_POST['twitter_status']) ) {
	twitter_tweet_error( _TWITTER_ERR_SOMETHING .' (4)' );
	exit();
}

$ret = $service->tweet( $_POST['twitter_status'] );
if ( $ret ) {
	$code = 1;
} else {
	$code = $service->get_error_code();
	$msg  = $service->get_error_msg();
}

$url  = $REDIRECT_URL;
$url .= '?code='.$code.'&msg='.urlencode($msg);

header("Location: ". $url );
exit();
// === main end ===

function twitter_tweet_error( $msg )
{
	$REDIRECT_URL = XOOPS_URL.'/modules/twitter/index.php';
	$REDIRECT_TIME_ERROR  = 5;

	redirect_header( $REDIRECT_URL, $REDIRECT_TIME_ERROR, $msg );
	exit();
}

?>