<?php
// $Id: Callback.class.php,v 1.1.1.1 2011/03/19 16:57:56 ohwada Exp $

//=========================================================
// Facebook Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/facebook/components/Service.class.php";

class Facebook_View_Main_Callback extends Action
{
	// コンポーネントを使用するため
	var $facebookView   = null;
	var $facebookAction = null;

    /**
     * @access  public
     */

//---------------------------------------------------------
// Facebook サーバ―からの callback を受け付ける
//---------------------------------------------------------
    function execute()
    {

// サービスの初期化
		$facebookService =& new Facebook_Components_Service();
		$ret = $facebookService->init();
		if ( !$ret ) {
			$this->twitterView->redirect_error_msg(
				$facebookService->get_error_msg() );
			exit();
		}

// コールバック
		$facebookService->set_base_url( 
			$this->facebookView->get_base_url() );
		$param = $facebookService->callback();

// Facebook ID が取得できないときは、エラー表示
		if ( !is_array($param) ) {
			$msg = $this->get_error(
				$facebookService->get_error_code(), 
				$facebookService->get_error_msg() );
			$this->facebookView->redirect_error_msg( $msg );
			exit();
		}

// コールバック処理
		$this->facebookAction->execute_callback( $param );
		exit();
	}

//---------------------------------------------------------
// エラーを表示する
//---------------------------------------------------------
    function get_error( $code, $msg )
    {
		$str = '';
		switch ( $code )
		{
		case 21:
		case 22:
		case 23:
			$str  = EXAUTH_ERR_AUTH_FAILED ;
			$str .= '<br />';
			$str .= $msg;
			break;

		default:
			$str = EXAUTH_ERR_UNKNOWN;
			break;
		}
		return $str;
	}

// === class end ===
}
?>