<?php
// $Id: Init.class.php,v 1.3 2011/03/25 03:01:05 ohwada Exp $

//=========================================================
// Exauth Entry Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// build_login_modules()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthentry_View_Main_Init extends Action
{
	// コンポーネントを使用するため
	var $exauthentryView   = null;
	var $session      = null;

	// リクエストパラメータを受け取るため
    var $block_id = null;

	// 値をセットするため
	var $base_url       = null;
	var	$show_ssl_login = null;
	var $show_login_modules = null;
	var $lang_login_modules = null;
	var	$show_login_nc          = true;
	var	$show_login_openid_form = true;

    /**
     * Exauthentry モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// OpneID サーバーの入力画面を表示する
//---------------------------------------------------------
    function execute()
    {
//既にログイン済
       	if ( $this->session->getParameter("_user_id") ) {
        	if( $this->block_id == 0 ) {
        		return 'success_location';
        	} else {
        		return 'success_login';	
        	}
		}

// リダイレクト先を保存する
		$this->exauthentryView->set_session_redirect_with_current_url();

// base URL を設定する
		list( $this->base_url, $this->show_ssl_login ) = 
			$this->exauthentryView->get_base_url_ssl_and_show();

// オプションがあれば、上書きする
		$show_login_nc = $this->exauthentryView->get_show_login_nc();
		if ( $show_login_nc !== false ) {
			$this->show_login_nc = $show_login_nc;
		}

		$show_login_openid_form = $this->exauthentryView->get_show_login_openid_form();
		if ( $show_login_openid_form !== false ) {
			$this->show_login_openid_form = $show_login_openid_form;
		}

		list( $this->show_login_modules, $this->lang_login_modules ) =
			$this->exauthentryView->build_login_modules();

		return 'success';
	}

// === class end ===
}
?>