<?php
// $Id: Form.class.php,v 1.2 2011/03/19 15:55:18 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Form extends Exauth_Common
{
	// 言語変数
	var $_lang_redirect_message = null ;
	var $_lang_redirect_submit  = null ;
	var $_lang_incorrect_login  = null ;
	var $_lang_caption_register = null ;
	var $_lang_caption_login    = null ;
	var $_lang_caption          = null ;
	var $_lang_register         = null ;
	var $_lang_dialog_name      = null ;
	var $_lang_top_description  = null ;
	var $_lang_require_flag     = null ;
	var $_lang_reception_email  = null ;
	var $_lang_public_flag      = null ;
	var $_lang_password_confirm = null ;
	var $_lang_login            = null ;
	var $_lang_ssl_login        = null ;
	var $_lang_login_id         = null ;
	var $_lang_password         = null ;
	var $_lang_cancel           = null ;
	var $_lang_lost_password    = null ;
	var $_lang_select_title     = null ;
	var $_lang_select_caption   = null ;
	var $_lang_select_note      = null ;
	var $_lang_select_override  = null ;
	var $_lang_yes              = null ;
	var $_lang_no               = null ;
	var $_lang_err_autoregist   = null ;
	var $_lang_register_login_title      = null ;
	var $_lang_register_login_note       = null ;
	var $_lang_register_note             = null ;
	var $_lang_login_note                = null ;
	var $_lang_autoregist_disclaimer     = null ;
	var $_lang_autoregist_disclaimer_ok  = null ;
	var $_lang_autoregist_input_key      = null ;
	var $_lang_autoregist_input_key_desc = null ;
	var $_lang_user_item_mes_auth_description = null;

	// 定数
	var $_TEMPLATE_REGISTER       = 'exauth_register.html';
	var $_TEMPLATE_LOGIN          = 'exauth_login.html';
	var $_TEMPLATE_REGISTER_LOGIN = 'exauth_register_login.html';
	var $_TEMPLATE_SELECT         = 'exauth_select.html';
	var $_TEMPLATE_REDIRECT       = 'exauth_redirect.html';

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Form() 
	{
		$this->Exauth_Common();

//		$this->init_dicontainer('form.dicon.ini');
		$this->init_component_common();
//		$this->init_component();
//		$this->init_smarty_assign('form.maple.ini');

		$this->init_exauthadmin_config();
	}

    function set_dirname_form( $dirname )
	{
		$this->set_dirname( $dirname );
		$this->init_module_id();

		$this->_action_register = $dirname.'_action_main_register';
		$this->_action_login    = $dirname.'_action_main_login';
		$this->_action_select   = $dirname.'_action_main_attach';

		$this->set_lang_common();
		$this->set_lang_form();
		$this->set_lang_by_dirname( $dirname );
	}

	function set_lang_form() 
	{
		$this->_lang_caption_register   = EXAUTH_CAPTION_REGISTER ;
		$this->_lang_caption_login      = EXAUTH_CAPTION_LOGIN ;
		$this->_lang_register           = EXAUTH_REGISTER ;
		$this->_lang_dialog_name        = EXAUTH_DIALOG_NAME ;
		$this->_lang_top_description    = EXAUTH_TOP_DESCRIPTION ;
		$this->_lang_require_flag       = EXAUTH_REQUIRE_FLAG ;
		$this->_lang_reception_email    = EXAUTH_RECEPTION_EMAIL ;
		$this->_lang_public_flag        = EXAUTH_PUBLIC_FLAG ;
		$this->_lang_password_confirm   = EXAUTH_PASSWORD_CONFIRM ;
		$this->_lang_login              = EXAUTH_LOGIN ;
		$this->_lang_ssl_login          = EXAUTH_SSL_LOGIN ;
		$this->_lang_login_id           = EXAUTH_LOGIN_ID ;
		$this->_lang_password           = EXAUTH_PASSWORD ;
		$this->_lang_cancel             = EXAUTH_CANCEL ;
		$this->_lang_lost_password      = EXAUTH_LOST_PASSWORD ;
		$this->_lang_select_title       = EXAUTH_SELECT_TITLE ;
		$this->_lang_select_caption     = EXAUTH_SELECT_CAPTION ;
		$this->_lang_select_note        = EXAUTH_SELECT_NOTE ;
		$this->_lang_select_override    = EXAUTH_SELECT_OVERRIDE ;
		$this->_lang_yes                = EXAUTH_YES ;
		$this->_lang_no                 = EXAUTH_NO ;
		$this->_lang_err_autoregist     = EXAUTH_MES_ERR_AUTOREGIST;
		$this->_lang_register_login_title      = EXAUTH_REGISTER_LOGIN_TITLE ;
		$this->_lang_register_login_caption    = EXAUTH_REGISTER_LOGIN_CAPTION ;
		$this->_lang_register_login_note       = EXAUTH_REGISTER_LOGIN_NOTE ;
		$this->_lang_register_note             = EXAUTH_REGISTER_NOTE ;
		$this->_lang_login_note                = EXAUTH_LOGIN_NOTE ;
		$this->_lang_autoregist_disclaimer     = EXAUTH_AUTOREGIST_DISCLAIMER ;
		$this->_lang_autoregist_disclaimer_ok  = EXAUTH_AUTOREGIST_DISCLAIMER_OK ;
		$this->_lang_autoregist_input_key      = EXAUTH_AUTOREGIST_INPUT_KEY ;
		$this->_lang_autoregist_input_key_desc = EXAUTH_AUTOREGIST_INPUT_KEY_DESC ;
		$this->_lang_user_item_mes_auth_description = EXAUTH_USER_ITEM_MES_AUTH_DESCRIPTION;
	}

    function set_lang_by_dirname( $dirname )
	{
		$this->set_lang( $dirname, 'register_login_title' );
		$this->set_lang( $dirname, 'register_login_caption' );
		$this->set_lang( $dirname, 'login_note' );
		$this->set_lang( $dirname, 'select_title' );
		$this->set_lang( $dirname, 'select_caption' );
		$this->set_lang( $dirname, 'select_note' );
	}

    function init_component()
    {
		// dummy
	}

//---------------------------------------------------------
// 新規登録 & ログイン フォームを表示する
// view: callback
//---------------------------------------------------------
    function callback_display_register_login_form()
    {
		$action = $this->get_register_param( true );

// action が取得できないときは、エラー表示
		if ( !$action ) {
			$this->redirect_error(
				$this->get_redirect_url(), 
				$this->get_register_param_error() );
			exit();
		}

		list( $show_register, $show_login ) 
			= $this->get_show_register_login();

		$error = '';
		$this->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// 新規登録 を表示する
// action: register
//---------------------------------------------------------
    function register_display_register_form( $param_input, $error )
    {
		$param = $this->get_register_param( true );

// $param が取得できないときは、エラー表示
		if ( !$param ) {
			$this->redirect_error(
				$this->get_redirect_url(), 
				$this->get_register_param_error() );
			exit();
		}

		$action = $this->replace_register_param( $param, $param_input );

		$this->display_register_form( $action, $error );
		exit();
	}

//---------------------------------------------------------
// ログイン フォームを表示する
// action: login
//---------------------------------------------------------
	function display_login_form( $action, $error )
	{
		$show_register = false;
		$show_login    = true;
		$this->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// 新規登録フォームを表示する
//---------------------------------------------------------
	function display_register_form( $param, $error )
	{
		$action = array(
			'items'                    => $param['items'],
			'autoregist_use_items'     => $param['autoregist_use_items'] ,
			'autoregist_disclaimer'    => $param['autoregist_disclaimer'] ,
			'autoregist_disclaimer_ok' => $param['autoregist_disclaimer_ok'] ,
		 	'autoregist_use_input_key' => $param['autoregist_use_input_key'] ,
			'autoregist_use_items_req' => $param['autoregist_use_items_req'] ,
		 	'autoregist_input_key'     => $param['autoregist_input_key'] ,

//			'items_public'             => $param['items_public'],
//			'items_reception'          => $param['items_reception'],
//			'items_password_confirm'   => $param['items_password_confirm'],
		);

		$show_register = true;
		$show_login    = false;
		$this->display_register_login_form( 
			$action, $error, $show_register, $show_login );
		exit();
	}

//---------------------------------------------------------
// 新規登録 & ログイン フォームを表示する
//---------------------------------------------------------
	function display_register_login_form( 
		$action, $error, $show_register, $show_login )
	{
		$action['base_url']         = $this->get_base_url();
		$action['action_register']  = $this->_action_register ;
		$action['action_login']     = $this->_action_login ;
		$action['show_register']    = $show_register ;
		$action['show_login']       = $show_login ;
		$action['token']            = $this->get_token_value() ;

		$lang = array(
			'register_login_title'   => $this->_lang_register_login_title ,
			'register_login_caption' => $this->_lang_register_login_caption ,
			'register_login_note'    => $this->_lang_register_login_note ,
			'register_note'          => $this->_lang_register_note ,
			'login_note'             => $this->_lang_login_note ,
			'caption_register'       => $this->_lang_caption_register ,
			'caption_login'          => $this->_lang_caption_login ,

			'register'                  => $this->_lang_register ,
			'dialog_name'               => $this->_lang_dialog_name ,
			'top_description'           => $this->_lang_top_description ,
			'require_flag'              => $this->_lang_require_flag ,
			'reception_email'           => $this->_lang_reception_email ,
			'public_flag'               => $this->_lang_public_flag ,
			'password_confirm'          => $this->_lang_password_confirm ,
			'autoregist_disclaimer'     => $this->_lang_autoregist_disclaimer ,
			'autoregist_disclaimer_ok'  => $this->_lang_autoregist_disclaimer_ok ,
			'autoregist_input_key'      => $this->_lang_autoregist_input_key ,
			'autoregist_input_key_desc' => $this->_lang_autoregist_input_key_desc ,

			'login'         => $this->_lang_login ,
			'ssl_login'     => $this->_lang_ssl_login ,
			'login_id'      => $this->_lang_login_id ,
			'password'      => $this->_lang_password ,
			'cancel'        => $this->_lang_cancel ,
			'lost_password' => $this->_lang_lost_password ,

			'error'         => $error ,
		);

		if ( $error ) {
			$action['show_error'] = true;
		}

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		if ( $show_register ) {
			$action['form_register'] = $this->fetch_template( 
				$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REGISTER );
		}

		if ( $show_login ) {
			$action['form_login']    = $this->fetch_template( 
				$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_LOGIN );
		}

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REGISTER_LOGIN  );
		exit();
	}

//---------------------------------------------------------
// 上書きするか否かの選択肢を表示する
//---------------------------------------------------------
	function display_select_form( $id_new, $id_old )
	{
		$action = array(
			'base_url'      => $this->get_base_url() ,
			'token'         => $this->get_token_value() ,
			'action_select' => $this->_action_select ,
			'id_new'        => $id_new ,
			'id_old'        => $id_old ,
		);

		$lang = array(
			'select_title'    => $this->_lang_select_title ,
			'select_caption'  => $this->_lang_select_caption ,
			'select_note'     => $this->_lang_select_note ,
			'select_override' => $this->_lang_select_override ,
			'yes'             => $this->_lang_yes ,
			'no'              => $this->_lang_no ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_SELECT );
		exit();
	}

//---------------------------------------------------------
// server へのリダイレクトを表示する
//---------------------------------------------------------
	function display_redirect_server( $assign )
	{
		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $this->_TEMPLATE_DIR_EXAUTH, $this->_TEMPLATE_REDIRECT );
		exit();
	}

//---------------------------------------------------------
// 会員登録を受け付ける場合の自動登録画面表示のパラメータ
// Login_Components_View 
// Login_Validator_ItemsInputs
//---------------------------------------------------------
    function get_register_param( $flag_allow=false )
    {
		$autoregist_use_items     = array();
		$autoregist_use_items_req = array();

    	$config = $this->get_config_enter_exit();

    	if ($config['autoregist_use']['conf_value'] != _ON) {
			$this->set_error_code( 101 );
			$this->set_error_msg( $this->_lang_err_autoregist );
    		return false;	
    	}

     	$items =& $this->get_users_admin();
    	if ($items === false) {
			$this->set_error_code( 102 );
			return false;
    	}

// 外部認証のときは 特定の項目のみを処理する
		if ( $flag_allow ) {
			$items = $this->build_users_allow( $items );
		}

    	$autoregist_use_items_array = explode("|", $config['autoregist_use_items']['conf_value']);
    	foreach( $autoregist_use_items_array as $autoregist_use_item ) 
		{
    		$buf_arr = explode(":", $autoregist_use_item);
    		if ( isset($buf_arr[0]) && $buf_arr[0] != "" ) {
    			$autoregist_use_items[     $buf_arr[0] ] = $buf_arr[0];

// 外部認証のときは 特定の項目のみを処理する
				if ( ! $flag_allow ) {
    				$autoregist_use_items_req[ $buf_arr[0] ] = $buf_arr[1];
    			}
			}
    	}

    	$autoregist_disclaimer    = $config['autoregist_disclaimer']['conf_value'];
    	$autoregist_use_input_key = $config['autoregist_use_input_key']['conf_value'];

		$param = array(
			'items'                    => $items ,
			'autoregist_use_items'     => $autoregist_use_items ,
			'autoregist_use_items_req' => $autoregist_use_items_req ,
			'autoregist_disclaimer'    => $autoregist_disclaimer ,
		 	'autoregist_use_input_key' => $autoregist_use_input_key ,
		);

    	return $param;
    }

    function replace_register_param( $param, $input )
    {
		$param['items'] = $this->replace_users_item( $param['items'], $input['items'] );
		$param['autoregist_disclaimer_ok'] = $input['autoregist_disclaimer_ok'];
		$param['autoregist_input_key']     = $input['autoregist_input_key'];
		return $param;
	}

    function get_users_admin()
	{
	   	$_system_user_id = $this->_session->getParameter("_system_user_id");
    	$items =& $this->_usersView->getShowItems( $_system_user_id, _AUTH_ADMIN );
		return $items;
	}

    function replace_users_item( $items, $items_value )
	{
		$arr1 = array();
		foreach ( $items as $item1 )
		{
			$arr2 = array();
			foreach ( $item1 as $item2 )
			{
				foreach ( $items_value as $k => $v )
				{
					if ( $item2['item_id'] == $k ) {
						 $item2['content'] = $v;
					}
				}
				$arr2[] = $item2;
			}
			$arr1[] = $arr2;
		}
		return $arr1;
	}

    function get_show_register_login()
    {
		$mode = $this->get_exauthadmin_config('mode_register');
		return $this->get_mode_register_login( $mode );
	}

    function get_register_param_error( )
    {
		$error = '';
		$code  = $this->get_error_code();
		$msg   = $this->get_error_msg();
		switch ( $code )
		{
			case 101:
				$error = $msg;
				break;

			case 102:
				$error = $this->_lang_err_someting.' (102)';
				$break;

			default:
				$error = $this->_lang_err_someting.' (110)';
				break;	
		}
		return $error;
	}

//---------------------------------------------------------
// config を取得する
//---------------------------------------------------------
    function get_mode_register_login( $mode )
    {
		$register = false;
		$login    = false;

		if ( ($mode == 1) || ($mode == 2) ) {
			$register = $this->is_config_autoregist_use_on();
		}

		if ( ($mode == 0) || ($mode == 2) || !$register ) {
			$login = true;
		}

		return array( $register, $login );
	}

    function is_config_autoregist_use_on()
	{
		if ( $this->get_config_autoregist_use() == _ON ) {
			return true;
		}
		return false;
	}

    function get_config_autoregist_use()
	{
		return $this->get_config_enter_exit_by_key( 'autoregist_use' );
	}

//---------------------------------------------------------
// テンプレートを表示する
//---------------------------------------------------------
	function display_template( $assign, $template_dir, $template )
	{
		$this->header_content_type();
		echo $this->fetch_template( 
			$assign, $template_dir, $template );
		exit();
	}

	function header_content_type()
	{
		header("Content-type: text/html; charset=utf-8");
	}

	function fetch_template( $assign, $template_dir, $template )
	{
		$renderer =& SmartyTemplate::getInstance();
		$renderer->setTemplateDir(  $template_dir );
		$renderer->assign( $assign );
		$result = $renderer->fetch( $template );
		return $result;
	}

//---------------------------------------------------------
// 外部認証のときの処理
//---------------------------------------------------------
    function build_users_allow( $items )
	{
		$arr1 = array();
		foreach ( $items as $item1 )
		{
			$arr2 = array();
			foreach ( $item1 as $item2 )
			{
				if ( $this->is_allow_user_item( $item2 ) ) {
					$arr2[] = $this->build_user_item( $item2 );
				}

			}
			$arr1[] = $arr2;
		}
		return $arr1;
	}

	function is_allow_user_item( $item )
	{
		$tag_name = $item['tag_name'] ;
		$ret = false;

		switch ( $tag_name )
		{
			case 'login_id':
				$ret = true;
				break;

			case 'handle':
			case 'email':
				if ( $this->get_allow_config( $tag_name ) > 0 ) {
					$ret = true;
				}
				break;
		}
		return $ret;
	}

	function build_user_item( $item )
	{
		$item = $this->build_user_item_require_flag( $item );

		$tag_name     = $item['tag_name'] ;
		$description  = $item['description'] ;

		switch ( $tag_name )
		{
			case 'handle':
				$description  = $this->_lang_user_item_mes_auth_description;
				break;
		}

		$item['description'] = $description;
		return $item;
	}

// === class end ===
}

?>