<?php
// $Id: facebook_xoops_service.class.php,v 1.3 2011/03/03 13:12:48 ohwada Exp $

//================================================================
// Facebook Module
// 2011-03-01 K.OHWADA
//================================================================

if ( !defined('_FACEBOOK_LOADED') ) {

	define('_FACEBOOK_LOADED', '1' );
	define('FACEBOOK_DIR', XOOPS_ROOT_PATH. '/modules/facebook' );

	include_once FACEBOOK_DIR.'/class/config.class.php';

	$facebook_class =& facebook_config::getInstance();
	$facebook_path  =  $facebook_class->get_pear_path();

	set_include_path( get_include_path() . PATH_SEPARATOR . $facebook_path );

	require_once 'HTTP/Request2.php';
	require_once 'Cache/Lite.php';
	require_once FACEBOOK_DIR.'/class/service.class.php';
	require_once FACEBOOK_DIR.'/class/exauth.class.php';
}

//================================================================
// class facebook_xoops_service
//================================================================
class facebook_xoops_service
{
	var $_service = null;
	var $_exauth  = null;
	var $_config  = null;

	var $_scope_publish_stream = false;
	var $_scope_offline_access = false;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE = 'facebook';

//---------------------------------------------------------
// コンストラクター
//---------------------------------------------------------
function facebook_xoops_service()
{
	$this->_service =& facebook_service::getInstance();
	$this->_exauth  =& facebook_exauth::getInstance();
	$this->_config  =& facebook_config::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new facebook_xoops_service();
	}
	return $instance;
}

function &get_exauth_Instance()
{
	return $this->_exauth;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// 初期化： app_id  を設定
//---------------------------------------------------------
function init()
{
	$path = $this->_config->get_cache_path();

	$id     = '';
	$secret = '';

	$config = $this->_config->get_config();
	if ( is_array($config) ) {
		$id     = $config['app_id'];
		$secret = $config['app_secret'];
		$this->_scope_publish_stream = $config['scope_publish_stream'];
		$this->_scope_offline_access = $config['scope_offline_access'];
	}

	if( empty($id) || empty($secret) ) {
		return false;
	}

	$this->_service->set_app_id(     $id );
	$this->_service->set_app_secret( $secret );

	$this->_service->set_scope_publish_stream( $this->_scope_publish_stream );
	$this->_service->set_scope_offline_access( $this->_scope_offline_access );

	$this->_service->set_cache_use( true );
	$this->_service->set_cache_dir( $path );

	$this->_service->set_convert_space_use( true );

	return true;
}

function get_scope_publish_stream() 
{
	return $this->_scope_publish_stream ;
}

function get_scope_offline_access() 
{
	return $this->_scope_offline_access ;
}

//---------------------------------------------------------
// Facebook サーバへのリダイレクト
//---------------------------------------------------------
function login( $num_callback )
{
	$url_callback = $this->get_callback_url( $num_callback );
	$this->_service->set_url_callback( $url_callback );

	$ret = $this->_service->login();
	if ( !$ret ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return true;
}

function get_callback_url( $num ) 
{
	if (( $num == 1 )||( $num == 2 )) {
		return XOOPS_URL . '/modules/facebook/callback'.$num.'.php';
	}
	return false;
}

//---------------------------------------------------------
// Facebook ID を取得する
//---------------------------------------------------------
function callback( $num_callback )
{
	$url_callback = $this->get_callback_url( $num_callback );
	$this->_service->set_url_callback( $url_callback );

	$param = $this->_service->callback();
	if ( !is_array($param) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$token = $param['access_token'];
	$this->_service->set_token(         $token );
	$this->_service->set_session_token( $token );

	$user = $this->_service->get_me();
	if ( !is_array($user) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$param['user_id'] = $user['id'];
	return $param;
}

//---------------------------------------------------------
// news feeds を取得する
//---------------------------------------------------------
function set_elapse_words( $w1, $w2, $w3 ) 
{
	$this->_service->set_elapse_full( 
		$this->convert_to_utf8( $w1 ) );
	$this->_service->set_elapse_hour( 
		$this->convert_to_utf8( $w2 ) ) ;
	$this->_service->set_elapse_min(
		$this->convert_to_utf8( $w3 ) );
}

function set_token_by_uid( $uid )
{
	if ( $this->_scope_offline_access ) {
		$id = $this->_exauth->get_exauth_id( $uid );
		if ( empty($id) ) {
			return -1;	// NOT set ID
		}
		$token = $this->_exauth->get_user_token( $uid );

	} else {
		$token = $this->_service->get_session_token();
	}

	if( empty($token) ) {
		return -2;	// NOT set Token
	}

	$this->_service->set_token( $token );
	return 0;	// OK
}

function clear_token_by_uid( $uid )
{
	$this->_exauth->set_user_token( $uid, '' );
	$this->_service->clear_session_token();
}

function clear_session_token()
{
	$this->_service->clear_session_token();
}

function get_feeds()
{
	$feeds = $this->_service->get_me_feeds( true );
	if ( !$feeds ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$feeds = $this->_service->feeds_to_array( $feeds );
	$feeds = $this->_service->convert_feeds(  $feeds );
	$feeds = $this->_service->convert_feeds_encoding( $feeds, _CHARSET );
	return $feeds;
}

//---------------------------------------------------------
// 投稿 する
//---------------------------------------------------------
function post( $msg )
{
	$msg = $this->convert_to_utf8( $msg );
	$ret = $this->_service->post_me_feed( $msg );
	if ( !$ret ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return true;
}

function get_post_error( $code, $msg )
{
	switch ($code)
	{
		case 61:
			$error = _FACEBOOK_ERR_POST_EMPTY;
			break;

		case 62:
			$error  = _FACEBOOK_ERR_POST_FAIL.'<br />';
			$error .= $msg;
			break;

		default:
			$error = _FACEBOOK_ERR_SOMETHING;
			break;
	}
	return $error;
}

function convert_to_utf8( $str ) 
{
	return $this->_service->convert_to_utf8( $str, _CHARSET ); 
}

// === class end ===

}

?>