<?php
// $Id: FacebookAuth.class.php,v 1.1.1.1 2011/03/02 16:56:03 ohwada Exp $

//================================================================
// Facebook Plugin of Exauth Module
// 2011-03-01 K.OHWADA
//================================================================

/**#@+ load classes */
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/AbstractAuth.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/Error.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/ApplyIDFIlter.class.php';

/**
 * facebook service library
 */
require_once XOOPS_ROOT_PATH . '/modules/facebook/class/facebook_xoops_service.class.php';

//================================================================
// class Exauth_FacebookAuth
//================================================================
class Exauth_FacebookAuth extends Exauth_AbstractAuth
{
	var $_service = null;

	var $_NUM_CALLBACK = 1;

    /**
     * Constructor
     */
    function Exauth_FacebookAuth($exauth, $config)
    {
        parent::Exauth_AbstractAuth($exauth, $config);

		$this->_service =& new facebook_xoops_service();
		$this->_service->init();
    }

    /**
     * @return string
     */
    function getAuthIDName()
    {
        return 'Facebook';
    }

    /**
     * @return bool
     */
    function isActive()
    {
		return true;
    }

    /**
     * @param array &$option [out] set external authentication options
     * @return string external user name
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php _getExUserObject()
    function getUser(&$option) 
    {
		$param = $this->_service->callback( $this->_NUM_CALLBACK );
		if ( !is_array($param) ) {
			$msg  = _MD_EXAUTH_FACEBOOK_FAILED ;
			$msg .= $this->_service->get_error_msg();
            return new Exauth_Error( $msg );
		}

		$id    = $param['user_id'] ;
		$token = $param['access_token'] ;

        $option['__obj']['token']  = $token;

        return array(
			'identifier' => $id, 
			'token'      => $token ,
		);
    }

    /**
     * @param array &$assign_vars [out] set smarty assign variables
     * @return string Template file
     */
    function executePreLoginView(&$assign_vars)
    {
        $step = $this->_getrequest('step');

		$facebook = $this->_getrequest('facebook_identifier');

        if (defined('XOOPS_CUBE_LEGACY')) {
            $assign_vars['login_url'] = XOOPS_URL . '/user.php';
        } else {
            $assign_vars['login_url'] = XOOPS_URL . '/modules/exauth/prelogin.php';
        }

       if ( $step == 2 ) {

			$ret = $this->_service->login( $this->_NUM_CALLBACK );
			if ( !$ret ) {
				$msg  = _MD_EXAUTH_FACEBOOK_FAILED;
				$msg .= $this->_service->get_error_msg();
            	$assign_vars['err_mes'] = $msg ;
            	return 'exauth_facebook_pv.html';
			}
			return true;

        } else {
            return 'exauth_facebook_pv.html';
        }
    }

    /**
     * @param string &$exuser
     * @param array &$option
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php checkLogin()
    function setUserSetting(&$exuser, &$option)
    {
    	$exuser->setVar('facebook_token',  $option['__obj']['token'],  true);
    }

// === class end ===
}
