<?php
// $Id: twitter_xoops_service.class.php,v 1.4 2011/03/03 13:36:22 ohwada Exp $

//================================================================
// Twitter Module
// 2010-08-01 K.OHWADA
//================================================================

if ( !defined('_TWITTER_LOADED') ) {

	define('_TWITTER_LOADED', '1' );
	define('TWITTER_DIR', XOOPS_ROOT_PATH. '/modules/twitter' );

	$pear_path = '';

	$config = get_twitter_config();
	if ( isset( $config['pear_path'] ) ) {
		$pear_path = $config['pear_path'];
	}

	if ( empty($pear_path) || !is_dir($pear_path)) {
		$pear_path = TWITTER_DIR.'/class/PEAR';
	}
	set_include_path( get_include_path() . PATH_SEPARATOR . $pear_path );

	require_once 'Services/Twitter.php';
	require_once 'HTTP/OAuth/Consumer.php';
	require_once TWITTER_DIR.'/class/service.class.php';
	require_once TWITTER_DIR.'/class/exauth.class.php';
}

//================================================================
// function get_twitter_config
//================================================================
function get_twitter_config()
{
	$module_handler =& xoops_gethandler('module');
	$module = $module_handler->getByDirname( 'twitter' );
	if ( !is_object($module) ) {
		return false;
	}

	$mid = $module->getVar( 'mid' );
	$config_handler =& xoops_gethandler('config');
	return $config_handler->getConfigsByCat( 0, $mid );
}

//================================================================
// class twitter_xoops_service
//================================================================
class twitter_xoops_service
{
	var $_service = null;
	var $_exauth  = null;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE = 'twitter';

//---------------------------------------------------------
// 󥹥ȥ饯
//---------------------------------------------------------
function twitter_xoops_service()
{
	$this->_service =& twitter_service::getInstance();
	$this->_exauth  =& twitter_exauth::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new twitter_xoops_service();
	}
	return $instance;
}

function &get_exauth_Instance()
{
	return $this->_exauth;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
//  consumer_key 
//---------------------------------------------------------
function init()
{
	list( $key, $secret ) = $this->get_config_consumer_key();

	if( empty($key) || empty($secret) ) {
		return false;
	}

	$this->_service->set_consumer_key(    $key );
	$this->_service->set_consumer_secret( $secret );
	return true;
}

function set_user( $uid )
{
	list( $token, $secret )
		= $this->_exauth->get_user_token( $uid );
	if( empty($token) || empty($secret) ) {
		return false;
	}

	$this->_service->set_token(        $token );
	$this->_service->set_token_secret( $secret );

	return true;
}

//---------------------------------------------------------
// Twiiter ФؤΥ쥯
//---------------------------------------------------------
function login( $flag_callback=false )
{
	$url_callback = $this->get_callback_url( $flag_callback );
	$this->_service->set_url_callback( $url_callback );

	$this->_service->set_flag_login( true );

	$ret = $this->_service->login();
	if ( !$ret ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return true;
}

function get_callback_url( $flag_callback ) 
{
	if ( $flag_callback ) {
		return XOOPS_URL . '/modules/twitter/callback.php';
 	}
    if (defined('XOOPS_CUBE_LEGACY')) {
    	return XOOPS_URL . '/user.php?op=login&exauth=twitter';
    }  else {
    	return XOOPS_URL . '/modules/exauth/login.php?exauth=twitter';
    }
}

//---------------------------------------------------------
// Twitter ID 
//---------------------------------------------------------
function callback()
{
	$param = $this->_service->callback();
	if ( !is_array($param) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return $param;
}

//---------------------------------------------------------
// timeline 
//---------------------------------------------------------
function get_home_timeline( $flag_convert=false )
{
	$items = $this->_service->get_home_timeline();
	if ( !is_array($items) || !count($items) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	if ( $flag_convert ) {
		$items = $this->_service->timeline_to_array( $items );
		$items = $this->_service->convert_timeline(  $items );
		$items = $this->_service->convert_timeline_encoding( $items, _CHARSET );
	}
	return $items;
}

//---------------------------------------------------------
// tweet 
//---------------------------------------------------------
function tweet( $status )
{
	$status = $this->_service->convert_to_utf8( $status, _CHARSET );
	$obj = $this->_service->tweet( $status );
	if ( !is_object($obj) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$id = $obj->id;
	return $id;
}

function get_tweet_error( $code, $msg )
{
	switch ($code)
	{
		case 41:
			$error = _TWITTER_ERR_TWEET_EMPTY;
			break;

		case 42:
			$error = _TWITTER_ERR_TWEET_OVER_140;
			break;

		case 43:
			$error  = _TWITTER_ERR_TWEET_POST.'<br />';
			$error .= $msg;
			break;

		default:
			$error = _TWITTER_ERR_SOMETHING;
			break;
	}
	return $error;
}

//---------------------------------------------------------
// consumer_key 
//---------------------------------------------------------
function get_config_consumer_key()
{
	$key    = null ;
	$secret = null ;
   	$config = get_twitter_config();
	if ( isset( $config['consumer_key'] ) ) {
		$key    = $config['consumer_key'];
		$secret = $config['consumer_secret'];
	}
	return array( $key, $secret );
}

// === class end ===

}