<?php
// $Id: TwitterAuth.class.php,v 1.1.1.1 2010/08/30 12:56:50 ohwada Exp $

//================================================================
// Twitter Plugin of Exauth Module
// 2010-08-01 K.OHWADA
//================================================================

/**#@+ load classes */
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/AbstractAuth.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/Error.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/ApplyIDFIlter.class.php';

/**
 * twitter service library
 */
require_once XOOPS_ROOT_PATH . '/modules/twitter/class/twitter_xoops_service.class.php';

//================================================================
// class Exauth_TwitterAuth
//================================================================
class Exauth_TwitterAuth extends Exauth_AbstractAuth
{
	var $_service = null;

    /**
     * Constructor
     */
    function Exauth_TwitterAuth($exauth, $config)
    {
        parent::Exauth_AbstractAuth($exauth, $config);

		$this->_service =& new twitter_xoops_service();
		$this->_service->init();
    }

    /**
     * @return string
     */
    function getAuthIDName()
    {
        return 'Twitter';
    }

    /**
     * @return bool
     */
    function isActive()
    {
		return true;
    }

    /**
     * @param array &$option [out] set external authentication options
     * @return string external user name
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php _getExUserObject()
    function getUser(&$option) // å
    {
//debug_print_backtrace();
//exit();
		$param = $this->_service->callback();
		if ( !is_array($param) ) {
			$msg  = _MD_EXAUTH_TWITTER_FAILED ;
			$msg .= $this->_service->get_error_msg();
            return new Exauth_Error( $msg );
		}

		$screen_name  = $param['screen_name'] ;
		$token        = $param['token'] ;
		$token_secret = $param['token_secret'] ;

        $option['__obj']['token']  = $token;
        $option['__obj']['secret'] = $token_secret;

        return array(
			'identifier' => $screen_name, 
			'token'      => $token ,
			'secret'     => $token_secret ,
		);
    }

    /**
     * @param array &$assign_vars [out] set smarty assign variables
     * @return string Template file
     */
    function executePreLoginView(&$assign_vars)
    {
        $step = $this->_getrequest('step');

		$twitter = $this->_getrequest('twitter_identifier');

        if (defined('XOOPS_CUBE_LEGACY')) {
            $assign_vars['login_url'] = XOOPS_URL . '/user.php';
        }
        else {
            $assign_vars['login_url'] = XOOPS_URL . '/modules/exauth/prelogin.php';
        }

       if ( $step == 2 ) {

			$ret = $this->_service->login();
			if ( !$ret ) {
				$msg  = _MD_EXAUTH_TWITTER_FAILED;
				$msg .= $this->_service->get_error_msg();
            	$assign_vars['err_mes'] = $msg ;
            	return 'exauth_twitter_pv.html';
			}
			return true;

        } else {
            return 'exauth_twitter_pv.html';
        }
    }

    /**
     * @param string &$exuser
     * @param array &$option
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php checkLogin()
    function setUserSetting(&$exuser, &$option)
    {
//print_r($option)
//debug_print_backtrace();
//exit();
    	$exuser->setVar('twitter_token',  $option['__obj']['token'],  true);
        $exuser->setVar('twitter_secret', $option['__obj']['secret'], true);
    }

// === class end ===
}
