<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * 新着の表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Whatsnew_View_Main_Init extends Action
{
    // リクエストパラメータを受け取るため
	var $block_id = null;
	var $room_id = null;
	var $result_only = null;

    // 使用コンポーネントを受け取るため
	var $whatsnewView = null;
	var $session = null;

	// Filterによりセット
	var $room_arr_flat =null; 

 	// validatorから受け取るため
	var $whatsnew_obj = null;

    // 値をセットするため
	var $whatsnew_data = null;
	var $display_count = null;

    /**
     * execute実行
     *
     * @access  public
     */
    function execute()
    {
    	$this->session->removeParameter(array("whatsnew", "enroll_room_arr", $this->block_id));

    	$this->display_count = intval($this->whatsnew_obj["display_title"]) +
    							intval($this->whatsnew_obj["display_room_name"]) +
    							intval($this->whatsnew_obj["display_module_name"]) +
    							intval($this->whatsnew_obj["display_user_name"]) +
    							intval($this->whatsnew_obj["display_insert_time"]);
    	
    	$this->whatsnew_data = $this->whatsnewView->getResults($this->whatsnew_obj, $this->room_arr_flat);
    	$user_id = $this->session->getParameter("_user_id");
    	if (!empty($user_id)) {
    		$this->room_arr_flat["0"] = array("page_name" => WHATSNEW_NO_PAGE);
    		$this->whatsnew_obj["select_room_list"][] = "0";
    	}
    	if ($this->whatsnew_data === false) {
    		return 'error';
    	}
    	if ($this->result_only == _ON) {
			return 'result';
    	} else {
			return 'success';
    	}
    }
}
?>