<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * タグデータバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Pm_Validator_ReceiverEnter extends Validator
{
    /**
     * タグデータバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {	
		$handle = $attributes["handle"];
		$flag = $attributes["flag"];
		
		$container =& DIContainerFactory::getContainer();
		$usersView =& $container->getComponent("usersView");
		
		if($flag == "info"){
			if(trim($handle) == ''){
				// return "false|" . sprintf(PM_ERROR_USER_EMPTY, PM_USER_HANDLE);
			}else{
				$pmView =& $container->getComponent("pmView");
				$user_id = $pmView->getUserIdByHandle($handle);
				
				if(empty($user_id)) {
					return "false|" . sprintf(PM_ERROR_USER_NONEEXISTS, PM_USER_HANDLE, $handle);
				}else{
					return "true|" . $user_id;
				}
			}
		}elseif($flag == "avater"){
			$user_id = $attributes["user_id"];
			if(empty($user_id)){
				$avater = "";
			}else{
				$pmView =& $container->getComponent("pmView");
				$avater = $pmView->getUserAvater($user_id);
				if(!$avater){
					$avater = "";
				}
			}
			
			if($avater == ""){
				$avater = "false";
			}
			return $avater;
		}
		
		/*
		$actionChain =& $container->getComponent("ActionChain");
		$action =& $actionChain->getCurAction();
		BeanUtils::setAttributes($action, array("user_id" => $users[0]["user_id"]));
		*/
        return;
    }
}
?>
