<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
* [[機能説明]]
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Memo_Action_Edit_Init extends Action
{
    // リクエストパラメータを受け取るため
    var $block_id = null;
    var $page_id = null;
    var $room_id = null;

// 追加
	var $content = null;

    // 使用コンポーネントを受け取るため
    var $memoView = null;
    var $memoAction = null;

// 追加
	var $db = null;

    // 値をセットするため

// 追加： Filter_Whatsnewに値をセットするため
	var $whatsnew = array();

    /**
     * [[機能説明]]
     *
     * @access  public
     */
    function execute()
    {
// データベースからの読み出し
    	$record = $this->memoView->getRecord( $this->block_id );

    	$params = array(
        	"block_id"         => intval($this->block_id),
        	"room_id"          => intval($this->room_id),
        	"content"          => $this->content,
    	);

// 更新
    	if ( $record ) {
        	$result = $this->db->updateExecute(
            	"memo",
            	$params,
            	"block_id",
           		true    // update_time を付加する
        	);

// 新規登録
    	} else {
        	$result = $this->db->insertExecute(
            	"memo",
            	$params,
            	true,     // insert_time を付加する
            	"block_id"    // create_key
        	);
    	}

// エラー
    	if ( $result == false) {
        	return 'error';
    	}

		//--新着情報関連 Start--
		$this->whatsnew = array(
			"unique_id" => $this->block_id,
			"title" => "",
			"description" => $this->content
		);
		if ( $record ) {
			$this->whatsnew["insert_time"]      = $record["insert_time"];
			$this->whatsnew["insert_user_id"]   = $record["insert_user_id"];
			$this->whatsnew["insert_user_name"] = $record["insert_user_name"];
		}
		//--新着情報関連 End--

        return 'success';
    }
}
?>
