/* $Id: googlesearch.js,v 1.1.1.1 2009/03/31 10:21:37 ohwada Exp $ */

/* =========================================================
 * Googlesearch Netcommons
 * 2009-03-01 K.OHWADA
 * =========================================================
 */

var clsGooglesearch = Class.create();
var googlesearchCls = Array();

clsGooglesearch.prototype = {
	initialize: function(id) {
		this.id = id;
		
		this.parts_id = null;
		this.currentGooglesearchID = null;
		this.oldSortCol = null;
	},
	//カレントをハイライトしてラジオボタンをチェック状態にする
	checkCurrent: function() {
		var currentRow = $("googlesearch_current_row" + this.currentGooglesearchID + this.id);
		if (!currentRow) {
			return;
		}
		//指定したエレメントにスタイルのクラスを追加
		Element.addClassName(currentRow, "highlight");

		var current = $("googlesearch_current" + this.currentGooglesearchID + this.id);
		//カレントのラジオボタンのチェック状態にする
		current.checked = true;
	},
	//カレントを変更してハイライトする
	changeCurrent: function(googlesearchID) {
		var oldCurrentRow = $("googlesearch_current_row" + this.currentGooglesearchID + this.id);
		if (oldCurrentRow) {
			//指定したところの指定したクラス名を削除する
			Element.removeClassName(oldCurrentRow, "highlight");
		}
		
		this.currentGooglesearchID = googlesearchID;
		var currentRow = $("googlesearch_current_row" + this.currentGooglesearchID + this.id);
		Element.addClassName(currentRow, "highlight");
		
		var post = {
			"action":"googlesearch_action_edit_current",
			"parts_id":googlesearchID
		};
		var params = new Object();
		//エラーが帰ってきたときの処理
		params["callbackfunc_error"] = function(res){
											commonCls.alert(res);
											commonCls.sendView(this.id, "googlesearch_view_edit_list");
										}.bind(this);
		commonCls.sendPost(this.id, post, params);
	},
	//参照を押したときに呼び出される
	referGooglesearch: function(event, parts_id) {
		var params = new Object();
		params["action"] = "googlesearch_view_edit_preview";
		params["parts_id"] = parts_id;
		params["prefix_id_name"] = "popup_parts_reference" + parts_id;

		var popupParams = new Object();
		var top_el = $(this.id);
		popupParams['top_el'] = top_el;
		popupParams['target_el'] = top_el;
	
		commonCls.sendPopupView(event, params, popupParams);
	},
	//削除を押すときに呼び出される
	deleteGooglesearch: function(parts_id, confirmMessage) {
		if (!commonCls.confirm(confirmMessage)) return false;
		
		var post = {
			"action":"googlesearch_action_edit_delete",
			"parts_id":parts_id
		};
					
		var params = new Object();
		params["target_el"] = $(this.id);
		params["callbackfunc_error"] = function(res){
											commonCls.alert(res);
											commonCls.sendView(this.id, "googlesearch_view_edit_list");
										}.bind(this);
		commonCls.sendPost(this.id, post, params);
	},
	//管理の編集を押す時に呼び出される。
	editGooglesearch: function(parts_id) {
		var params = new Object();
		params["action"] = "googlesearch_view_edit_modify";
		params["parts_id"] = parts_id;
		//paramsの情報を持ってactionに指定した場所を表示する
		commonCls.sendView(this.id, params);
	},
	//新規登録と編集のアクションを起こす
	insertParts: function(form_el) {
		var params = new Object();
		params["target_el"]=$(this.id);
		params["focus_flag"]=true;
		//googlesearch/action/edit/entryにformから受け取った内容をつなげて送る
		var post="action=googlesearch_action_edit_entry&" + Form.serialize(form_el);
		commonCls.sendPost(this.id, post, params);
	},
	//Config編集のアクションを起こす
	updateConfig: function(form_el) {
		var params = new Object();
		params["target_el"]=$(this.id);
		params["focus_flag"]=true;
		//googlesearch/action/edit/configにformから受け取った内容をつなげて送る
		var post="action=googlesearch_action_admin_config&" + Form.serialize(form_el);
		commonCls.sendPost(this.id, post, params);
	}
}