<?php
// $Id: service.class.php,v 1.3 2010/08/30 18:14:53 ohwada Exp $

//=========================================================
// Twitter Login with Service_Twitter
// 2010-08-01 K.OHWADA
//=========================================================

//---------------------------------------------------------
// http://pear.php.net/package/Services_Twitter
// http://dev.twitter.com/doc
// http://zuzara.com/blog/2010/01/20/complete-working-sample-for-services_twitter-oauth-in-php-pear/
//---------------------------------------------------------

class twitter_service
{
	var $_consumer_key    = null; 
	var $_consumer_secret = null; 
	var $_token           = null; 
	var $_token_secret    = null; 
	var $_url_callback    = null;
	var $_flag_login      = false;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_URL_REQUEST_TOKEN = 'http://twitter.com/oauth/request_token';
	var $_URL_ACCESS_TOKEN  = 'http://twitter.com/oauth/access_token';
	var $_URL_AUTHENTICATE  = 'http://twitter.com/oauth/authenticate';
	var $_URL_AUTHORIZE     = 'http://twitter.com/oauth/authorize';

	var $_NAME_CALLBACK_TOKEN        = 'twitter_callback_token';
	var $_NAME_CALLBACK_TOKEN_SECRET = 'twitter_callback_token_secret';
	var $_NAME_OAUTH_VERIFIER        = 'oauth_verifier';

function twitter_service()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new twitter_service();
	}
	return $instance;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

function set_consumer_key( $v )
{
	$this->_consumer_key = $v; 
}

function set_consumer_secret( $v )
{
	$this->_consumer_secret = $v; 
}

function set_token( $v )
{
	$this->_token = $v; 
}

function set_token_secret( $v )
{
	$this->_token_secret = $v; 
}

function set_url_callback( $v )
{
	$this->_url_callback = $v; 
}

function set_flag_login( $v )
{
	$this->_flag_login = (bool)$v;
}

function login()
{
	try {
        $oauth = new HTTP_OAuth_Consumer(
			$this->_consumer_key, 
			$this->_consumer_secret );

        $oauth->getRequestToken( 
			$this->_URL_REQUEST_TOKEN, $this->_url_callback ); 

        $_SESSION[ $this->_NAME_CALLBACK_TOKEN ]        
			= $oauth->getToken();
        $_SESSION[ $this->_NAME_CALLBACK_TOKEN_SECRET ] 
			= $oauth->getTokenSecret();

		if ( $this->_flag_login ) {
			$url = $this->_URL_AUTHENTICATE ;
		} else {
			$url = $this->_URL_AUTHORIZE ;
		}

		$redirect_url = $oauth->getAuthorizeUrl( $url );

		header('Location: '.$redirect_url);
		exit();

	} catch (Exception $e) {
		$this->_error_msg  = $e->getMessage();
		$this->_error_code = 11;
		return false;
	}

// dummy
	return true;
}

function callback()
{

	if ( !isset($_GET[ $this->_NAME_OAUTH_VERIFIER ]) || 
    	 !isset($_SESSION[ $this->_NAME_CALLBACK_TOKEN ]) || 
	 	 !isset($_SESSION[ $this->_NAME_CALLBACK_TOKEN_SECRET ]) ) {

		$this->_error_code = 21;
		return false;
	}

	try {
    	$twitter = new Services_Twitter;
    	$oauth   = new HTTP_OAuth_Consumer(
			$this->_consumer_key, 
			$this->_consumer_secret ,
			$_SESSION[ $this->_NAME_CALLBACK_TOKEN ], 
			$_SESSION[ $this->_NAME_CALLBACK_TOKEN_SECRET ] );

    	$oauth->getAccessToken( 
			$this->_URL_ACCESS_TOKEN, 
			$_GET[ $this->_NAME_OAUTH_VERIFIER ] );

    	$twitter->setOAuth( $oauth );

		$credentials = $twitter->account->verify_credentials();
		if ( !isset($credentials->screen_name) ) {
			$this->_error_code = 22;
			return false;
		}

		$arr = array(
			'screen_name'  => $credentials->screen_name ,
			'token'        => $oauth->getToken() ,
			'token_secret' => $oauth->getTokenSecret() ,
		);

		return $arr;

	} catch (Exception $e) {
		$this->_error_msg  = $e->getMessage();
		$this->_error_code = 23;
		return false;
	}

// dummy
	return true;
}

function get_home_timeline()
{
	try {
		$twitter = new Services_Twitter;
    	$oauth   = new HTTP_OAuth_Consumer(
			$this->_consumer_key , 
			$this->_consumer_secret ,
			$this->_token , 
			$this->_token_secret );

    	$twitter->setOAuth($oauth);
    	$ret = $twitter->statuses->home_timeline();
		return $ret;

	} catch (Exception $e) {
		$this->_error_msg  = $e->getMessage();
		$this->_error_code = 31;
		return false;
	}

// dummy
	return true;
}

function tweet( $status )
{
	if ( empty($status) ) {
		$this->_error_code = 41;
		return false;
	}

	if ( mb_strlen($status) > 140 ) {
		$this->_error_code = 42;
		return false;
	}

	try {
		$twitter = new Services_Twitter;
    	$oauth   = new HTTP_OAuth_Consumer(
			$this->_consumer_key , 
			$this->_consumer_secret ,
			$this->_token , 
			$this->_token_secret );

    	$twitter->setOAuth( $oauth );
    	$ret = $twitter->statuses->update( $status );
		return $ret;

	} catch (Exception $e) {
		$this->_error_msg  = $e->getMessage();
		$this->_error_code = 43;
		return false;
	}

// dummy
	return true;
}

function timeline_to_array( $items )
{
	$arr = array();
	foreach ( $items as $item )
	{
		$t = array();
		foreach ( $item as $k1 => $v1 )
		{
			if ( is_object($v1) ) {
				foreach ( $v1 as $k2 => $v2 ) {
					$t[ $k1.'_'.$k2 ] = $v2;
				}
			} else {
				$t[ $k1 ] = $v1;
			}
		}
		$arr[] = $t;
	}
	return $arr;
}

function convert_timeline( $items )
{
	$arr = array();
	foreach ( $items as $item )
	{
		$t = array();
		foreach ( $item as $k => $v )
		{
			if ( $k == 'text' ) {
				$v = $this->convert_timeline_text( $v );
			}
			if ( $k == 'source' ) {
				$v = $this->convert_timeline_source( $v );
			}
			$t[ $k ] = $v;
		}
		$arr[] = $t;
	}
	return $arr;
}

function convert_timeline_text( $str )
{
	$str = $this->make_clickable_http( $str );
	$str = $this->make_clickable_tag(  $str );
	return $str;
}

function make_clickable_tag( $str )
{
	$p   = array();
	$r   = array();
	$p[] = '/@(\w+)/';
	$r[] = '<a href="http://twitter.com/\\1" target="_blank">@\\1</a>';
	$p[] = '/#(\w+)/';
	$r[] = '<a href="http://twitter.com/#search?q=%23\\1" target="_blank">#\\1</a>';

	$str = preg_replace( $p, $r, $str );
	return $str;
}

// reference: XOOPS module.textsanitizer.php
function make_clickable_http( $str )
{
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])([a-z]+?):\/\/([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])www\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])ftp\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/:\.])([a-z0-9\-_\.]+?)@([^, \r\n\"\(\)'<>\[\]]+)/i";

	$r[] = "\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>";
	$r[] = "\\1<a href=\"http://www.\\2.\\3\" target=\"_blank\">www.\\2.\\3</a>";
	$r[] = "\\1<a href=\"ftp://ftp.\\2.\\3\" target=\"_blank\">ftp.\\2.\\3</a>";
	$r[] = "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>";

	$str = preg_replace( $p, $r, $str );
	return $str;
}

function convert_timeline_source( $str )
{
	$p = '/>/sU';
	$r = ' target="_blank">';

	$str = preg_replace( $p, $r, $str );
	return $str;
}

function convert_timeline_encoding( $items, $to )
{
	$arr = array();
	foreach ( $items as $item ) {
		$t = array();
		foreach ( $item as $k => $v ) {
			$t[ $k ] = $this->convert_from_utf8( $v, $to );
		}
		$arr[] = $t;
	}
	return $arr;
}

function convert_from_utf8( $str, $to )
{
	return $this->convert_encoding( $str, 'UTF-8', $to );
}

function convert_to_utf8( $str, $from )
{
	return $this->convert_encoding( $str, $from, 'UTF-8' );
}

function convert_encoding( $str, $from, $to, $extra='//IGNORE' )
{
	if ( strtolower($to) == strtolower($from) ) {
		return $str;
	}
	if ( function_exists('iconv') ) {
		return iconv( $from, $to.$extra , $str );
	}
	if ( function_exists('mb_convert_encoding') ) {
		return mb_convert_encoding( $str, $from, $to );
	}
	return $str;
}

// === class end ===
}
?>