<?php
//=========================================================
// OpenID
// 2010-07-07 K.OHWADA
//=========================================================

class openid_redirect
{
	var $_BASE_URL = null;
	var $_FORM_ID  = 'redirect_form';
	var $_REDIRECT_TIME = 1;

	var $_LANG_TITLE        = 'Redirect';
	var $_LANG_REDIRECT_MSG = 'Go To OpenID Authentication page.';
	var $_LANG_CLICK_HERE   = 'If not reload click HERE';

function openid_redirect()
{
	// dummy
}

function set_base_url( $s )
{
	$this->_BASE_URL = $s;
}

function set_templates_dir( $s )
{
	$this->_TEMPLATES_DIR = $s;
}

function set_lang_title( $s )
{
	$this->_LANG_TITLE = $s;
}

function set_lang_redirect_msg( $s )
{
	$this->_LANG_REDIRECT_MSG = $s;
}

function set_lang_click_here( $s )
{
	$this->_LANG_CLICK_HERE = $s;
}

function redirect_param( $param )
{
	$method = isset($param['method']) ? $param['method'] : null;
	$url    = isset($param['url'])    ? $param['url']    : null;
	$time   = isset($param['time'])   ? $param['time']   : $this->_REDIRECT_TIME ;
	$msg    = isset($param['msg'])    ? $param['msg']    : $this->_LANG_REDIRECT_MSG ;
	$args   = isset($param['args'])   ? $param['args']   : null;

	if ( $method == 'post' ) {
		$this->redirect_post( $url, $time, $msg, $args );
	} else {
		$this->redirect_get( $url, $time, $msg );
	}
}

function redirect_get( $url_in, $time=1, $msg_in=null )
{
	$url   = $this->_build_url( $url_in );
	$msg   = $this->_build_message( $msg_in );
	$title = $this->_build_text( $this->_LANG_TITLE );

	$search = array(
		'<{$redirect_url}>', '<{$redirect_time}>', 
		'<{$lang_redirect_message}>',
		'<{$lang_redirect_title}>', '<{$lang_redirect_click_here}>' );

	$replace = array(
		$url, $time, $msg, $title, $this->_LANG_CLICK_HERE );

	$file = $this->_TEMPLATES_DIR .'/redirect_get.html';
	$cont = file_get_contents( $file );
	$html = str_replace( $search, $replace, $cont );
	echo $html;
	exit();
}

function redirect_post( $url_in, $time=1, $msg_in=null, $args=null)
{
	$url   = $this->_build_url( $url_in );
	$msg   = $this->_build_message( $msg_in );
	$title = $this->_build_text( $this->_LANG_TITLE );
	$form  = $this->_build_form( $url, $args );

	if ( $time > 0 ) {
		$msec   = $time * 1000;
		$onload = 'redirect_onload()';
	} else {
		$msec   = 1000;
		$onload = 'redirect_submit()';
	}

	$search = array(
		'<{$redirect_url}>', '<{$redirect_time_msec}>',
		'<{$lang_redirect_message}>', 
		'<{$redirect_form_id}>', '<{$redirect_form_body}>',
		'<{$redirect_onload}>', '<{$lang_redirect_title}>' );

	$replace = array(
		$url, $msec, $msg, $this->_FORM_ID, $form, $onload, $title );

	$file = $this->_TEMPLATES_DIR .'/redirect_post.html';
	$cont = file_get_contents( $file );
	$html = str_replace( $search, $replace, $cont );
	echo $html;
	exit();
}

function _build_form( $url_in, $args )
{
	$url = $this->_build_url( $url_in );

	$param = '';
    if ( is_array($args) ) {
         foreach ( $args as $k => $v ) {
            $param .= '<input type="hidden" name="'.htmlspecialchars($k).'" value="'.htmlspecialchars($v).'">'."\n";
         }
    } else {
        $param = $this->_build_text( $args );
    }

	$search = array(
		'<{$redirect_url}>', '<{$redirect_form_id}>', 
		'<{$lang_redirect_submit}>', '<{$redirect_param}>' );

	$replace = array(
		$url, $this->_FORM_ID, $this->_LANG_CLICK_HERE, $param );

	$file = $this->_TEMPLATES_DIR .'/redirect_form.html';
	$cont = file_get_contents( $file );
	$html = str_replace( $search, $replace, $cont );
	return $html;
}

function _build_url( $url )
{
    if ( empty($url) ) {
        $url = $this->_BASE_URL;
    }

    if ( preg_match("/(javascript|vbscript):/si", $url) ) {
        $url = $this->_BASE_URL;
    }

    $url = $this->_build_text( $url );

    if ( defined('SID') && !isset( $_COOKIE[ session_name() ] ) ) {
        if (!strstr($url, '?')) {
            $url .= '?' . SID;
        } else {
            $url .= '&amp;' . SID;
        }
    }

	return $url;
}

function _build_message( $msgs )
{
    $str = "";
    if ( is_array($msgs) ) {
        foreach ( $msgs as $m ) {
            $str = $this->_build_text( $m )."<br/>\n";
        }
    } else {
        $str = $this->_build_text( $msgs );
    }
	return $str;
}

function _build_text( $text )
{
	return htmlspecialchars( $text, ENT_QUOTES ) ;
}

// === class end ===
}

?>