<?php
//=========================================================
// OpenID
// 2010-07-07 K.OHWADA
//=========================================================

class openid_generic_consumer extends Auth_OpenID_GenericConsumer
{
	var $_URL_GOOGLE_APPS = 'https://www.google.com/accounts/o8/user-xrds?uri=';

    function openid_consumer(&$store)
    {
		$this->Auth_OpenID_GenericConsumer($store);
    }

    /**
     * @access private
     */
    function _verifyDiscoverySingle($endpoint, $to_match)
    {
		$flag_google_apps = false;
		if ( strpos( $endpoint->claimed_id, $this->_URL_GOOGLE_APPS ) !== false ) {
			$flag_google_apps = true;
		}

        // Every type URI that's in the to_match endpoint has to be
        // present in the discovered endpoint.
        foreach ($to_match->type_uris as $type_uri) {
            if (!$endpoint->usesExtension($type_uri)) {
                return new Auth_OpenID_TypeURIMismatch($endpoint,
                             "Required type ".$type_uri." not present");
            }
        }

        // Fragments do not influence discovery, so we can't compare a
        // claimed identifier with a fragment to discovered
        // information.
        list($defragged_claimed_id, $_) =
            Auth_OpenID::urldefrag($to_match->claimed_id);

// google apps
		$endpoint_claimed_id  = $this->_URL_GOOGLE_APPS;
		$endpoint_claimed_id .= strtolower( urlencode($defragged_claimed_id) );

		$endpoint_local_id = str_replace( $this->_URL_GOOGLE_APPS, '', $endpoint->claimed_id );
		$endpoint_local_id = urldecode( $endpoint_local_id );

        if ( $defragged_claimed_id != $endpoint->claimed_id ) {

// check for google apps
	        if ( !$flag_google_apps || ( $endpoint_claimed_id != $endpoint->claimed_id ) ) {

            	return new Auth_OpenID_FailureResponse($endpoint,
              		sprintf('Claimed ID does not match (different subjects!), ' .
                    	'Expected %s, got %s', $defragged_claimed_id,
                    	$endpoint->claimed_id));
    	    }
		}

        if ( $to_match->getLocalID() != $endpoint->getLocalID() ) {

// check for google apps
			if ( !$flag_google_apps || ( $to_match->getLocalID() != $endpoint_local_id ) ) {

            	return new Auth_OpenID_FailureResponse($endpoint,
              		sprintf('local_id mismatch. Expected %s, got %s',
                    	$to_match->getLocalID(), $endpoint->getLocalID()));
			}
        }

        // If the server URL is None, this must be an OpenID 1
        // response, because op_endpoint is a required parameter in
        // OpenID 2. In that case, we don't actually care what the
        // discovered server_url is, because signature checking or
        // check_auth should take care of that check for us.
        if ($to_match->server_url === null) {
            if ($to_match->preferredNamespace() != Auth_OpenID_OPENID1_NS) {
                return new Auth_OpenID_FailureResponse($endpoint,
                             "Preferred namespace mismatch (bug)");
            }
        } else if ($to_match->server_url != $endpoint->server_url) {
            return new Auth_OpenID_FailureResponse($endpoint,
              sprintf('OP Endpoint mismatch. Expected %s, got %s',
                      $to_match->server_url, $endpoint->server_url));
        }

        return null;
    }

// === class end ===
}

?>