<?php
//=========================================================
// OpenID
// 2010-07-07 K.OHWADA
//=========================================================

class openid_filter
{
	var $_FILTERS_DIR = null;

    var $_plugin_name = null;
    var $_option = null;
    var $_id = null;

function openid_filter()
{
	// dummy
}

function set_filters_dir( $dir )
{
	$this->_FILTERS_DIR = $dir ;
}

function set_plugin_name($plugin_name)
{
	$this->_plugin_name = $plugin_name;
}

function set_option($option)
{
	$this->_option = $option;
}

function set_id($id)
{
	$this->_id = $id;
}

function get_id()
{
	return $this->_id;
}

function apply()
{
	$dir = $this->_FILTERS_DIR ;
	if ( !file_exists($dir) ) {
		return false;
	}

	$dh = opendir($dir);
	if ( !$dh ) {
		return false;
	}

	while (($filter = readdir($dh)) !== false) 
	{
		if (preg_match('/^\./', $filter)) { continue; }

		$file = $dir .'/'. $filter;
		if ( !file_exists($file) ) { continue; }

		include_once( $file );
		$filter_base = preg_replace('/^(.*)\.php/', '$1', $filter);

		$classname = ucfirst($filter_base).'IDFilter';
		if ( !class_exists($classname) ) { continue; }

		$obj = new $classname();
		if ( !is_object($obj) ) { continue; }

		$obj->setOption($this->_option);
		$obj->setId($this->_id);
		$obj->apply();
		$this->_id = $obj->getFilteredID();
	}
	
	closedir($dh);
	return true;
}

// === class end ===
}
