<?php
// $Id: simple_url.php,v 1.2 2009/07/14 13:31:24 ohwada Exp $

//===================================================================
// simple url Netcommons
// 2009-03-08 K.OHWADA
//===================================================================

//===================================================================
// change log
// 2009-10-05 K.OHWADA
// for SSL
// 2009-09-01 K.OHWADA
// for 2.2.0.0
// 2009-07-01 K.OHWADA
// for 2.1.1.0
//===================================================================

//===================================================================
// simple url
//
// index.php?action=pages_view_main&page_id=xx
// -> page_xx.html
//
// index.php?action=pages_view_main&active_action=bbs_view_main_post&post_id=xx&block_id=xx#_xx
// -> bbs_xx_xx.html#_xx
//
// index.php?action=pages_view_main&active_action=journal_view_main_detail&post_id=xx&block_id=xx#_xx
// -> journal_xx_xx.html#_xx
//
// ?action=cabinet_action_main_download&block_id=xx&room_id=xx&cabinet_id=xx&file_id=xx&upload_id=xx
// -> cabinet_xx_xx_xx_xx_xx.html
//
// ./abc
// -> BASE_URL/abc
//
//===================================================================

function simple_url( $str ) 
{
	$URL      = BASE_URL. '/';
	$URL_PREG = preg_quote( $URL, '/' );
	$URL_PREG = preg_replace("/^http/i","http[s]?", $URL_PREG);

// for SSL
	if (isset($_SERVER['HTTPS'])
		&& (strtolower($_SERVER['HTTPS']) == 'on')
		&& !preg_match("/^https:\/\//i", BASE_URL) ) {
		$URL = preg_replace("/^http:\/\//i","https://", $URL);
	}

	$pre_a    = '/<a([^>]*)href=([\'\"]{0,1})';
	$post_a   = '([\'\"]{1})([^>]*)>/i';
	$rep_a    = '<a$1 href=$2'.   $URL ;

	$pre_img  = '/<img([^>]*)src=([\'\"]{0,1})';
	$post_img = '([\'\"]{1})([^>]*)>/i';
	$rep_img  = '<img$1 src=$2'. $URL ;

	$page = 'index.php\?action=pages_view_main&page_id=([0-9]*)';
	$page_replace = $rep_a. 'page_$3.html$4 $5>' ;

	$bbs = '\.\/index.php\?action=pages_view_main&active_action=bbs_view_main_post&post_id=([0-9]*)&block_id=([0-9]*)#_([0-9]*)';

	$journal_1 = '\.\/index.php\?action=pages_view_main&active_action=journal_view_main_detail&post_id=([0-9]*)&block_id=([0-9]*)#_([0-9]*)';

// for 2.2.0.0
	$journal_2 = 'index.php\?active_action=journal_view_main_detail&post_id=([0-9]*)&block_id=([0-9]*)&comment_flag=([0-9]*)#_([0-9]*)';

	$cabinet = '\?action=cabinet_action_main_download&block_id=([0-9]*)&room_id=([0-9]*)&cabinet_id=([0-9]*)&file_id=([0-9]*)&upload_id=([0-9]*)';

	$page_w3c      = str_replace('&', '&amp;', $page);
	$bbs_w3c       = str_replace('&', '&amp;', $bbs);
	$journal_1_w3c = str_replace('&', '&amp;', $journal_1);
	$journal_2_w3c = str_replace('&', '&amp;', $journal_2);
	$cabinet_w3c   = str_replace('&', '&amp;', $cabinet);

	$etc1 = '\.\/([^>]*)';
	$etc2 = '([^>]*)';

	$pattern = array(
		$pre_a. $URL_PREG. $page. $post_a ,
		$pre_a. '\.\/'. $page. $post_a ,
		$pre_a. $page. $post_a ,
		$pre_a. $URL_PREG. $page_w3c. $post_a ,
		$pre_a. '\.\/'. $page_w3c. $post_a ,
		$pre_a. $page_w3c. $post_a ,
		$pre_a. $bbs. $post_a ,
		$pre_a. $bbs_w3c. $post_a ,
		$pre_a. $journal_1. $post_a ,
		$pre_a. $journal_1_w3c. $post_a ,
		$pre_a. $URL_PREG. $journal_2. $post_a ,
		$pre_a. $URL_PREG. $journal_2_w3c. $post_a ,
		$pre_a. $cabinet. $post_a ,
		$pre_a. $cabinet_w3c. $post_a ,
		$pre_a. $etc1. $post_a ,
		$pre_a.   $URL_PREG. $etc2. $post_a ,
		$pre_img. $URL_PREG. $etc2. $post_img ,
	);

	$rep_alacement = array(
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$rep_a. 'bbs_$3_$4.html#_$5$6 $7>' ,
		$rep_a. 'bbs_$3_$4.html#_$5$6 $7>' ,
		$rep_a. 'journal_$3_$4.html#_$5$6 $7>' ,
		$rep_a. 'journal_$3_$4.html#_$5$6 $7>' ,
		$rep_a. 'journal_$3_$4_$5.html#_$6$7 $8>' ,
		$rep_a. 'journal_$3_$4_$5.html#_$6$7 $8>' ,
		$rep_a. 'cabinet_$3_$4_$5_$6_$7.html$8 $9>' ,
		$rep_a. 'cabinet_$3_$4_$5_$6_$7.html$8 $9>' ,
		$rep_a.   '$3$4 $5>' ,
		$rep_a.   '$3$4 $5>' ,
		$rep_img. '$3$4 $5>' ,
	);

	return preg_replace( $pattern, $rep_alacement, $str ); 
}

?>