<?php
// 2009-08-01

//=========================================================
// class raxearch_shop
//=========================================================
class raxearch_shop extends raxearch_builder
{

function init()
{
	$this->init_builder();

	$this->_keyword  = $this->_mod_config['keyword'];
	$this->_shopCode = $this->_mod_config['shopcode'];
	$this->_orFlag   = $this->_mod_config['orflag'];
}

function set_get_param()
{
	$this->_page = $this->get_param_page();
}

function build_shop()
{
	$search = new raxearch_search();
	$search->init();
	$search->set_keyword( $this->_keyword );
	$search->set_page( $this->_page );
	$search->set_sort( $this->_sort );
	$search->set_price( $this->_maxPrice, $this->_minPrice );
	$search->set_shopCode( $this->_shopCode );
	$search->set_orFlag( $this->_orFlag );
	$responseXML = $search->item_search( $this->_keyword );
	$keyword     = $search->get_keyword();

	$parser = new raxearch_parser();
	$resultData = $parser->parseXML($responseXML);

	$rakutenResult = $this->array_mb_convert_encoding($resultData);
	$itemsOut = $this->build_items( $rakutenResult, $keyword );

	return array(
		'keyword'      => $keyword,
		'page'         => $search->get_page(),
		'sort_h'       => $this->h( $search->get_sort() ),
		'maxPrice'     => $search->get_maxPrice(),
		'minPrice'     => $search->get_minPrice(),
		'searchResult' => $rakutenResult, 
		'items'        => $itemsOut,
	);
}

// --- class end ---
}

?>