<?php
// 2009-08-01

define('_RAXEARCH_DEFAULT_SORT', '-updateTimestamp');
define('_RAXEARCH_ITEM_SEARCH_VERSION',          '2009-04-15');
define('_RAXEARCH_KEYWORD_HOTEL_SEARCH_VERSION', '2009-04-23');
define('_RAXEARCH_SIMPLE_HOTEL_SEARCH_VERSION',  '2008-11-13');

//=========================================================
// class raxearch_search
//=========================================================
class raxearch_search
{
	var $_API_URL  = 'http://api.rakuten.co.jp/rws/2.0/rest';
	var $_API_PORT = 80;
	var $_timeout  = 10;

	var $_proxy_server = '';
	var $_proxy_port   = '';
	var $_api_server   = '';
	var $_api_path     = '';

	var $_SORT_LIST = array(
		'+affiliateRate', '-affiliateRate', '+reviewCount', '-reviewCount',
		'+itemPrice', '-itemPrice', '+updateTimestamp', '-updateTimestamp', 'standard');

	var $_carrier  = 0;	// pc
	var $_availability = '1';
	var $_genreId = '';
	var $_sumDisplayFlag = '1';
		
// init param
	var $_developerId = '';
	var $_affiliateId = '';
	var $_hits = '';
	var $_debug = false;

// set param
	var $_keyword     = '';
	var $_sort = _RAXEARCH_DEFAULT_SORT;
	var $_page = 1;
	var $_maxPrice = '';
	var $_minPrice = '';
	var $_shopCode = '';
	var $_orFlag = 0;

function init()
{
	global $xoopsModuleConfig;

	$this->_developerId = $xoopsModuleConfig['developerId'];
	$this->_affiliateId = $xoopsModuleConfig['affiliateId'];
	$this->_hits        = $xoopsModuleConfig['hits'];

//	API URL
	if (preg_match('!^(http://)([^/]+)(.+)$!', $this->_API_URL, $m)) {
		$this->_api_server = $m[2];
		$this->_api_path   = $m[3];
	}
}

function set_keyword( $val )
{
	$this->_keyword = $val;
}

function get_keyword()
{
	return $this->_keyword;
}

function set_page( $val )
{
	$val = intval($val);
	if ( $val < 0 ) {
		$val = 0;
	}
	$this->_page = $val;
}

function get_page()
{
	return $this->_page;
}

function set_price( $max, $min )
{
	$max = intval($max);
	$min = intval($min);

	if ( $max < 0 ) {
		$max = 0;
	}

	if ( $min < 0 ) {
		$min = 0;
	}

// exchange
	if (($max != 0) && ($max < $min)) { 
		$temp = $max; 
		$max  = $min; 
		$min  = $temp; 
	}

	if ( $max > 0 ) {
		$this->_maxPrice = $max;
	}

	if ( $min > 0 ) {
		$this->_minPrice = $min;
	}
}

function get_maxPrice()
{
	return $this->_maxPrice;
}

function get_minPrice()
{
	return $this->_minPrice;
}

function set_sort( $val )
{
	if ($val != '') { 
		if ( !preg_match('/^(\+|-).+/', $val) ) {
			$val = '+'.$val; 
		}
		if ( in_array($val, $this->_SORT_LIST) ) {
			$this->_sort = $val;
		}
	}
}

function get_sort()
{
	return $this->_sort;
}

function set_shopCode( $val )
{
	$this->_shopCode = $val;
}

function get_shopCode()
{
	return $this->_shopCode;
}

function set_orFlag( $val )
{
	$this->_orFlag = intval($val);
}

function get_orFlag()
{
	return $this->_orFlag;
}

function get_hits()
{
	return $this->_hits;
}

function item_search()
{
	//	Call fetcher
	$parameters = array();
	$parameters['version']      = _RAXEARCH_ITEM_SEARCH_VERSION;
	$parameters['operation']    = 'ItemSearch';
	$parameters['developerId']  = $this->_developerId;
	$parameters['hits']         = $this->_hits;
	$parameters['carrier']      = $this->_carrier;
	$parameters['availability'] = $this->_availability;
	$parameters['keyword']      = $this->urlencode_keyword();

	if ( $this->_affiliateId ) {
		$parameters['affiliateId']	= $this->_affiliateId;
	}
	if ($this->_page > 0) {
		$parameters['page']	= $this->_page;
	}
	if ($this->_sort != '') {
		$parameters['sort']	= urlencode($this->_sort);
	}
	if ($this->_shopCode != '') {
		$parameters['shopCode']	= $this->_shopCode;
	}
	if ($this->_genreId != '') {
		$parameters['genreId']	= $this->_genreId;
	}
	if ($this->_maxPrice != '') {
		$parameters['maxPrice']	= $this->_maxPrice;
	}
	if ($this->_minPrice != '') {
		$parameters['minPrice']	= $this->_minPrice;
	}
	if ( $this->_orFlag ) {
		$parameters['orFlag'] = $this->_orFlag;
	}

	//	$parameters['field']		= '1';

	return $this->fetcher($parameters);
}

function keyword_hotel_search() 
{
	$parameters = array();
	$parameters['version']     = _RAXEARCH_KEYWORD_HOTEL_SEARCH_VERSION;
	$parameters['operation']   = 'KeywordHotelSearch';
	$parameters['developerId'] = $this->_developerId;
	$parameters['affiliateId'] = $this->_affiliateId;
	$parameters['hits']        = $this->_hits;
	$parameters['keyword']     = $this->urlencode_keyword();
	$parameters['carrier']     = $this->_carrier;
	$parameters['sumDisplayFlag'] = $this->_sumDisplayFlag;

	if ($this->_page > 0) {
		$parameters['page']	= $this->_page;
	}

	return $this->fetcher($parameters);
}

function simple_hotel_search ($hotelNo = '') 
{
	//	Call fetcher
	$parameters = array();
	$parameters['version']     = _RAXEARCH_SIMPLE_HOTEL_SEARCH_VERSION;
	$parameters['operation']   = 'SimpleHotelSearch';
	$parameters['developerId'] = $this->_developerId;
	$parameters['affiliateId'] = $this->_affiliateId;
	$parameters['hotelNo']     = urlencode(mb_convert_encoding($hotelNo, 'UTF-8', _CHARSET));
	$parameters['carrier']     = $this->_carrier;

	return $this->fetcher($parameters);
}

function urlencode_keyword()
{
	if (_CHARSET == 'UTF-8') {
		$keyword = urlencode($this->_keyword);
	} else {
		$keyword = urlencode(mb_convert_encoding($this->_keyword, 'UTF-8', _CHARSET));
	}
	return $keyword;
}

function fetcher( $parameters ) 
{
	//	Paraqmeters to Query
	$queryString = '';
	$delimeter = '';
	if (is_array($parameters)) {
		foreach ($parameters as $key => $val) {
			$queryString .= $delimeter.trim($key).'='.trim($val);
			$delimeter = '&';
		}
	} else {
		return false;
	}

	//	Puts request
	if ( $this->_proxy_server != '') {
		$fp = @fsockopen($this->_proxy_server, $this->_proxy_port, $errorNumber, $errorString, $this->_timeout);
		$RequestURI = "http://".$this->_api_server.":".$this->_API_PORT.$this->_api_path."?".$queryString;
	} else {
		$fp = @fsockopen($this->_api_server, $this->_API_PORT, $errorNumber, $errorString, $this->_timeout);
		$RequestURI = $this->_api_path."?".$queryString;
	}
	if (!$fp) {
		return false;
	}

	if ( $this->_debug ) {
		echo "Request: $RequestURI <br />\n";
	}

	$requestHeader =	"GET $RequestURI HTTP/1.0\r\n".
				"User-Agent: raxearch/PHP".phpversion()."\r\n".
				"Host: ".$this->_api_server."\r\n\r\n";
	fputs($fp, $requestHeader);

	//	Get Result
	$responseBuffer = '';
	while (!feof($fp)) { $responseBuffer .= fgets($fp, 1024); }
	fclose($fp);
	//	
	$responseBuffer = str_replace("\r\n", "\n", $responseBuffer);
	list($responseHeader, $responseBody) = explode("\n\n", $responseBuffer, 2);
	preg_match('/^([\S]+) ([\d]{3}) ([^\n]*)/', $responseHeader, $matches);
	if (($matches[2] != 200) && ($matches[3] != 'OK')) {
		return false;
	}
	//	
	return $responseBody;
}

// --- class end ---
}

?>