<?php
// 2009-08-01

//=========================================================
// class raxearch_parser
//=========================================================
class raxearch_parser 
{
	var $xmlParser, $xmlSource;
	var $resultArray, $tagFlag, $xmlData, $itemsCount;

function raxearch_xml_parser () 
{
	$this->resultArray = array();
	$this->tagFlag = array(	'Header' => false, 'Body' => false,
				'Items' => false, 'Item' => false,
				'keywordHotelSearch' => false, 'hotelSimple' => false,
				'hotel' => false);
	$this->xmlData = '';
	$this->itemsCount = 0;
}

function parseXML ($source) 
{
	$this->xmlSource = $source;
	$this->xmlParser = xml_parser_create("UTF-8");
	xml_parser_set_option($this->xmlParser, XML_OPTION_CASE_FOLDING, false);
	xml_set_object($this->xmlParser, $this);
	xml_set_element_handler($this->xmlParser, "startElement", "endElement");
	xml_set_character_data_handler($this->xmlParser, "characters");
	if (!xml_parse($this->xmlParser, $this->xmlSource)) {
		exit();
	}
	xml_parser_free($this->xmlParser);
	return $this->resultArray;
}

function characters ($parser, $text) 
{
	$this->xmlData .= $text;
}

function startElement ($parser, $name, $attrib) 
{
	$this->xmlData = '';
	$this->tagFlag[$name] = true;
}

function endElement ($parser, $name) 
{
	if ( ( isset($this->tagFlag['Item']) && $this->tagFlag['Item'] ) || 
		 ( isset($this->tagFlag['hotelSimple']) && $this->tagFlag['hotelSimple'] )|| 
		 ( isset($this->tagFlag['hotel']) && $this->tagFlag['hotel'] ) ) {
		$this->resultArray['Item'][$this->itemsCount][$name] = $this->xmlData;
	} else {
		$this->resultArray[$name] = $this->xmlData;
	}

	$this->tagFlag[$name] = false;
	$this->xmlData = '';
	if (($name == 'Item') || ($name == 'hotelSimple') || ($name == 'hotel')) {
		$this->itemsCount++;
	}
}

// --- class end ---
}

?>