<?php
// 2009-08-01

//=========================================================
// class raxearch_item
//=========================================================
class raxearch_item extends raxearch_builder
{

function init()
{
	$this->init_builder();
}

function set_get_param()
{
	$this->_keyword  = $this->get_param_keyword();
	$this->_page     = $this->get_param_page();
	$this->_sort     = $this->get_param_sort();
	$this->_maxPrice = $this->get_param_zen_to_han( 'maxPrice' );
	$this->_minPrice = $this->get_param_zen_to_han( 'minPrice' );
}

function build_item()
{
	$search = new raxearch_search();
	$search->init();
	$search->set_keyword( $this->_keyword );
	$search->set_page( $this->_page );
	$search->set_sort( $this->_sort );
	$search->set_price( $this->_maxPrice, $this->_minPrice );
	$responseXML = $search->item_search();
	$keyword     = $search->get_keyword();
	$page        = $search->get_page();

	$parser = new raxearch_parser();
	$resultData = $parser->parseXML($responseXML);

	$rakutenResult = $this->array_mb_convert_encoding($resultData);
	$searchResult  = $this->build_result( $rakutenResult, $page );
	$itemsOut      = $this->build_items( $rakutenResult, $keyword );

	return array(
		'keyword'      => $keyword,
		'page'         => $page,
		'sort_h'       => $this->h( $search->get_sort() ),
		'maxPrice'     => $search->get_maxPrice(),
		'minPrice'     => $search->get_minPrice(),
		'searchResult' => $searchResult, 
		'items'        => $itemsOut,
	);
}

function build_result( $rakutenResult, $page )
{
	$searchResult = array();
	foreach ($rakutenResult as $key => $val) 
	{
		if (!is_array($val)) { $searchResult[$key] = $val; }
	}

	if (isset($searchResult['pageCount'])) {
		$searchResult['nextPage'] = (($searchResult['pageCount'] > $page) ? $page + 1 : 0);
		$searchResult['prevPage'] = (($page > 1) ? $page - 1 : 0);
	}

	if (isset($searchResult['count'])) {
		$searchResult['countF'] = number_format(intval($searchResult['count']));
	}

	return $searchResult;
}

// --- class end ---
}

?>