<?php
// 2009-08-01

//=========================================================
// class raxearch_image
//=========================================================
class raxearch_image
{
	var $_snoopy_class;
	var $_mod_name;
	var $_work_dir;

function init()
{
	global $xoopsModule, $xoopsModuleConfig;
	$this->_mod_dirname = $xoopsModule->getVar('dirname', 'n');
	$this->_work_dir = XOOPS_ROOT_PATH.'/modules/'.$this->_mod_dirname.'/cache';

	$this->_snoopy_class = new Snoopy();
}

function get_size( $url, $max_width, $max_height )
{
	$size = $this->get_image_size( $url );
	if ( !is_array($size) ) {
		return array( 0, 0 );
	}
	return $this->adjust_image_size( $size[0], $size[1], $max_width, $max_height );
}

function adjust_image_size( $width, $height, $max_width, $max_height )
{
	if ( $width > $max_width ) {
		$mag    = $max_width / $width;
		$width  = $max_width;
		$height = $height * $mag;
	}

	if ( $height > $max_height ) {
		$mag    = $max_height / $height;
		$height = $max_height;
		$width  = $width * $mag;
	}

	return array( intval($width), intval($height) );
}

function get_image_size( $url )
{
	if ( empty($url) || ($url == 'http://') || ($url == 'https://') ) {
		return false;
	}

	$data = $this->read_remote_file( $url );
	if ( !$data ) {
		return false;
	}

	$file = tempnam( $this->_work_dir, "image" );

	if ( ! $this->write_file( $file, $data ) ) {
		return false;
	}

	$size = getimagesize($file);

	unlink($file);

	return $size;
}

function read_remote_file( $url )
{
	if ( empty($url) ) {
		return false;
	}

	if ( ! $this->_snoopy_class->fetch( $url ) ) {
		return false;
	}

	return $this->_snoopy_class->results;
}

function write_file( $file, $data, $mode='w' )
{
	$fp = fopen( $file , $mode ) ;
	if ( !$fp ) { return false ; }

	$byte = fwrite( $fp , $data ) ;
	fclose( $fp ) ;

// the user can delete this file which apache made.
	if (( $byte > 0 ) && !ini_get('safe_mode') ) {
		chmod( $file, 0777 );
	}

	return $byte;
}

// --- class end ---
}

?>