<?php
// 2009-08-01

//=========================================================
// class raxearch_hotel
//=========================================================
class raxearch_hotel extends raxearch_builder
{
	var $_search_class;
	var $_parser_class;

function init()
{
	$this->init_builder();

	$this->_search_class = new raxearch_search();
	$this->_search_class->init();

	$this->_parser_class = new raxearch_parser();
}

function set_get_param()
{
	$this->_keyword  = $this->get_param_keyword();
	$this->_page     = $this->get_param_page();
}

function build_hotel()
{
	$this->_search_class->set_keyword( $this->_keyword );
	$this->_search_class->set_page( $this->_page );
	$this->_search_class->set_sort( $this->_sort );
	$this->_search_class->set_price( $this->_maxPrice, $this->_minPrice );
	$responseXML = $this->_search_class->keyword_hotel_search();
	$keyword     = $this->_search_class->get_keyword();
	$page        = $this->_search_class->get_page();
	$hits        = $this->_search_class->get_hits();

	$resultData = $this->_parser_class->parseXML($responseXML);

	$rakutenResult = $this->array_mb_convert_encoding($resultData);
	list($searchResult, $hotelInfo) = $this->build_result( $rakutenResult, $page, $hits );
	$itemsOut      = $this->build_hotels( $rakutenResult, $keyword, $hotelInfo );

	return array(
		'keyword'      => $keyword,
		'page'         => $page,
		'sort_h'       => $this->h( $this->_search_class->get_sort() ),
		'maxPrice'     => $this->_search_class->get_maxPrice(),
		'minPrice'     => $this->_search_class->get_minPrice(),
		'searchResult' => $searchResult, 
		'items'        => $itemsOut,
	);
}

function build_result( $rakutenResult, $page, $hits )
{
	$hotelInfo = '';

	$searchResult = array();
	$searchResult['hits'] = 0;
	$searchResult['prevPage'] = (($page > 1) ? $page - 1 : 0);

	foreach ($rakutenResult as $key => $val) 
	{
		if (!is_array($val)) { $searchResult[$key] = $val; }
	}

	if ( isset($searchResult['recordCount']) ) {
		$searchResult['recordCountF'] = number_format(intval($searchResult['recordCount']));
		$searchResult['pageCount'] = ceil($searchResult['recordCount'] / $hits );
		$searchResult['nextPage'] = (($searchResult['pageCount'] > $page) ? $page + 1 : 0);
	}


	$hotelNos = '';
	$comma = '';
	if (isset($rakutenResult['Item'])) {
		foreach ($rakutenResult['Item'] as $itemData) 
		{
			$searchResult['hits']++;
			$hotelNos .= $comma . $itemData['hotelNo'];
			$comma = ',';
		}

		$responseXML = $this->_search_class->simple_hotel_search($hotelNos);
		$resultData  = $this->_parser_class->parseXML($responseXML);
		$hotelInfo   = $this->array_mb_convert_encoding($resultData);
	}

	$searchResult['first'] = ($page - 1) * $hits + 1;
	$searchResult['last'] = $searchResult['first'] + $searchResult['hits'] - 1;

	return array($searchResult, $hotelInfo);
}

// --- class end ---
}

?>