<?php
// 2009-08-01

//=========================================================
// class raxearch_builder
//=========================================================
class raxearch_builder
{
	var $_highlight_style = 'color:#ff0000; font-weight:bold;';

	var $_mod_name;
	var $_mod_dirname;
	var $_mod_config;

	var $_keyword  = '';
	var $_shopCode = '';
	var $_page = 1;
	var $_sort = _RAXEARCH_DEFAULT_SORT;
	var $_maxPrice = '';
	var $_minPrice = '';
	var $_orFlag = '';
	var $_max_image_width  = 128;
	var $_max_image_height = 128;

// init
	var $_affiliateId = '';
	var $_highlight = 0;
	var $_max_item_name = '';

function init_builder()
{
	global $xoopsModule, $xoopsModuleConfig;
	$this->_mod_name    = $xoopsModule->getVar('name', 'n');
	$this->_mod_dirname = $xoopsModule->getVar('dirname', 'n');
	$this->_mod_config  = $xoopsModuleConfig;

	$this->_highlight     = $this->_mod_config['highlight'];
	$this->_affiliateId   = $this->_mod_config['affiliateId'];
	$this->_max_item_name = $this->_mod_config['max_item_name'];
}

function get_param_page()
{
	return isset($_GET['page']) ? intval($_GET['page']) : 1;
}

function get_param_sort()
{
	return isset($_GET['sort']) ? trim($_GET['sort']) : _RAXEARCH_DEFAULT_SORT;
}

function get_param_num()
{
	return isset($_GET['num']) ? intval($_GET['num']) : 1;
}

function get_param_keyword()
{
	$keyword = '';
	if (isset($_GET['keyword'])) {
		$keyword = trim($_GET['keyword']);
	} else {
		foreach ($_GET as $key => $val) {
			if ($val == '') { $keyword = $key; break; }
		}
	}
	if ($keyword != '') {
		$keywordMbEncoding = mb_detect_encoding($keyword, _CHARSET.", auto");
		if ($keywordMbEncoding != _CHARSET) {
			$keyword = mb_convert_encoding ($keyword, _CHARSET, $keywordMbEncoding);
		}
	}
	$keyword = mb_ereg_replace("([,_+])", " ", $keyword);
	return $keyword;
}

function get_param_zen_to_han( $key )
{
// a: Convert "zen-kaku" alphabets and numbers to "han-kaku" 
	return isset($_GET[ $key ]) ? intval(mb_convert_kana($_GET[ $key ], 'a', _CHARSET)) : '';
}

function build_items( $rakutenResult, $keyword )
{
	$i = 0;
	$items = array();

	if ( !isset($rakutenResult['Item']) ) {
		return $items;
	}

	foreach ($rakutenResult['Item'] as $item) 
	{
		$temp = array();
		$temp['keyword']		= $this->h( $keyword );
		$temp['availability']	= intval($item['availability']);
		$temp['taxFlag']		= intval($item['taxFlag']);
		$temp['postageFlag']	= intval($item['postageFlag']);
		$temp['creditCardFlag']	= intval($item['creditCardFlag']);
		$temp['reviewCount']	= intval($item['reviewCount']);
		$temp['affiliateRate']	= floatval($item['affiliateRate']);
		$temp['reviewAverage']	= floatval($item['reviewAverage']);
		$temp['shopCode']	= $item['shopCode'];
		$temp['genreId']		= floatval($item['genreId']);
		$temp['itemName']	= $this->h($item['itemName']);
		$temp['itemNameF']	= $this->item_name_convert($item['itemName']);

		if ( $this->_highlight ) {
			$temp['itemNameF'] = $this->highlight_text($temp['itemNameF'], $keyword);
		}

		$temp['itemCode']	= $item['itemCode'];
		$temp['itemPrice']	= intval($item['itemPrice']);
		$temp['itemPriceF']	= number_format(intval($item['itemPrice']));
		$temp['shopName']	= $this->h($item['shopName']);
		$temp['shopNameF']	= $this->shop_name_convert($item['shopName']);
		$temp['itemCaption']	= nl2br($item['itemCaption']);

		if (preg_match('/<br/i', $item['itemCaption'])) {
			$temp['itemCaptionF']	= $item['itemCaption'];
		} else {
			$temp['itemCaptionF']	= $this->text_convert($item['itemCaption']);
		}

		if ( $this->_highlight ) {
			$temp['itemCaptionF']	= $this->highlight_text($temp['itemCaptionF'], $keyword);
		}

		$temp['itemUrl']		= $item['itemUrl'];
		$temp['affiliateUrl']	= $item['affiliateUrl'];
		$temp['smallImageUrl']	= $item['smallImageUrl'];
		$temp['mediumImageUrl']	= $item['mediumImageUrl'];
		$temp['startTime']	= $item['startTime'];
		$temp['endTime']		= $item['endTime'];
		$temp['shopUrl']		= $item['shopUrl'];

		if ( $this->_affiliateId ) {
			$temp['shopAffiliateUrl']= 'http://hb.afl.rakuten.co.jp/hgc/'.$this->_affiliateId.'/?pc='.urlencode($item['shopUrl']);
		}

		$temp['shopOfTheYearFlag']= $item['shopOfTheYearFlag'];

		$items[ $i ] = $temp;
		$i ++;
	}

	return $items;
}

function build_hotels( $rakutenResult, $keyword, $hotelInfo )
{
//print_r($hotelInfo);

	$i = 0;
	$items = array();
	$hotelDatas = array();

	if ( !isset($rakutenResult['Item']) ) {
		return $items;
	}

	if ( isset($hotelInfo['Item']) ) {
		foreach ($hotelInfo['Item'] as $infoData) 
		{
			$hotelDatas[ $infoData['hotelNo'] ] = $infoData;
		}
	}

	foreach ($rakutenResult['Item'] as $item) 
	{
		$hotelNo = $item['hotelNo'];

		$temp = array();
		$temp['keyword']		= $this->h($keyword);
		$temp['hotelNo']		= $item['hotelNo'];
		$temp['hotelName']	= $this->h($item['hotelName']);
		$temp['hotelNameF']	= $this->item_name_convert($item['hotelName']);
		if ($this->_highlight) {
			$temp['hotelNameF']	= $this->highlight_text($temp['hotelNameF'], $keyword);
		}
		$temp['areaSum']		= $this->h($item['areaSum']);
		$temp['hotelSpecialSum']	= $this->h($item['hotelSpecialSum']);
		$temp['hotelSpecialSumF']= $this->text_convert($item['hotelSpecialSum']);
		if ($this->_highlight) {
			$temp['hotelSpecialSumF'] = $this->highlight_text($temp['hotelSpecialSumF'], $keyword);
		}
		$temp['middleClassCode']	= $item['middleClassCode'];
		$temp['smallClassCode']	= $item['smallClassCode'];
		$temp['reviewAverage']	= floatval($item['reviewAverage']);
		$temp['reviewCount']	= intval($item['reviewCount']);

		$temp['hotelInformationUrl']	= $item['hotelInformationUrl'];
		$temp['hotelAffiliateUrl']	= $item['hotelAffiliateUrl'];

		if ( isset($hotelDatas[ $temp['hotelNo'] ] ) ) {

			$hotel = $hotelDatas[ $temp['hotelNo'] ];

			if ( isset($infoData['hotelKanaName']) ) {
				$temp['hotelKanaName']	= $this->h($hotel['hotelKanaName']);
			}

			if ( isset($hotel['hotelSpecial']) ) {
				$temp['hotelSpecial']	= $this->h($hotel['hotelSpecial']);
				$temp['hotelSpecialF']	= $this->text_convert($hotel['hotelSpecial']);

				if ($this->_highlight) {
					$temp['hotelSpecialF']	= $this->highlight_text($temp['hotelSpecialF'], $keyword);
					}
			}

			if ( isset($hotel['checkinTime']) ) {
				$temp['checkinTime']	= $this->h($hotel['checkinTime']);
			}
	
			if ( isset($hotel['checkoutTime']) ) {
				$temp['checkoutTime']	= $this->h($hotel['checkoutTime']);
			}

			if ( isset($hotel['address1']) ) {
				$temp['address1']	= $this->h($hotel['address1']);
			}

			if ( isset($hotel['address1']) ) {
				$temp['address2']	= $this->h($hotel['address2']);
			}

			if ( isset($hotel['access']) ) {
				$temp['access']		= $this->h($hotel['access']);
			}

			if ( isset($hotel['nearestStationName']) ) {
				$temp['nearestStationName'] = $this->h($hotel['nearestStationName']);
			}

			if ( isset($hotel['parkingInformation']) ) {
				$temp['parkingInformation'] = $this->h($hotel['parkingInformation']);
			}

			if ( isset($hotel['hotelClassCode']) ) {
				$temp['hotelClassCode']	= $this->h($hotel['hotelClassCode']);
			}

			if ( isset($hotel['hotelImageUrl']) ) {
				$temp['hotelImageUrl']	= $hotel['hotelImageUrl'];
			}
		}

		$items[] = $temp;
	}

	return $items;
}

function h($str) 
{
	return htmlspecialchars( $str, ENT_QUOTES );
}

function item_name_convert($str) 
{
	return $this->h( $this->mb_shorten($str, $this->_max_item_name) );
}

function shop_name_convert($str) 
{
	return $this->h($str);
}

function text_convert($str) 
{
	return $this->h($str);
}

function highlight_text ($str = '', $keywords = '') 
{
	foreach (explode(' ', $keywords) as $keyword) {
		if (!preg_match('/(<|>|&)/', $keyword)) {
			$str = str_replace($keyword, '<span style="'.$this->_highlight_style.'">'.$keyword.'</span>', $str);
		}
	}

	return $str;
}

function write_file( $file, $data, $mode='w' )
{
	$fp = fopen( $file , $mode ) ;
	if ( !$fp ) { return false ; }

	$byte = fwrite( $fp , $data ) ;
	fclose( $fp ) ;

// the user can delete this file which apache made.
	if (( $byte > 0 ) && !ini_get('safe_mode') ) {
		chmod( $file, 0777 );
	}

	return $byte;
}

function array_mb_convert_encoding ($d, $to = _CHARSET, $from = 'UTF-8') 
{
	if ($to == $from) { return $d; }
	if (is_array($d)) {
		foreach ($d as $key => $val) {
			$d[$key] = $this->array_mb_convert_encoding($val, $to, $from);
		}
		return $d;
	} else {
		return (mb_convert_encoding($d, $to, $from));
	}
}

function mb_shorten($str, $length)
{
	if ( $length == 0 ) {
		$str = '';
	} elseif ( ($length > 0) && mb_strlen($str, _CHARSET) > $length ) {
		$str = mb_substr( $str, 0, $length, _CHARSET ).'...';
	}
	return $str;
}

// --- class end ---
}

?>