<?php
// 2009-08-01

//=========================================================
// class raxearch_blog
//=========================================================
class raxearch_blog extends raxearch_builder
{
	var $_template = 'db:raxearch_blogparts.html';
	var $_cache_time = 3600;	// 1 hour
	var $_cache_id = '1';
	var $_num = 1;

function init()
{
	$this->init_builder();

	$this->_keyword   = $this->_mod_config['keyword'];
	$this->_shopCode  = $this->_mod_config['shopcode'];
	$this->_orFlag    = $this->_mod_config['orflag'];
	$this->_max_image_width  = $this->_mod_config['max_image_width'];
	$this->_max_image_height = $this->_mod_config['max_image_height'];
}

function set_get_param()
{
	$this->set_num( $this->get_param_num() );
}

function set_num( $val )
{
	$val = intval($val);
	if ( $val > 0 ) {
		$this->_num      = $val;
		$this->_cache_id = $val;
	}
}

function build_blog( $flag_force=false )
{
	$flag_assign = 0;	// no action
	$filename    = XOOPS_ROOT_PATH.'/modules/'.$this->_mod_dirname.'/cache/blogparts.'.$this->_cache_id.'.html';

// build template
	$tpl = new XoopsTpl();

// use cache
	if ( !$flag_force && ($this->_cache_time > 0) ) {
// 2: use cache time in every templates
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($this->_cache_time);
	}

	if ( $flag_force || ($this->_cache_time == 0) || !$tpl->is_cached($this->_template, $this->_cache_id) ) {
		$flag_assign = $this->assign_template( $tpl );
	}

// show file when failed
	if ( ($flag_assign == -1) && file_exists($filename) ) {
		return file_get_contents( $filename );

	} else {
		$contents = $tpl->fetch( $this->_template, $this->_cache_id );

// save file when succeeded
		if ( $flag_assign == 1 ) {
			$this->write_file( $filename, $contents );
		}

		return $contents;
	}
}

function assign_template( &$tpl )
{
	list($items, $item_num, $keyword) = $this->build_blog_items();

	$tpl->assign('xoops_charset', _CHARSET);
	$tpl->assign('pagetitle_h',  $this->h($this->_mod_name) );
	$tpl->assign('image_width',  $this->_max_image_width );
	$tpl->assign('image_height', $this->_max_image_height );
	$tpl->assign('keyword',   $keyword);
	$tpl->assign('item_num',  $item_num );
	$tpl->assign('items', $items);

// 1 succeeded ; -1 failed
	return ( $item_num > 0 ) ? 1 : -1 ;
}

function build_blog_items()
{
	$search = new raxearch_search();
	$search->init();
	$search->set_keyword( $this->_keyword );
	$search->set_shopCode( $this->_shopCode );
	$search->set_orFlag( $this->_orFlag );
	$responseXML = $search->item_search();
	$keyword     = $search->get_keyword();

	$parser = new raxearch_parser();
	$resultData = $parser->parseXML($responseXML);

	$rakutenResult = $this->array_mb_convert_encoding($resultData);
	$items = $this->build_items( $rakutenResult, $keyword );

// count of items
	$count = 0;
	if ( is_array($items) && count($items) ) {
		$count = count($items);
	}

	$item_num  = 0;
	$itemsRand = array();

	$image = new raxearch_image();
	$image->init();

// randomize when succeeded
	if ( $count > 0 ) {

		$num = $this->_num;
		if ( $num > $count ) {
			 $num = $count;
		}

		$keys = array_rand($items, $num);
		if ( !is_array($keys) ) {
			$keys = array( $keys );
		}

		foreach ( $keys as $key )
		{
			$temp = $items[ $key ];
			if ( isset($temp['mediumImageUrl']) ) {
				list( $width, $height ) =
					$image->get_size( 
						$temp['mediumImageUrl'], $this->_max_image_width, $this->_max_image_height );
				$temp['mediumImageWidth']  = $width;
				$temp['mediumImageHeight'] = $height;
			}
			$itemsRand[ $item_num ] = $temp;
			$item_num ++;
		}
	}

	return array($itemsRand, $item_num, $keyword);
}

// --- class end ---
}

?>