<?php
// $Id: simple_url.php,v 1.2 2009/07/14 13:31:24 ohwada Exp $

//===================================================================
// simple url Netcommons
// 2009-03-08 K.OHWADA
//===================================================================

//===================================================================
// change log
// 2009-07-01 K.OHWADA
// for 2.1.1.0
//===================================================================

//===================================================================
// simple url
//
// index.php?action=pages_view_main&page_id=xx
// -> page_xx.html
//
// index.php?action=pages_view_main&active_action=bbs_view_main_post&post_id=xx&block_id=xx#_xx
// -> bbs_xx_xx.html#_xx
//
// index.php?action=pages_view_main&active_action=journal_view_main_detail&post_id=xx&block_id=xx#_xx
// -> journal_xx_xx.html#_xx
//
// ?action=cabinet_action_main_download&block_id=xx&room_id=xx&cabinet_id=xx&file_id=xx&upload_id=xx
// -> cabinet_xx_xx_xx_xx_xx.html
//
// ./abc
// -> BASE_URL/abc
//
//===================================================================

function simple_url( $str ) 
{
	$URL      = BASE_URL. '/';
	$URL_PREG = preg_quote( $URL, '/' );

	$pre  = '/<a([^>]*)href=([\'\"]{0,1})';
	$post = '([\'\"]{1})([^>]*)>/i';
	$rep  = '<a$1 href=$2'. $URL ;

	$page = 'index.php\?action=pages_view_main&page_id=([0-9]*)';
	$page_replace = $rep. 'page_$3.html$4 $5>' ;

	$bbs = '\.\/index.php\?action=pages_view_main&active_action=bbs_view_main_post&post_id=([0-9]*)&block_id=([0-9]*)#_([0-9]*)';

	$journal = '\.\/index.php\?action=pages_view_main&active_action=journal_view_main_detail&post_id=([0-9]*)&block_id=([0-9]*)#_([0-9]*)';

	$cabinet = '\?action=cabinet_action_main_download&block_id=([0-9]*)&room_id=([0-9]*)&cabinet_id=([0-9]*)&file_id=([0-9]*)&upload_id=([0-9]*)';

	$page_w3c    = str_replace('&', '&amp;', $page);
	$bbs_w3c     = str_replace('&', '&amp;', $bbs);
	$journal_w3c = str_replace('&', '&amp;', $journal);
	$cabinet_w3c = str_replace('&', '&amp;', $cabinet);

	$etc = '\.\/([^>]*)';

	$pattern = array(
		$pre. $URL_PREG. $page. $post ,
		$pre. '\.\/'. $page. $post ,
		$pre. $page. $post ,
		$pre. $URL_PREG. $page_w3c. $post ,
		$pre. '\.\/'. $page_w3c. $post ,
		$pre. $page_w3c. $post ,
		$pre. $bbs. $post ,
		$pre. $bbs_w3c. $post ,
		$pre. $journal. $post ,
		$pre. $journal_w3c. $post ,
		$pre. $cabinet. $post ,
		$pre. $cabinet_w3c. $post ,
		$pre. $etc. $post ,
	);

	$replacement = array(
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$page_replace ,
		$rep. 'bbs_$3_$4.html#_$5$6 $7>' ,
		$rep. 'bbs_$3_$4.html#_$5$6 $7>' ,
		$rep. 'journal_$3_$4.html#_$5$6 $7>' ,
		$rep. 'journal_$3_$4.html#_$5$6 $7>' ,
		$rep. 'cabinet_$3_$4_$5_$6_$7.html$8 $9>' ,
		$rep. 'cabinet_$3_$4_$5_$6_$7.html$8 $9>' ,
		$rep. '$3$4 $5>' 
	);

	return preg_replace( $pattern, $replacement, $str ); 
}

?>