<?php
// $Id: List.class.php,v 1.1.1.1 2009/04/27 21:19:17 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchanger 一覧画面表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Headerchanger_View_Edit_List extends Action
{
	// パラメータを受け取るため
	var $module_id = null;
	var $block_id  = null;
	var $scroll    = null;

	// 使用コンポーネントを受け取るため
	var $headerchangerView = null;
	var $request = null;
	var $filterChain = null;

	// 値をセットするため
	var $visibleRows = null;
	var $blockList  = null;
	var $blockCount  = null;

    /**
     * Headerchanger 一覧画面表示アクション
     *
     * @access  public
     */
	function execute()
	{
		//scrollが_ON以外の場合、limitを設定する
		if ($this->scroll != _ON) {
			//Config変数の取得
			$config = $this->headerchangerView->getConfig( $this->module_id );
			$this->visibleRows = $config['list_row_count'];

			$this->request->setParameter("limit", $this->visibleRows);
			$this->blockCount = $this->headerchangerView->getBlockCount();
		}

		//block レコード一覧を取得する
		$this->blockList = $this->headerchangerView->getBlockList();
		if ( !is_array($this->blockList) ) {
			return "error";
		}

		//scrollが_ONの時、「テーマなし」に設定する。
		if ($this->scroll == _ON) {
			$view =& $this->filterChain->getFilterByName("View");
			$view->setAttribute("define:theme", 0);
			return "scroll";
		}

		return "screen";
    }
}
?>
