<?php
// $Id: Validator_GooglesearchView.class.php,v 1.1.1.1 2009/03/31 10:21:34 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch表示チェックバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
/**
 *  caller: Googlesearch_View_Main_Init, Googlesearch_View_Edit_Modify, Googlesearch_View_Edit_Preview
 */
class Googlesearch_Validator_GooglesearchView extends Validator
{
	// パラメータ
	var $module_id = null;

    /**
     * Googlesearch表示チェックバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {
// partsレコードの取得
		$container   =& DIContainerFactory::getContainer();
		$actionChain =& $container->getComponent("ActionChain");
		$actionName =   $actionChain->getCurActionName();
		$googlesearchView =& $container->getComponent("googlesearchView");

		if ($actionName == "googlesearch_view_main_init") {
			$parts_data = $googlesearchView->getCurPartsData();
		} else {
			$parts_data = $googlesearchView->getPartsData();
		}
		if ( empty($parts_data) ) {
			return $errStr;
		}

		$request =& $container->getComponent("Request");
		$request->setParameter("parts_data", $parts_data);

// Config変数の取得
		$config = $googlesearchView->getConfig( $this->module_id );
		$request->setParameter("apikey", $config['apikey'] );

        return;
    }

}
?>