<?php
// $Id: Validator_GooglesearchExists.class.php,v 1.1.1.1 2009/03/31 10:21:34 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch存在チェックバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_Validator_GooglesearchExists extends Validator
{
    /**
     * Googlesearch存在チェックバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {
		$container =& DIContainerFactory::getContainer();
        $googlesearchView =& $container->getComponent("googlesearchView");
		$request =& $container->getComponent("Request");

		//parts_idがなければ、カレントの値を設定する
		if (empty($attributes["parts_id"])) {
			$attributes["parts_id"] = $googlesearchView->getCurrentGooglesearchID();
        	$request->setParameter("parts_id", $attributes["parts_id"]);
		}

		//parts_idがなければ、エラー
		if (empty($attributes["parts_id"])) {
			return $errStr;
		}

		//block_idがなければ、エラー
		if (empty($attributes["block_id"])) {
        	return $errStr;
		}

		// partsレコードがなければ、エラー
        if (!$googlesearchView->googlesearchExists()) {
			return $errStr;
		}
        return;
    }
}
?>