<?php
// $Id: map.php,v 1.3 2009/03/01 06:58:26 ohwada Exp $

//================================================================
// Rss center Module
// 2009-02-20 K.OHWADA
//================================================================

include 'header.php';
include_once RSSC_ROOT_PATH.'/class/rssc_view_handler.php';
include_once RSSC_ROOT_PATH.'/class/rssc_map.php';

$view_handler  =& rssc_get_handler( 'view',         RSSC_DIRNAME );
$conf_handler  =& rssc_get_handler( 'config_basic', RSSC_DIRNAME );
$map_class     =& rssc_map::getInstance();
$icon_class    =& rssc_icon::getInstance();
$post          =& happy_linux_post::getInstance();
$pagenavi      =& happy_linux_pagenavi::getInstance();

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = RSSC_DIRNAME.'_map.html';
include XOOPS_ROOT_PATH.'/header.php';

$conf =& $conf_handler->get_conf();
$feed_limit     = $conf['main_map_perpage'];
$show_thumb     = $conf['main_map_show_thumb'] ;
$show_site      = $conf['main_map_show_site'] ;
$show_icon      = $conf['main_map_show_icon'] ;
$webmap_dirname = $conf['webmap_dirname'] ;

$link_show   = 0;
$feed_show   = 0;
$lid         = 0;
$channel     = array();
$feeds       = array();
$error       = '';
$reason      = '';
$navi        = '';
$feed_total  = 0;
$show_map    = 0;
$map         = null;
$element_map = null;
$icon_list   = null ;

$ret = $map_class->init( $webmap_dirname );
if ( $ret ) {

	$map_class->set_info_max(   $conf['main_map_info_max'] ) ;
	$map_class->set_info_width( $conf['main_map_info_width'] ) ;

	$view_handler->setFeedOrder(  $conf['main_map_order'] );
	$view_handler->setFutureDays( $conf['basic_future_days'] );
	$view_handler->setFlagSanitize( true );
	$view_handler->set_flag_ltype( true );
	$view_handler->set_flag_enclosure( true );
	$view_handler->set_title_html(   $conf['main_map_title_html'] );
	$view_handler->set_content_html( $conf['main_map_content_html'] );
	$view_handler->set_max_title(    $conf['main_map_max_title'] );
	$view_handler->set_max_content(  $conf['main_map_max_content'] );
	$view_handler->set_max_summary(  $conf['main_map_max_summary'] );

	$pagenavi->setPerpage( $feed_limit );
	$pagenavi->getGetPage();

	$where = ' (( geo_lat != 0 ) OR ( geo_long != 0 )) ';

	$feed_total = $view_handler->get_feed_count_by_where( $where );

	$pagenavi->setTotal($feed_total);
	$feed_start = $pagenavi->calcStart();

	$feeds = $view_handler->get_feeds_by_where( $where, $feed_limit, $feed_start );

	if ( is_array($feeds) && count($feeds) ) {
		$feed_show = 1;
		$show_map  = 1;

		$param = $map_class->fetch_map( $feeds );
		$map         = $param['map'] ;
		$element_map = $param['element_map'] ;

		$param = array(
			'feeds'      => $feeds ,
			'show_thumb' => $show_thumb ,
			'show_icon'  => $show_icon ,
			'show_site'  => $show_site ,
			'keywords'   => null ,
		);
		$feed_list = $view_handler->fetch_tpl_feed_list( $param );
	}

	$url = RSSC_URL.'/map.php';
	$navi = $pagenavi->build($url);

	if ( $show_icon ) {
		$icon_list = $icon_class->build_template_icon_list( RSSC_DIRNAME );
	}

} else {
	$reason = 'NOT exist webmap module';
}

$xoopsTpl->assign('show_map',    $show_map );
$xoopsTpl->assign('map',         $map );
$xoopsTpl->assign('element_map', $element_map );
$xoopsTpl->assign('feed_list',   $feed_list );
$xoopsTpl->assign('icon_list',   $icon_list );

$xoopsTpl->assign( $view_handler->get_tpl_common_param() );

$xoopsTpl->assign('lang_total',   sprintf(_RSSC_THEREARE, $feed_total) );

$xoopsTpl->assign('link_show',   $link_show);
$xoopsTpl->assign('feed_show',   $feed_show);
$xoopsTpl->assign('rssc_error',  $error);
$xoopsTpl->assign('rssc_reason', $reason);
$xoopsTpl->assign('rssc_navi',   $navi);

$xoopsTpl->assign('execution_time',  happy_linux_get_execution_time() );
$xoopsTpl->assign('memory_usage',    happy_linux_get_memory_usage_mb() );
include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>