<?php
// $Id: Location.class.php,v 1.1.1.1 2009/01/05 08:39:18 ohwada Exp $

//=========================================================
// Googlemap Netcommons
// 2009-01-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlemap位置選択画面
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlemap_View_Main_Location extends Action
{
	// コンポーネント
	var $googlemapView = null;

	// パラメータ
	var $module_id = null;

	// 出力値
	var $id         = null;
	var $parts_data = null;
	var $apikey     = null;

    /**
     * Googlemap新規作成画面表示
     *
     * @access  public
     */
	function execute()
	{
		$parts_data = null;

// 入力パラメータ
		$id       = isset($_GET['id'])       ? $_GET['id']               : null ;
		$parts_id = isset($_GET['parts_id']) ? intval($_GET['parts_id']) : 0 ;

// $parts_id のデータを取得する
		if ( $parts_id > 0 ) {
			$parts_data = $this->googlemapView->getPartsDataByPartsId( $parts_id );
		}

// 取得できないときは、デフォルト値
		if ( ! is_array($parts_data) ) {
			$parts_data = $this->googlemapView->getPartsDataDefaultCreate();
		}

		$this->id = $id;
		$this->parts_data = $parts_data;

// Config変数を取得する
		$config = $this->googlemapView->getConfig( $this->module_id );
		$this->apikey = $config['apikey'];

		return "success";
	}
}
?>