<?php
// $Id: mail_register.php,v 1.3 2008/08/09 08:19:02 ohwada Exp $

//=========================================================
// webphoto module
// 2008-08-01 K.OHWADA
//=========================================================

if( ! defined( 'XOOPS_TRUST_PATH' ) ) die( 'not permit' ) ;

//=========================================================
// class webphoto_main_mail_register
//=========================================================
class webphoto_main_mail_register extends webphoto_base_this
{
	var $_user_handler;
	var $_parse_class;
	var $_xoops_user_class;

	var $_is_set_mail = false;
	var $_has_mail    = false;

	var $_post_user_uid = 0;

	var $_row_current = null;
	var $_row_update  = null;
	var $_is_new      = false;

	var $_REDIRECT_THIS_URL = null;

	var $_TIME_SUCCESS  = 1;
	var $_TIME_FAIL     = 5;

	var $_ERR_NOMATCH_USER = -1;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function webphoto_main_mail_register( $dirname , $trust_dirname )
{
	$this->webphoto_base_this( $dirname , $trust_dirname );

	$this->_user_handler     =& webphoto_user_handler::getInstance( $dirname );
	$this->_parse_class      =& webphoto_lib_mail_parse::getInstance();
	$this->_xoops_user_class =& webphoto_xoops_user::getInstance();

	$this->_is_set_mail = $this->_config_class->is_set_mail();
	$this->_has_mail    = $this->_perm_class->has_mail();
}

function &getInstance( $dirname , $trust_dirname )
{
	static $instance;
	if (!isset($instance))  {
		$instance = new webphoto_main_mail_register( $dirname , $trust_dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function check_action()
{
	$this->_check();

	$action = $this->_get_action();
	switch ( $action ) 
	{
		case 'submit':
			$this->_check_token_exit();
			if ( $this->_check_submit() ) {
				$this->_submit();
				exit();
			}
			break;

		default:
			break;
	}

	return true;
}

//---------------------------------------------------------
// check
//---------------------------------------------------------
function _check()
{
	$this->clear_errors();

// set login uid if not specify uid
	$this->_post_user_uid = $this->_post_class->get_post_get_int( 'user_uid', $this->_xoops_uid );

	$this->_REDIRECT_THIS_URL = $this->_MODULE_URL .'/index.php?fct=mail_register&amp;user_uid='. $this->_post_user_uid ;

	switch ( $this->_exec_check( $this->_post_user_uid ) )
	{
		case _C_WEBPHOTO_ERR_NO_PERM:
			redirect_header( $this->_INDEX_PHP , $this->_TIME_FAIL , _NOPERM ) ;
			exit ;

		case $this->_ERR_NOMATCH_USER:
			redirect_header( $this->_INDEX_PHP , $this->_TIME_FAIL , $this->get_constant('NOMATCH_USER') ) ;
			exit ;

		case 0:
		default:
			break;
	}

	return true;
}

function _exec_check( $user_uid )
{
	if ( ! $this->_is_set_mail ) {
		return _C_WEBPHOTO_ERR_NO_PERM;
	}

	if ( ! $this->_has_mail ) {
		return _C_WEBPHOTO_ERR_NO_PERM;
	}

// specified user id
	if ( $user_uid > 0 ) {
		$user = $this->_xoops_user_class->get_user_by_uid( $user_uid );
		if ( !is_object($user) ) {
			return $this->_ERR_NOMATCH_USER;
		}

		$row = $this->_user_handler->get_row_by_uid( $user_uid );
		if ( !is_array($row) ) {
			$this->_is_new = true;
			$row = $this->_user_handler->create( true );
			$row['user_uid'] = $user_uid;
		}

// guest
	} else {
		return $this->_ERR_NOMATCH_USER;
	}

	if ( ! $this->_check_perm( $row ) ) {
		return _C_WEBPHOTO_ERR_NO_PERM; 
	}

// save
	$this->_row_current = $row;
	return 0;
}

function _check_perm( $row )
{
// if admin
	if ( $this->_is_module_admin ) {
		return true;
	}

// user can register own record
	if ( ( $this->_xoops_uid != 0 ) && 
	     ( $this->_xoops_uid == $row['user_uid'] ) ) {
		return true;
	}

	return false;
}

function _get_action()
{
	return $this->_post_class->get_post_text('op' );
}

function _check_token_exit()
{
	if ( ! $this->check_token() )  {
		$msg = 'Token Error';
		if ( $this->_is_module_admin ) {
			$msg .= '<br />'.$this->get_token_errors();
		}
		redirect_header( $this->_REDIRECT_THIS_URL, $this->_TIME_FAIL , $msg );
		exit();
	}
}



//---------------------------------------------------------
// modify
//---------------------------------------------------------
function _check_submit()
{
	$email = $this->_post_class->get_post_text( 'user_email' );

// overwrite
	$this->_row_current['user_email']  = $email;
	$this->_row_current['user_cat_id'] = $this->_post_class->get_post_int('user_cat_id');

	if ( empty($email) ) {

// if new
		if ( $this->_is_new ) {
			$this->set_error( $this->get_constant('ERR_MAIL_EMPTY') );
			return false ;

// allow to clear email
		} else {
			return true ;
		}
	}

	$email = $this->_parse_class->parse_mail_addr( $email );
	if ( empty($email) ) {
		$this->set_error( $this->get_constant('ERR_MAIL_ILLEGAL') );
		return false ;
	}

	return true;
}

function _submit()
{
	$ret = $this->_exec_submit();

	switch ( $ret )
	{
		case _C_WEBPHOTO_ERR_DB:
			$msg = 'DB Error';
			if ( $this->_is_module_admin ) {
				$msg .= '<br />'.$this->get_format_error();
			}
			redirect_header( $this->_REDIRECT_THIS_URL, $this->_TIME_FAIL, $msg ) ;
			exit();

		case 0:
		default:
			break;
	}

	redirect_header( $this->_REDIRECT_THIS_URL, $this->_TIME_SUCCESS , $this->get_constant('DBUPDATED') ) ;
	exit();
}

function _exec_submit()
{

// load
	$row = $this->_row_current;

	if ( $this->_is_new ) {
		$ret = $this->_user_handler->insert( $row );
	} else {
		$ret = $this->_user_handler->update( $row );
	}
	if ( !$ret ) {
		$this->set_error( $this->_user_handler->get_errors() );
		return _C_WEBPHOTO_ERR_DB;
	}

	return 0;
}

//---------------------------------------------------------
// print_form
//---------------------------------------------------------
function print_form()
{
// load
	$row = $this->_row_current;

	echo $this->build_bread_crumb( 
		$this->get_constant('TITLE_MAIL_REGISTER'), $this->_REDIRECT_THIS_URL );

	echo $this->get_constant('HELP_MAIL_DSC');
	echo "<br /><br />\n";

	$url = $this->_uri_class->build_full_uri_mode( 'help' );
	echo '<a href="'. $url .'" target="_blank">';
	echo $this->get_constant('MAIL_HELP');
	echo "</a><br /><br />\n";

	if ( $this->has_error() ) {
		echo $this->build_error_msg( 
			$this->get_format_error( false, false ), null, false );
		echo "<br />\n";
	}

	if ( $this->_is_new ) {
		$mode = 'add';
	} else {
		$mode = 'edit';
	}

	$param = array(
		'mode' => $mode,
	);

	$form =& webphoto_mail_register_form::getInstance( $this->_DIRNAME , $this->_TRUST_DIRNAME );
	$form->print_form( $row, $param );

}

// --- class end ---
}

?>