<?php
// $Id: block_refresh.php,v 1.9 2007/10/13 07:02:36 ohwada Exp $

// 2007-10-10 K.OHWADA
// mode_date

// 2007-06-01 K.OHWADA
// api/refresh.php

// rssc_xml_basic_handler
// rssc_word_basic_handler

// 2006-09-20 K.OHWADA
// small change

// 2006-07-10 K.OHWADA
// use happy_linux module
// support podcast

// 2006-06-04 K.OHWADA
// merge api/block.php

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// --- block function begin ---
if( !function_exists( 'b_rssc_show_refresh' ) ) 
{

$RSSC_DIRNAME = basename( dirname( dirname( __FILE__ ) ) );

//---------------------------------------------------------
// rssc
//---------------------------------------------------------
include_once XOOPS_ROOT_PATH.'/modules/'.$RSSC_DIRNAME.'/api/view.php';
include_once XOOPS_ROOT_PATH.'/modules/'.$RSSC_DIRNAME.'/api/refresh.php';


//---------------------------------------------------------
// show headline after refresh
// $options
// [0] module directory name (rssc)
//---------------------------------------------------------
function b_rssc_show_refresh( $options )
{
	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0] ;

	$headline_handler =& rssc_get_handler('headline',     $DIRNAME);
	$view_handler     =& rssc_get_handler('view',         $DIRNAME);
	$conf_handler     =& rssc_get_handler('config_basic', $DIRNAME);

	$conf_data =& $conf_handler->get_conf();

	$link_limit  = $conf_data['block_headline_links_perpage'];
	$limit       = $conf_data['block_headline_feeds_perlink'];
	$max_title   = $conf_data['block_headline_max_title'];
	$max_summary = $conf_data['block_headline_max_summary'];
	$max_content = $conf_data['block_headline_max_content'];
	$num_content = $conf_data['block_headline_num_content'];
	$order       = $conf_data['block_headline_order'];
	$mode_date   = $conf_data['block_headline_mode_date'];
	$link_start  = 0;

	$headline_handler->refresh_headline($link_limit, $link_start);

	$view_handler->setFlagSanitize( true );	// sanitize
	$view_handler->setFeedStart(     0 );
	$view_handler->set_title_html(   false );
	$view_handler->set_content_html( true );
	$view_handler->set_max_title(   $max_title );
	$view_handler->set_max_summary( $max_summary );
	$view_handler->set_max_content( $max_content );
	$view_handler->setFeedLimit(    $limit );
	$view_handler->setFeedOrder(    $order );

// mode_date
	$show_short  = false;
	$show_middle = false;
	$show_long   = false;

	switch ( $mode_date )
	{
		case 0:
			break;

		case 2:
			$show_middle = true;
			break;

		case 3:
			$show_long = true;
			break;

		case 1:
		default:
			$show_short = true;
			break;
	}

	$block = array();
	$block['lang_more'] = _BL_RSSC_MORE;
	$block['dirname']   = $DIRNAME;
	$block['links']     =& $view_handler->get_headline_links_feeds($link_limit, $link_start);

// podcast
	$block['lang_podcast'] = _BL_RSSC_PODCAST;
	$block['unit_kb']      =  BL_RSSC_UNIT_KB;
	$block['num_content']  = $num_content;

	$block['show_short']  = $show_short;
	$block['show_middle'] = $show_middle;
	$block['show_long']   = $show_long;

	return $block;
}

// --- block function begin ---
}

?>