<?php
// $Id: weblinks_link_view.php,v 1.15 2007/12/23 00:30:21 ohwada Exp $

// 2007-12-22 K.OHWADA
// BUG: not show smile icon

// 2007-10-30 K.OHWADA
// add_space_after_punctuation()
// weblinks_auth

// 2007-09-20 K.OHWADA
// not use $_DIR_SHOTS

// 2007-09-10 K.OHWADA
// set_warning()
// support mozshot simpleapi

// 2007-08-01 K.OHWADA
// _set_gm_desc_wrap()

// 2007-06-01 K.OHWADA
// rssc_view_handler

// 2007-05-06 K.OHWADA
// image_link_show image_list_show

// 2007-03-21 K.OHWADA
// time_expire_long

// 2007-03-07 K.OHWADA
// Warning [PHP]: date(): Windows does not support dates prior to midnight (00:00:00), January 1, 1970

// 2007-03-01 K.OHWADA
// divid from weblinks_link_view_edit

//=========================================================
// WebLinks Module
// 2007-03-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view') ) 
{

//=========================================================
// class weblinks_link_view_edit
//=========================================================
class weblinks_link_view extends happy_linux_basic
{
	var $_DIRNAME;

// handler
	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;
	var $_rssc_handler;
	var $_banner_handler;
	var $_auth;

// class
	var $_myts;
	var $_system;
	var $_highlight;

// local
	var $_conf;

	var $_gm_desc_length = 100;
	var $_gm_wordwrap    = 50;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view( $dirname )
{
	$this->happy_linux_basic();

	$this->_DIRNAME = $dirname;

	$this->_config_handler       =& weblinks_get_handler('config2_basic',      $dirname );
	$this->_link_handler         =& weblinks_get_handler('link_basic',         $dirname );
	$this->_category_handler     =& weblinks_get_handler('category_basic',     $dirname );
	$this->_catlink_handler      =& weblinks_get_handler('catlink_basic',      $dirname );
	$this->_banner_handler       =& weblinks_get_handler('banner',             $dirname );
	$this->_rssc_handler         =& weblinks_get_handler('rssc_view',          $dirname );
	$this->_auth                 =& weblinks_auth::getInstance( $dirname );

	$this->_myts         =& MyTextSanitizer::getInstance();
	$this->_lang         =& happy_linux_language_factory::getInstance();
	$this->_system       =& happy_linux_system::getInstance();

	$this->_highlight    =& happy_linux_highlight::getInstance();
	$this->_highlight->set_replace_callback( 'happy_linux_highlighter_by_class' );
	$this->_highlight->set_class( 'weblinks_highlight' );

	$this->_conf = $this->_config_handler->get_conf();

// for Japanese
	$this->set_is_japanese( $this->_system->is_japanese() );
}

function &getInstance($dirname)
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_link_view($dirname);
	}
	return $instance;
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function &get_show_by_lid( $lid, $flag_highlight=false, $keyword_array=null  )
{
	$show =  false;
	$row  =& $this->_link_handler->get_cache_by_lid($lid);
	if ( is_array($row) && count($row) )
	{
		$this->set_vars( $row );
		$this->build_show( $flag_highlight, $keyword_array );
		$show =& $this->get_vars();
	}
	return $show;
}

function build_show( $flag_highlight=false, $keyword_array=null )
{
// dont show
	$this->set('passwd',      '');
	$this->set('search',      '');
	$this->set('rss_url',     '');
	$this->set('rss_xml',     '');
	$this->set('usercomment', '');

// sanitize
	$this->_set_sanitize_all();

	$desc = $this->_build_description_disp();
	$this->_set_highlight_desc(  $desc, $flag_highlight, $keyword_array );
	$this->_set_highlight_short( $desc, $flag_highlight, $keyword_array );

	$this->_set_textarea1_disp();
	$this->_set_textarea2_disp();
	$this->_set_admincomment_disp();

	$this->_set_name_mail_disp();
	$this->_set_array_addr_urlencode();
	$this->_set_link_image();
	$this->_set_show_modify();
	$this->_set_link_rss_url();

	$this->_set_warning();

	$this->set('flag_recommend', $this->get('recommend') );
	$this->set('flag_mutual',    $this->get('mutual') );

// time_create
	$time_create = $this->get('time_create');
	$this->set('create_long',   formatTimestamp($time_create, 'l') );
	$this->set('create_middle', formatTimestamp($time_create, 'm') );
	$this->set('create_short',  formatTimestamp($time_create, 's') );
	$this->set('create_mysql',  formatTimestamp($time_create, 'mysql') );

// time_update
	$time_update = $this->get('time_update');
	$this->set('update_long',   formatTimestamp($time_update, 'l') );
	$this->set('update_middle', formatTimestamp($time_update, 'm') );
	$this->set('update_short',  formatTimestamp($time_update, 's') );
	$this->set('update_mysql',  formatTimestamp($time_update, '_mysql') );

// is_owner
	$this->set('is_owner', $this->_system->is_owner( $this->get('uid') ) );

// new update
	$flag_new    = false;
	$flag_update = false;

	if ( $this->_conf['newdays'] > 0 )
	{
		$startdate = time() - (86400 * $this->_conf['newdays'] );
		if ( $startdate < $time_create ) 
		{
			$flag_new = true;
		}
		elseif ( $startdate < $time_update )
		{
			$flag_update = true;
		}
	}

	$this->set('flag_new',    $flag_new);
	$this->set('flag_update', $flag_update);

// time_publish
// Warning : date(): Windows does not support dates prior to ...
	$time_publish = $this->get('time_publish');

	$time_publish_long   = null;
	$time_publish_middle = null;
	$time_publish_short  = null;

	if ( $time_publish > 0 )
	{
		$time_publish_long   = formatTimestamp($time_publish, 'l');
		$time_publish_middle = formatTimestamp($time_publish, 'm');
		$time_publish_short  = formatTimestamp($time_publish, 's');
	}

	$this->set('time_publish_long',   $time_publish_long );
	$this->set('time_publish_middle', $time_publish_middle );
	$this->set('time_publish_short',  $time_publish_short );

// time_expire
// Warning : date(): Windows does not support dates prior to ...
	$time_expire = $this->get('time_expire');

	$time_expire_long   = null;
	$time_expire_middle = null;
	$time_expire_short  = null;

	if ( $time_expire > 0 )
	{
		$time_expire_long   = formatTimestamp($time_expire, 'l');
		$time_expire_middle = formatTimestamp($time_expire, 'm');
		$time_expire_short  = formatTimestamp($time_expire, 's');
	}

	$this->set('time_expire_long',   $time_expire_long );
	$this->set('time_expire_middle', $time_expire_middle );
	$this->set('time_expire_short',  $time_expire_short );

// url
	$flag_url = false;
	if ( $this->get('url') && $this->_conf['view_url'] )
	{
		$flag_url = $this->_conf['view_url'];
	}

	$this->set('flag_url', $flag_url);

// votes
	$votes = $this->get('votes');
	if ($votes == 1) 
	{
		$votes_disp = _WLS_ONEVOTE;
	} 
	else
	{
		$votes_disp = sprintf(_WLS_NUMVOTES, $votes);
	}

	$this->set('votes_disp', $votes_disp);

// rating
	$DECIMALS = 2;
	$rating_disp = number_format($this->get('rating'), $DECIMALS);

	$this->set('rating_disp', $rating_disp );

// hits
	$flag_pop = false;
	if ( ( $this->_conf['popular'] > 0 ) &&
         ( $this->get('hits') >= $this->_conf['popular'] ) )
	{
		$flag_pop = true;
	}

	$this->set('flag_pop', $flag_pop);

// google map
	$this->_set_gm_desc_wrap( $desc );
	$this->_set_gm_title();
	$this->_set_gm_type();
	$this->_set_gm_use();

// admin
	$flag_admin = false;
	if ( $this->_system->is_module_admin() )
	{
		$flag_admin = true;
	}

	$this->set('flag_admin', $flag_admin);

// lid
	$lid = $this->get('lid');
	$this->_set_link_catpaths_by_lid($lid);
	$this->_set_link_mail_by_lid($lid);

// dont show
	$this->set('name',   '');
	$this->set('name_s', '');
	$this->set('mail',   '');
	$this->set('mail_s', '');
}

//---------------------------------------------------------
// set & build
//---------------------------------------------------------
function _set_sanitize_all()
{
// MUST copy
	$arr = $this->get_vars();

	foreach ( $arr as $k => $v )
	{
// if NOT same item
		if ( !preg_match("/_s$/", $k) && !is_array($v) )
		{
			$name = $k.'_s';
			$val  = $this->sanitize_text($v);
			$this->set($name, $val);
		}
	}

	$this->set('url_s',     $this->sanitize_url($this->get('url')) );
	$this->set('banner_s',  $this->sanitize_url($this->get('banner')) );

}

function _build_description_disp()
{
	$context  = $this->get('description');
	$dohtml   = $this->get('dohtml');
	$dosmiley = $this->get('dosmiley');
	$doxcode  = $this->get('doxcode');
	$doimage  = $this->get('doimage');
	$dobr     = $this->get('dobr');
	$text = $this->_myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);

	$this->set('description_disp', $text );
	return $text;
}

function _set_textarea1_disp()
{
	$context  = $this->get('textarea1');
	$dohtml   = $this->get('dohtml1');
	$dosmiley = $this->get('dosmiley1');
	$doxcode  = $this->get('doxcode1');
	$doimage  = $this->get('doimage1');
	$dobr     = $this->get('dobr1');
	$text = $this->_myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);

	$this->set('textarea1_disp', $text );
}

function _set_textarea2_disp()
{
	$context  = $this->get('textarea2');
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;
	$text = $this->_myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);

	$this->set('textarea2_disp', $text );
}

function _set_admincomment_disp()
{
	$context  = $this->get('admincomment');
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;
	$text = $this->_myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);

	$this->set('admincomment_disp', $text );
}

function _set_name_mail_disp()
{
	$name_disp = $this->_build_name_mail_common( $this->get('name'), $this->get('nameflag') );
	$mail_disp = $this->_build_name_mail_common( $this->get('mail'), $this->get('mailflag') );

	if ( empty($name_disp) && $mail_disp )
	{
		$name_disp = 'Email';
	}

	$this->set('name_disp',  $name_disp );
	$this->set('mail_disp',  $mail_disp );
}

function _build_name_mail_common( $value, $flag )
{
	$text = null;
	if ($flag)
	{
		$text = $this->sanitize_text($value);
	}
	return $text;
}

function _set_array_addr_urlencode()
{
// Mapfan disregards a space or subsequent ones. 

	$zip   = $this->get('zip');
	$state = $this->get('state');
	$city  = $this->get('city');
	$addr  = $this->get('addr');
	$addr2 = $this->get('addr2');

	$flag_addr         = 0;
	$en_join           = '';
	$jp_join           = '';
	$en_urlencode      = '';
	$jp_urlencode      = '';
	$en_utf8_urlencode = '';
	$jp_utf8_urlencode = '';
	$en_csz            = '';
	$en_csz_urlencode  = '';

	if ( $state || $city || $addr || $addr2 )
	{
		$flag_addr = 1;	
	}

	if ( $city && $state && $zip)
	{
		$en_csz = $city.', '.$state.' '.$zip;
	}
	elseif ( $city && $state)
	{
		$en_csz = $city.', '.$state;
	}
	elseif ( $city && $zip)
	{
		$en_csz = $city.', '.$zip;
	}

	$en_csz_urlencode = urlencode( $en_csz );

	if ( $state || $city || $addr)
	{
		$en_join = $addr.' '.$en_csz;
		$jp_join = $state . $city . $addr;
		$en_utf8 = happy_linux_convert_to_utf8($en_join);
		$jp_utf8 = happy_linux_convert_to_utf8($jp_join);
		$en_urlencode      = urlencode( $en_join );
		$jp_urlencode      = urlencode( $jp_join );
		$en_utf8_urlencode = urlencode( $en_utf8 );
		$jp_utf8_urlencode = urlencode( $jp_utf8 );
	}

	$this->set('flag_addr'              , $flag_addr);
	$this->set('addr_urlencode'         , urlencode( $addr ) );
	$this->set('addr2_urlencode'        , urlencode( $addr2 ) );
	$this->set('city_urlencode'         , urlencode( $city ) );
	$this->set('state_urlencode'        , urlencode( $state ) );
	$this->set('zip_urlencode'          , urlencode( $zip ) );
	$this->set('addr_utf8_urlencode'    , urlencode( happy_linux_convert_to_utf8( $addr ) ) );
	$this->set('addr2_utf8_urlencode'   , urlencode( happy_linux_convert_to_utf8( $addr2 ) ) );
	$this->set('city_utf8_urlencode'    , urlencode( happy_linux_convert_to_utf8( $city ) ) );
	$this->set('state_utf8_urlencode'   , urlencode( happy_linux_convert_to_utf8( $state ) ) );
	$this->set('zip_utf8_urlencode'     , urlencode( happy_linux_convert_to_utf8( $zip ) ) );
	$this->set('addr_en_join'           , $en_join);
	$this->set('addr_jp_join'           , $jp_join);
	$this->set('addr_en_urlencode'      , $en_urlencode);
	$this->set('addr_jp_urlencode'      , $jp_urlencode);
	$this->set('addr_en_utf8_urlencode' , $en_utf8_urlencode);
	$this->set('addr_jp_utf8_urlencode' , $jp_utf8_urlencode);
	$this->set('addr_en_csz'            , $en_csz);
	$this->set('addr_en_csz_urlencode'  , $en_csz_urlencode);

}

//---------------------------------------------------------
// warning
//---------------------------------------------------------
function _set_warning()
{
	$this->set('warn_time_publish', $this->_is_warn_time_publish() );
	$this->set('warn_time_expire',  $this->_is_warn_time_expire() );
	$this->set('warn_broken',       $this->_is_warn_broken() );
}

function _is_warn_time_publish()
{
	if (( $this->get('time_publish') == 0 )||( $this->get('time_publish') < time() ))
	{	return false;	}
	return true;
}

function _is_warn_time_expire()
{
	if (( $this->get('time_expire') == 0 )||( $this->get('time_expire') > time() ))
	{	return false;	}
	return true;
}

function _is_warn_broken()
{
	if (( $this->get('broken') == 0 )||( $this->get('broken') < $this->_conf['broken_threshold'] ))
	{	return false;	}
	return true;
}

//---------------------------------------------------------
// google map
//---------------------------------------------------------
function _set_gm_desc_wrap( $text )
{

	$text = $this->add_space_after_punctuation($text);
	$text = $this->replace_return_to_space($text);
	$text = $this->strip_space($text);
	$text = $this->strip_tags_for_text($text);

	$length = $this->_conf['gm_desc_length'];

	if (( $length > 0 )&&( strlen($text) > $length ))
	{
		$text = $this->shorten_text($text, $length );
	}
	elseif ( $length == 0 )
	{
		$text = '';
	}

	$text = $this->sanitize_text($text);

	if ( $this->_conf['gm_wordwrap'] > 0 )
	{
		$text = wordwrap( $text, $this->_conf['gm_wordwrap'], "<br />" );
	}

	$this->set('gm_desc_wrap', $text);
}

function _set_gm_title()
{
	$text = $this->get('title');

	$length = $this->_conf['gm_title_length'];

	if (( $length > 0 )&&( strlen($text) > $length ))
	{
		$text = $this->shorten_text($text, $length );
	}
	elseif ( $length == 0 )
	{
		$text = '';
	}

	$text = $this->sanitize_text($text);
	$this->set('gm_title_s', $text);
}

function _set_gm_type()
{
	$gm_type = $this->get('gm_type');

	$gm_type_str = '';
	if ( $gm_type == 1 ) {
		$gm_type_str = 'satellite';
	} elseif ( $gm_type == 2 ) {
		$gm_type_str = 'hybrid';
	}

	$this->set('gm_type_str', $gm_type_str);
}

function _set_gm_use()
{
	$flag_gm_use = false;
	if ( $this->_conf['gm_use'] && 
	     $this->_conf['gm_apikey'] && 
	   (($this->get('gm_latitude') != 0)||($this->get('gm_longitude') != 0)||($this->get('gm_zoom') != 0)) )
	{
		$flag_gm_use = true;
	}

	$this->set('flag_gm_use', $flag_gm_use);
}

//---------------------------------------------------------
// config_handler
//---------------------------------------------------------
function _set_show_modify()
{
	$show_modify = $this->_auth->show_modify( $this->get('uid') );
	$this->set('show_modify', $show_modify );
}

//---------------------------------------------------------
// catlink_handler
//---------------------------------------------------------
function _set_link_catpaths_by_lid($lid)
{
	$show_catpaths = false;
	$catpaths      = null;

	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	if ( is_array($cid_arr) && count($cid_arr) )
	{
		list($show_catpaths, $catpaths) =
			$this->build_catpaths_by_cid_array( $cid_arr );
	}

	$this->set('show_catpaths', $show_catpaths);
	$this->set('catpaths',      $catpaths);
}

//---------------------------------------------------------
// category_handler
//---------------------------------------------------------
function build_catpaths_by_cid_array( &$cid_arr )
{
	$show_catpaths = false;
	$catpaths      = null;

	if ( is_array($cid_arr) && count($cid_arr) )
	{
		$catpaths =& $this->_category_handler->build_parent_path_multi($cid_arr);
	}

	if ( is_array($catpaths) && count($catpaths) )
	{
		$show_catpaths = true;
	}

	return array($show_catpaths, $catpaths);
}

//---------------------------------------------------------
// banner_handler
//---------------------------------------------------------
function _set_link_image()
{
	$arr =& $this->_banner_handler->build_show_image_web
		( $this->get('banner'), $this->get('width'), $this->get('height'), $this->get('url') );

	$image_url         = $arr['image_url'];
	$image_link_width  = $arr['image_link_width'];
	$image_link_height = $arr['image_link_height'];
	$image_list_width  = $arr['image_list_width'];
	$image_list_height = $arr['image_list_height'];
	$image_link_show   = false;
	$image_list_show   = false;

	if ( $this->_conf['link_image_use'] && $image_url )
	{
		$image_link_show = true;
	}

	if ( $this->_conf['list_image_use'] && $image_url )
	{
		$image_list_show = true;
	}

	$this->set('image_url',          $image_url );
	$this->set('image_link_width',   $image_link_width );
	$this->set('image_link_height',  $image_link_height );
	$this->set('image_list_width',   $image_list_width );
	$this->set('image_list_height',  $image_list_height );
	$this->set('image_link_show',    $image_link_show);
	$this->set('image_list_show',    $image_list_show);
}

//---------------------------------------------------------
// rssc_handler
//---------------------------------------------------------
function _set_link_rss_url()
{
	list($flag, $url, $url_s) =
		$this->build_rss_url_by_rssc_lid( $this->get('rssc_lid') );

	$this->set('rss_flag',   $flag);
	$this->set('rss_url',    $url );
	$this->set('rss_url_s',  $url_s );
}

function build_rss_url_by_rssc_lid( $rssc_lid )
{
	$flag  = 0;
	$url   = '';
	$url_s = '';
	if ( WEBLINKS_RSSC_USE && $rssc_lid )
	{
		$row =& $this->_rssc_handler->get_rssc_link_by_rssc_lid($rssc_lid);
		$flag  = $row['mode'];
		$url   = $row['url_xml'];
		$url_s = $row['url_xml_s'];
	}
	return array($flag, $url, $url_s);
}

//---------------------------------------------------------
// class highlight
//---------------------------------------------------------
function _set_highlight_desc( $text, $flag_highlight=false, $keyword_array=null  )
{
	if ( $flag_highlight )
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}
	$this->set('desc_disp', $text);
}

function _set_highlight_short( $text, $flag_highlight=false, $keyword_array=null  )
{
// BUG: not show  smile icon
// no action, if under limit
	if ( strlen($text) > $this->_conf['descshort'] )
	{
		$text = $this->add_space_after_punctuation($text);
		$text = $this->replace_return_to_space($text);
		$text = $this->strip_space($text);
		$text = $this->strip_tags_for_text($text);
		$text = $this->shorten_text($text, $this->_conf['descshort'], $keyword_array );
		$text = $this->sanitize_text($text);
	}

	if ( $flag_highlight )
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}

	$this->set('desc_short', $text);
}

//---------------------------------------------------------
// class language
//---------------------------------------------------------
function _set_link_mail_by_lid($lid)
{
	$mail_subject = '';
	$mail_body    = '';

	if ($lid)
	{
		list($mail_subject, $mail_body) 
			= $this->build_link_mail_by_lid($lid);
	}

	$this->set('mail_subject', $mail_subject);
	$this->set('mail_body',    $mail_body);
}

// myheader.php
function build_link_mail_by_lid($lid)
{
	$sitename = $this->_system->get_sitename();
	$subject  = sprintf(_WLS_INTRESTLINK,  $sitename);
	$body     = sprintf(_WLS_INTLINKFOUND, $sitename).": ".$this->_build_show_single_link_by_lid($lid);

// --- effective only in Japanese environment ---
// convert EUC-JP to SJIS
	$subject = $this->_lang->convert_telafriend_subject($subject);
	$body    = $this->_lang->convert_telafriend_body($body);

	$subject = rawurlencode($subject);
	$body    = rawurlencode($body);

	return array($subject, $body);
}

function _build_show_single_link_by_lid($lid)
{
	$link = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$lid;
	return $link;
}

//=========================================================
// for rss
//=========================================================
function get_rss_by_lid( $lid, $flag_user=false )
{
	$show =  false;
	$row  =& $this->_link_handler->get_cache_by_lid($lid);
	if ( is_array($row) && count($row) )
	{
		$this->set_vars( $row );
		$this->build_rss( $flag_user );
		$show =& $this->get_vars();
	}
	return $show;
}

function build_rss( $flag_user=false )
{
// link
	$lid = $this->get('lid');
	$this->set('link', $this->_build_show_single_link_by_lid($lid) );

	$this->set('content', $this->_build_description_disp() );

// author_name
	$uid = $this->get('uid');

	$author_name  = '';
	$author_email = '';
	$author_uri   = '';

	if ( $flag_user && $uid )
	{
		$user = $this->_system->get_user_by_uid( $uid );
		$author_name  = $user['uname'];
		$author_email = $user['email'];
		$author_uri   = $user['url'];
	}

	$this->set('author_name',  $author_name);
	$this->set('author_email', $author_email);
	$this->set('author_uri',   $author_uri);

// category
	$category = '';

	$cid_arr =& $this->_catlink_handler->get_cid_array_by_lid($lid);
	if ( isset($cid_arr[0]) )
	{
		$cid = intval($cid_arr[0]);
		$this->_category_handler->get_cache_row($cid);
		$category = $this->_category_handler->get_title($cid, 'n');
	}

	$this->set('category', $category);
}

// --- class end ---
}

// === class end ===
}

?>