<?php
// $Id: multibyte.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

function pagerank_set_internal_encoding()
{
	$encoding = pagerank_iconv_get_encoding( 'internal_encoding' );
	$ret = pagerank_iconv_set_encoding( 'internal_encoding', _CHARSET );
	if ( $ret === false )
	{
		pagerank_iconv_set_encoding( 'internal_encoding', $encoding );
	}

	$encoding = pagerank_mb_internal_encoding();
	$ret = pagerank_mb_internal_encoding( _CHARSET );
	if ( $ret === false )
	{
		pagerank_mb_internal_encoding( $encoding );
	}
}

function pagerank_iconv_get_encoding( $type )
{
	if ( function_exists('iconv_get_encoding') ) 
	{
		return iconv_get_encoding( $type );
	}
}

function pagerank_iconv_set_encoding( $type, $charset )
{
	if ( function_exists('iconv_set_encoding') ) 
	{
		return iconv_set_encoding( $type, $charset );
	}
}

function pagerank_mb_internal_encoding( $encoding=null )
{
	if ( function_exists('mb_internal_encoding') ) 
	{
		if ( $encoding ) 
		{
			return mb_internal_encoding( $encoding );
		}
		else 
		{
			return mb_internal_encoding();
		}
	}
}

function pagerank_http_output()
{
	if ( function_exists('mb_http_output') ) 
	{	mb_http_output( 'pass' );	}
}

function pagerank_exists_convert_encoding()
{
	if ( function_exists('iconv') ) 
	{	return true;	}

	if ( function_exists('mb_convert_encoding') ) 
	{	return true;	}

	return false;
}

function pagerank_convert_encoding( $str, $to, $from )
{
	if ( $to == $from ) 
	{	return $str;	}

	if ( function_exists('iconv') ) 
	{	return iconv( $from, $to.'//IGNORE' , $str );	}

	if ( function_exists('mb_convert_encoding') ) 
	{	return mb_convert_encoding( $str, $from, $to );	}

	return $str;
}

function pagerank_substr( $str, $start, $length )
{
	if ( function_exists('iconv_substr') )
	{	return iconv_substr( $str, $start, $length );	}

	if ( function_exists('mb_strcut') )
	{	return mb_strcut( $str, $start, $length );	}

	return substr( $str, $start, $length );
}

?>