<?php
// $Id: main.php,v 1.1.1.1 2008/02/09 06:46:15 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//=========================================================
// class gpagerank_main
//=========================================================
class gpagerank_main extends gpagerank_error
{
	var $_url_handler;
	var $_pagerank;
	var $_MAX_RECORDS = 10000;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_main()
{
	$this->_url_handler =& gpagerank_url_handler::getInstance();
	$this->_pagerank    =  new gpagerank_pagerank();

	$this->_pagerank->DEBUG = _GPAGERANK_C_DEBUG_GOOGLE;
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new gpagerank_main();
	}
	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function format_url( $url )
{
	return $this->_pagerank->format_url( $url );
}

function get_page_rank( $url )
{
	if ( !$this->_pagerank->check_url( $url ) )
	{	return -1;	}

	list( $flag_pr, $flag_new, $row ) = $this->_get_pr( $url );

	if ( $flag_pr )
	{
		return intval( $row['pr'] );
	}

	$pr = $this->_pagerank->get_page_rank( $url, false );

	if (( $pr >= 0 )&&( $pr <= 10 )) 
	{
		$this->_update( $flag_new, $row, $pr );
	}
	else 
	{
		switch ( $pr ) 
		{
			case _GPAGERANK_C_PR_URL:
				break;

			case _GPAGERANK_C_PR_CONN:
				$this->set_error( $this->_pagerank->errstr );
				break;

			case _GPAGERANK_C_PR_RANK:
				$this->set_error( $this->_pagerank->google_url );
				$this->set_error( $this->_pagerank->contents );
				$this->_update( $flag_new, $row, $pr );
				break;
		}
	}

	return intval($pr);
}

function max_range( $pr )
{
	if ( $pr > _GPAGERANK_C_PR_MAX )
	{	 $pr = _GPAGERANK_C_PR_MAX;	}
	return $pr;
}

function min_range( $pr )
{
	if ( $pr < _GPAGERANK_C_PR_MIN )
	{	 $pr = _GPAGERANK_C_PR_MIN;	}
	return $pr;
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _get_pr( $url )
{
	$flag_pr  = false;
	$flag_new = false;

	$row =& $this->_url_handler->get_row_by_url( $url );
	if ( is_array($row) )
	{
		if ( $this->_url_handler->check_time( $row ) )
		{
			$flag_pr = true;
		}
	}
	else
	{
		$flag_new = true;
		$row = array();
		$row['url'] = $url;
		$row['pr']  = _GPAGERANK_C_PR_RANK;
	}

	return array( $flag_pr, $flag_new, $row );
}

function _update( $flag_new, &$row, $pr )
{
	$pr_prev = $row['pr'];

// probably temporary error
	if (( $pr == _GPAGERANK_C_PR_RANK )&&( $pr_prev != _GPAGERANK_C_PR_RANK ))
	{
		$pr = $pr_prev;
	}

	$row['pr']          = $pr;
	$row['update_unix'] = time();

	if ( $flag_new )
	{
		$this->_url_handler->clear_over_num( $this->_MAX_RECORDS );
		$ret = $this->_url_handler->insert( $row );
	}
	else
	{
		$ret = $this->_url_handler->update( $row );
	}
	if ( !$ret )
	{
		$this->set_error( $this->_url_handler->get_errors() );
	}
}

// --- class end ---
}

?>