<?php
// $Id: form.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//=========================================================
// class gpagerank_form
//=========================================================
class gpagerank_form extends gpagerank_error
{
	var $_gpagerank_post;
	var $_pagenavi;

	var $_MODULE_NAME = _MI_GPAGERANK_NAME;
	var $_TIME_START  = GPAGERANK_TIME_START;
	var $_LANG_MUST_LOGIN = 'You must login';

	var $_FORM_NAME   = 'gpagerank_form';
	var $_sortid          = 0;
	var $_LIMIT_DEFAULT = 50;
	var $_LIMIT         = 50;
	var $_LENGTH        = 500;
	var $_CHECK_ALL_ID;
	var $_THIS_URL;

	var $_TABLE_SELECT_WIDTH = '200px';
	var $_TD_SELECT_WIDTH    = '100px';

	var $_is_login_user    = false;
	var $_is_module_admin  = false;
	var $_xoops_language;
	var $_xoops_uid   = 0;
	var $_xoops_uname = '';

	var $_alternate_class = '';
	var $_line_count      = 0;

	var $_cached_token = null;
	var $_token_errstr = null;
	var $_token_error  = false;

	var $_DIV_STYLE = 'background-color: #dde1de; border: 1px solid #808080; margin: 5px; padding: 10px 10px 5px 10px; width: 95%; text-align: center; ';
	var $_DIV_ERROR_STYLE = 'background-color: #ffffe0; color: #ff0000; border: #808080 1px dotted; margin:  3px; padding: 3px;';
	var $_SELECTED = 'selected="selected"';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_form()
{
	$this->gpagerank_error();

	$this->_gpagerank_post  =& gpagerank_post::getInstance();
	$this->_pagenavi    =& gpagerank_pagenavi::getInstance();

	$this->_THIS_URL     = xoops_getenv('PHP_SELF');
	$this->_CHECK_ALL_ID = $this->_FORM_NAME . '_id';

	$this->set_limit( $this->_LIMIT_DEFAULT );

	$this->_init_xoops_param();
}

//---------------------------------------------------------
// header
//---------------------------------------------------------
function build_html_header( $title=null )
{
	if ( empty($title) )
	{	$title = $this->_MODULE_NAME;	}

	$text  = '<html><head>'."\n";
	$text .= '<meta http-equiv="Content-Type" content="text/html; charset='. _CHARSET .'" />'."\n";
	$text .= '<title>'. $this->sanitize( $title ) .'</title>'."\n";
	$text .= '</head><body>'."\n";
	return $text;
}

function build_html_footer( $close=null )
{
	if ( empty($close) )
	{	$close = _CLOSE;	}

	$text  = '<hr />'."\n";
	$text .= '<div style="text-align:center;">';
	$text .= '<input value="'. $close .'" type="button" onclick="javascript:window.close();" />';
	$text .= '</div>'."\n";
	$text .= '</body></html>'."\n";
	return $text;
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function build_form_begin( $op=null, $id=null )
{
	$text  = '<form name="'. $this->_FORM_NAME .'" action="'. $this->_THIS_URL .'" method="post" >'."\n";
	$text .= $this->build_html_token()."\n";
	if ( $op )
	{	$text .= $this->build_hidden( 'op', $op );	}
	if ( $id )
	{	$text .= $this->build_hidden( 'id', $id );	}
	return $text;
}

function build_js_checkall()
{
	$name     = $this->_FORM_NAME . '_checkall';
	$checkall = "xoopsCheckAll('". $this->_FORM_NAME ."', '". $name ."')";
	$extra    = ' onclick="'.$checkall.'" ';
	$text = '<input type="checkbox" name="'. $name .'" id="'.$name.'" '. $extra .' />'."\n";
	return $text;
}

function build_js_checkbox( $value )
{
	$name = $this->_CHECK_ALL_ID . '[]';
	$text = '<input type="checkbox" name="'. $name .'" id="'. $name .'" value="'. $value .'"  />'."\n";
	return $text;
}

function substite_empty( $str )
{
	if ( empty($str) )
	{	$str = '---';	}
	return $str;
}

function build_select_form( $name, $value, $options, $size=5 )
{
	$text = '<select name="'. $name.'" size="'. $size .'">'."\n";
	foreach ( $options as $k => $v )
	{
		$selected = '';
		if ( $k == $value )
		{	$selected = $this->_SELECTED;	}

		$text .= '<option value="'. $k .'" '. $selected .' >';
		$text .= $v;
		$text .= '</option >'."\n";
	}
	$text .= '</select>'."\n";
	return $text;
}

function build_div_box( $str )
{
	$text = '<div style="'. $this->_DIV_STYLE .'">'. $str ."</div>\n";
	return $text;
}

function build_hidden( $name, $value )
{
	$text = '<input type="hidden" name="'. $this->sanitize( $name ) .'"  value="'. $this->sanitize( $value ) .'" />'."\n";
	return $text;
}

//---------------------------------------------------------
// table element
//---------------------------------------------------------
function build_table_begin()
{
	$text = '<table class="outer" width="100%" cellpadding="4" cellspacing="1">'."\n";
	return $text;
}

function build_list_col( &$row, $key, $class )
{
	$value_s = '';
	if ( isset( $row[$key] ) )
	{
		$value_s = $this->sanitize( $row[$key] );
	}
	$text = '<td class="'. $class .'">' .$value_s .'</td>';
	return $text;
}

function build_line_title( $title )
{
	$text  = '<tr align="center">';
	$text .= '<th colspan="2">'. $title .'</th>';
	$text .= '</tr>'."\n";
	return $text;
}

function build_line_value( $title, $value, $flag=true )
{
	if ( $flag )
	{	$value = $this->sanitize( $value );	}

	$text  = '<tr><td class="head">'. $title .'</td>';
	$text .= '<td class="odd">'. $value .'</td></tr>'."\n";
	return $text;
}

function build_line_label( &$row, $name, $title, $flag=true )
{
	$value_s = '';
	if ( isset( $row[$name] ) )
	{
		$value_s = $row[$name];
		if ( $flag )
		{	$value_s = $this->sanitize( $value_s );	}
	}

	$text  = '<tr><td class="head">'. $title .'</td>';
	$text .= '<td class="odd">';
	$text .= $this->substite_empty( $value_s );
	$text .= "</td></tr>\n";
	return $text;
}

function build_line_text( &$row, $name, $title, $size=50 )
{
	$value_s = '';
	if ( isset( $row[$name] ) )
	{	$value_s = $this->sanitize( $row[$name] );	}

	$text  = '<tr><td class="head">'. $title .'</td>';
	$text .= '<td class="odd">';
	$text .= '<input tyep="text" name="'. $name .'" value="'. $value_s .'" size="'. $size .'" />';
	$text .= "</td></tr>\n";
	return $text;
}

function build_line_textarea( &$row, $name, $title, $rows=5, $cols=80 )
{
	$value_s = '';
	if ( isset( $row[$name] ) )
	{	$value_s = $this->sanitize( $row[$name] );	}

	$text  = '<tr><td class="head">'. $title .'</td>';
	$text .= '<td class="odd">';
	$text .= $this->build_textarea_begin( $name, $rows, $cols );
	$text .= $value_s .'</textarea>';
	$text .= "</td></tr>\n";
	return $text;
}

function build_textarea_begin( $name=null, $rows=5, $cols=80 )
{
	$text = '<textarea name="'. $name .'" rows="'. $rows .'" cols="'. $cols .'">';
	return $text;
}

function build_line_add()
{
	$text  = '<tr><td class="head"></td>';
	$text .= '<td class="head">';
	$text .= '<input type="submit" name="add" value="'. _ADD .'" /> ';
	$text .= "</td></tr>\n";
	return $text;
}

function build_line_edit()
{
	$text  = '<tr><td class="head"></td>';
	$text .= '<td class="head">';
	$text .= '<input type="submit" name="edit"   value="'. _EDIT .'" /> ';
	$text .= '<input type="submit" name="delete" value="'. _DELETE .'" />';
	$text .= "</td></tr>\n";
	return $text;
}

function get_alternate_class()
{
	if ( $this->_line_count % 2 != 0) 
	{
		$class = 'odd';
	}
	else 
	{
		$class = 'even';
	}
	$this->_alternate_class = $class;
	$this->_line_count ++;
	return $class;
}

//---------------------------------------------------------
// footer
//---------------------------------------------------------
function build_admin_footer()
{
	$text  = "<br /><hr />\n";
	$text .= $this->build_execution_time();
	$text .= $this->build_memory_usage();
	return $text;
}

function build_execution_time()
{
	$text = 'execution time : '.$this->get_execution_time().' sec'."<br />\n";
	return $text;
}

function build_memory_usage()
{
	$usage = $this->get_memory_usage();
	if ( $usage )
	{
		$text  = 'memory usage : '.$usage.' MB'."<br />\n";
		return $text;
	}
	return null;
}

function get_execution_time()
{
	list($usec, $sec) = explode(" ",microtime()); 
	$time = floatval($sec) + floatval($usec)- $this->_TIME_START; 
	$exec = sprintf("%6.3f", $time);
	return $exec;
}

function get_memory_usage()
{
	if ( function_exists('memory_get_usage') )
	{
		$usage = sprintf("%6.3f",  memory_get_usage() / 1000000 );
		return $usage;
	}
	return null;
}

function get_powered_by()
{
	$text  = '<div align="right">';
	$text .= '<a href="http://linux2.ohwada.net/" target="_blank">';
	$text .= '<span style="font-size : 80%;">Powered by Happy Linux</span>';
	$text .= "</a></div>\n";
	return $text;
}

//---------------------------------------------------------
// keyword
//---------------------------------------------------------
function &parse_keywords( $keywords, $andor='AND' )
{
	$keyword_min   = $this->get_xoops_search_keyword_min();
	$keyword_array = array();
	$ignore_array  = array();

	if ( $keywords == '' )
	{
		$arr = array( $keyword_array, $ignore_array );
		return $arr;
	}

	if ( $andor == 'exact' ) 
	{
		$keyword_array = array( $keywords );
	}
	else
	{
		$temp_arr = preg_split( '/[\s,]+/', $keywords );

		foreach ($temp_arr as $q) 
		{
			$q = trim($q);

			if ( strlen($q) >= $keyword_min ) 
			{
				$keyword_array[] = $q;
			}
			else 
			{
				$ignore_array[] = $q;
			}
		}
	}

	$arr = array( $keyword_array, $ignore_array );
	return $arr;
}

//---------------------------------------------------------
// paginavi
//---------------------------------------------------------
function set_sortid_by_post()
{
	$sortid = intval ( $this->_gpagerank_post->get_post_get( 'sortid', -1 ) );
	if ( $sortid >= 0 )
	{
		$this->set_sortid( $sortid );
	}
}

function set_limit_by_post()
{
	$limit = intval( $this->_gpagerank_post->get_post_get( 'limit' ) );
	if ( $limit )
	{
		$this->set_limit( $limit );
	}
}

function set_max_sortid( $val )
{
	$this->_pagenavi->set_max_sortid( $val );
	$this->_pagenavi->set_flag_sortid( true );
}

function set_sortid( $val )
{
	$this->_sortid = $this->_pagenavi->_check_sortid( $val );
	$this->_pagenavi->set_sortid( $this->_sortid );
}

function set_limit( $val )
{
	$this->_LIMIT = intval($val);
	$this->_pagenavi->setPerpage( $this->_LIMIT );
}

function get_pagenavi_start( $total )
{
	$this->_pagenavi->setTotal( $total );
	$this->_pagenavi->getGetPage();
	return $this->_pagenavi->calcStart();
}

function get_pagenavi_end()
{
	return $this->_pagenavi->calcEnd();
}

function build_pagenavi( $script=null )
{
	if ( empty($script) )
	{
		$script = $this->_THIS_URL;
	}

	$script = $this->add_pagenavi_script_limit( $script, $this->_LIMIT );
	$text  = '<div align="center">';
	$text .= $this->_pagenavi->build( $script );
	$text .= "</div><br />\n";
	return $text;
}

function add_pagenavi_script_limit( $script, $limit )
{
	$type = $this->_pagenavi->_analyze_script_type( $script );

	if ($type == 1)
	{
		$add = "limit=";
	}
	elseif ($type == 2)
	{
		$add = "&limit=";
	}
	else
	{
		$add = "?limit=";
	}

	$script_new = $script.$add.$limit;

	return $script_new;
}

function build_form_pagenavi_limit()
{
	$text  = '<div align="center">';
	$text .= '<form name="'. $this->_FORM_NAME .'" action="'. $this->_THIS_URL .'" method="get" >'."\n";
	$text .= $this->build_hidden( 'sortid', $this->_sortid );
	$text .= 'per page'.' ';
	$text .= '<input type="text" name="limit" id="limit"  value="'. $this->_LIMIT .'"  />'."\n";
	$text .= '<input type="submit" name="sumit" value="'. 'SET' .'" />';
	$text .= "</form>\n";
	$text .= "</div><br />\n";
	return $text;
}

//---------------------------------------------------------
// token
//---------------------------------------------------------
function get_token()
{
	global $xoopsGTicket;
	if ( is_object($xoopsGTicket) )
	{
		return $xoopsGTicket->issue();
	}
	return null;
}

function build_html_token()
{
// get same token on one page, becuase max ticket is 10
	if ( $this->_cached_token )
	{
		return $this->_cached_token;
	}

	global $xoopsGTicket;
	$text = '';
	if ( is_object($xoopsGTicket) )
	{
		$text = $xoopsGTicket->getTicketHtml()."\n";
		$this->_cached_token = $text;
	}
	return $text;
}

function check_token( $allow_repost=false )
{
	global $xoopsGTicket;
	if ( is_object($xoopsGTicket) )
	{
		if ( ! $xoopsGTicket->check( true , '',  $allow_repost ) ) 
		{
			$this->_token_error  = true;
			$this->_token_errstr = $xoopsGTicket->getErrors();
			return false;
		}
	}
	$this->_token_error = false;
	return true;
}

//---------------------------------------------------------
// xoops 
//---------------------------------------------------------
function _init_xoops_param()
{
	global $xoopsConfig, $xoopsUser, $xoopsModule;

	$this->_xoops_language = $xoopsConfig['language'];

	if ( is_object($xoopsModule) )
	{
		$this->_MODULE_ID   = $xoopsModule->mid();
		$this->_MODULE_NAME = $xoopsModule->getVar('name', 'n');
	}

	if ( is_object($xoopsUser) )
	{
		$this->_is_login_user = true;
		$this->_xoops_uid     = $xoopsUser->getVar('uid');
		$this->_xoops_uname   = $xoopsUser->getVar('uname');

		if ( $xoopsUser->isAdmin( $this->_MODULE_ID ) ) 
		{
			$this->_is_module_admin = true;
		}
	}

}

function get_xoops_search_keyword_min()
{
	$config_handler =& xoops_gethandler('config');
	$xoopsConfigSearch =& $config_handler->getConfigsByCat( XOOPS_CONF_SEARCH );
	$keyword_min = $xoopsConfigSearch['keyword_min'];
	return $keyword_min;
}

function get_xoops_user_name( $uid, $usereal=0 )
{
	return XoopsUser::getUnameFromId( $uid, $usereal );
}

function build_xoops_userinfo( $uid, $usereal=0 )
{
	$uname = $this->get_xoops_user_name( $uid, $usereal );

	$uid = intval($uid);
	if ( $uid == 0 )
	{	return $uname;	}

	$text  = '<a href="'. XOOPS_URL .'/userinfo.php?uid='. $uid .'">'. $uname .'</a>';
	return $text;
}

function check_login()
{
	if ( $this->_is_login_user ) 
	{	return true;	}

	redirect_header( XOOPS_URL.'/user.php', 3, $this->_LANG_MUST_LOGIN );
	exit();
}

function get_url_preferences()
{
// for Cube 2.1
	if( defined( 'XOOPS_CUBE_LEGACY' ) ) 
	{
		$url = '/modules/legacy/admin/index.php?action=PreferenceEdit&amp;confmod_id=';
	}
	else
	{
		$url = '/modules/system/admin.php?fct=preferences&amp;op=showmod&amp;mod=';
	}
	$url_pref = XOOPS_URL . $url . $this->_MODULE_ID;
	return $url_pref;
}

// --- class end ---
}

?>