<?php
// $Id: weblinks_link_check_handler.php,v 1.9 2007/09/23 05:17:54 ohwada Exp $

// 2007-09-20 K.OHWADA
// PHP5.2: Non-static method xxx::getInstance() should not be called statically
// use link_bin_handler
// not use locate_factory

// 2007-06-10 K.OHWADA
// happy_linux_bin_file

// 2007-03-01 K.OHWADA
// small change check()
// small change get_no_check()

// 2006-10-05 K.OHWADA
// use happy_linux
// remove refresh_link() refresh_site()
// use weblinks_locate_factory

// 2006-05-15 K.OHWADA
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004-10-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_check_handler') ) 
{

//=========================================================
// class weblinks_link_check_handler
// this class is used by command line
//=========================================================
class weblinks_link_check_handler
{
	var $_DIRNAME;

	var $_link_handler;
	var $_remote_file;
	var $_bin_file;

	var $_flag_broken   = false;	// view broken colum
	var $_flag_echo     = true;
	var $_flag_echo_lid = false;

	var $_total_link;
	var $_num_link_check;
	var $_num_link_broken;
	var $_link_broken_arr;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_check_handler( $dirname )
{
	$this->_DIRNAME = $dirname;

// handler
	$this->_link_handler =& weblinks_get_handler( 'link_bin', $dirname );

// Non-static method xxx::getInstance() should not be called statically
	$this->_remote_file = new happy_linux_remote_file();
	$this->_bin_file    = new happy_linux_bin_file();
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function check($limit=0, $offset=0)
{
	$link_broken_count = 0;
	$link_broken_arr   = array();

	$this->_total_link = $this->get_link_count_all();

	$lid_array =& $this->_get_lid_array($limit, $offset);
	$lid_num   = count( $lid_array );
	$this->_num_link_check = $lid_num;

// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
	if ($lid_num == 0)
	{
		$data = $this->_get_no_check();
		$this->print_write_data($data);
		return true;	// no action
	}

	$lid_start = $lid_array[0];
	$lid_end   = $lid_array[$lid_num - 1];

	$time_start = time();

// --- check start ---
	$data = $this->_get_check_html_start();
	$this->print_write_data($data);

// proc by record
	foreach($lid_array as $lid)
	{
		$row =& $this->_get_link_row( $lid );
		$title    = $row['title'];
		$url      = $row['url'];
		$rss_flag = $row['rss_flag'];

		if ( $this->_flag_echo_lid )
		{
			echo $lid."\n";
		}

// next, if url is null
		if (empty($url)) continue;

// link check
		if ( !$this->_check_url($url) )
  		{
			$this->_countup_link_broken( $lid );

		    $link_broken_count ++;
		    $link_broken_arr[] = array($lid, $title, $url);
		}

	}

// --- check end ---
	$this->_link_broken_arr     = $link_broken_arr;
	$this->_num_link_broken     = $link_broken_count;

	$data = $this->_get_check_html_end( $time_start, $lid_start, $lid_end);
	$this->print_write_data($data);

	return true;	// OK
}

function set_flag_broken($value)
{
	$this->_flag_broken = (bool)$value;
}

function set_flag_echo($value)
{
	$this->_flag_echo = (bool)$value;
}

function set_flag_echo_lid($value)
{
	$this->_flag_echo_lid = (bool)$value;
}

function get_total_link()
{
	return $this->_total_link;
}

function get_num_link_broken()
{
	return $this->_num_link_broken;
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
//---------------------------------------------------------
// print HTML for check
//---------------------------------------------------------
function _get_check_html_start()
{
	$time_now  = $this->_get_time_now();
	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";
	return $text;
}

function _get_check_html_end( $time_start, $lid_start, $lid_end)
{
	$time_now    = $this->_get_time_now();
	$time_elapse = $this->_get_time_elapse($time_start);

	$text  = '';

	if ($this->_num_link_broken)
	{
		$text .= $this->_get_check_table_start();

		foreach ($this->_link_broken_arr as $broken)
		{
			list($lid, $title, $url) = $broken;
    		$text .= $this->_get_check_table_line($lid, $title, $url);
		}

		$text .= $this->_get_table_end();

		$link_broken = "<font color='red'>$this->_num_link_broken</font>";
	}
	else
	{
		$link_broken = $this->_num_link_broken;
	}

	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_ALL."</td>";
	$text .= "<td>$this->_total_link "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_CHECK."</td>";

	if ($lid_start)
	{
		$text .= "<td>$this->_num_link_check "._WEBLINKS_ADMIN_NUM." ( "._WLS_LINKID." $lid_start - $lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->_num_link_check "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	}

	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_BROKEN."</td>";
	$text .= "<td>$link_broken "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}

function _get_check_table_start()
{
	$text = _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_NOTICE;
	$text .= _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_GOOGLE;
	$text .= "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._WLS_LINKID."</th>";
	$text .= "<th align='center'>"._WLS_SITETITLE."</th>";
	$text .= "<th align='center'>"._WLS_SITEURL."</th>";

	if ($this->_flag_broken)
	{	$text .= "<th align='center'>"._WEBLINKS_ADMIN_BROKEN."</th>";	}

	$text .= "</tr>\n";

	return $text;
}

function _get_check_table_line($lid, $title, $url, $broken='')
{
	$link_id = sprintf("%03d",$lid);

	$modlink = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/admin/link_manage.php?op=modLink&lid='.$lid;
	$title   = htmlspecialchars($title);

	$text  = "<tr>";
	$text .= "<td><a href='$modlink'>$link_id</a></td>";

	$google_url = $this->_build_google_search_url($title);
	$text  .= '<td><a href="'.$google_url.'" target="_blank">'.$title.'</a></td>';

	$text .= "<td><a href='$url' target='_blank'>$url</a></td>";

	if ($this->_flag_broken)
	{	$text .= "<td>$broken</td>";	}

	$text .= "</tr>\n";

	return $text;
}

function _get_table_end()
{
	return "</table><br />\n";
}

function _get_no_check()
{
	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_NO_LINK_BROKEN_CHECK."<br /><br />\n";

	return $text;
}

//---------------------------------------------------------
// time
//---------------------------------------------------------
function _get_time_now()
{
	$text = date("Y-m-d H:i:s");
	return $text;
}

function _get_time_elapse($time_start)
{
	$time = time() - $time_start;
	$min  = intval($time/60);
	$sec  = $time - 60*$min;
	$text = sprintf(_WEBLINKS_ADMIN_MIN_SEC, $min, $sec);
	return $text;
}

function _build_google_search_url( $query )
{
	$query = happy_linux_convert_to_utf8($query);
	$query = urlencode($query);
	$url = 'http://www.google.com/search?hl='. _LANGCODE .'&q='.$query;
	return $url;
}

//---------------------------------------------------------
// weblinks_link_bin_handler
//---------------------------------------------------------
function &get_conf()
{
	return $this->_link_handler->_get_config_data();
}

function get_link_count_all()
{
	return $this->_link_handler->get_count_all();
}

function &_get_lid_array($limit=0, $offset=0)
{
	return $this->_link_handler->get_id_array($limit, $offset);
}

function &_get_link_row( $lid )
{
	return $this->_link_handler->get_row_by_id( $lid );
}

function _countup_link_broken( $lid )
{
	return $this->_link_handler->countup_broken( $lid );
}

//---------------------------------------------------------
// happy_linux_bin_file
//---------------------------------------------------------
function open_bin( $filename )
{
	return $this->_bin_file->open_bin( $filename, 'w' );
}

function close_bin( $flag_chmod )
{
	$this->_bin_file->close_bin( $flag_chmod );
}

function set_flag_write( $val )
{
	$this->_bin_file->set_flag_write( $val );
}

function print_write_data($data)
{
	if ($this->_flag_echo)
	{
		echo $data;
	}
	$this->_bin_file->write_bin( $data );
}

//---------------------------------------------------------
// happy_linux_remote_file
//---------------------------------------------------------
function _check_url( $url )
{
	return $this->_remote_file->check_url( $url );
}

// --- class end ---
}

// === class end ===
}

?>