<?php
// $Id: weblinks_auth.php,v 1.1 2007/09/15 04:23:34 ohwada Exp $

// 2007-09-10 K.OHWADA
// divid from weblinks_auth.php

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_auth') ) 
{

//=========================================================
// class weblinks_auth
//=========================================================
class weblinks_auth extends happy_linux_error
{
	var $_config_handler;
	var $_menu;
	var $_post;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_auth( $dirname )
{
	$this->happy_linux_error();

	$this->_config_handler =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_menu           =& weblinks_menu::getInstance( $dirname );
	$this->_post           =& happy_linux_post::getInstance();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_auth( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// Does the user have authority
//---------------------------------------------------------
function &get_auth_submit()
{
	$arr = array(
		$this->_menu->show_submit(),
		$this->_has_auth( 'auth_submit_auto_arr' ),
	);
	return $arr;
}

function &get_auth_modify( $rec_uid, $rec_passwd )
{
	$passwd_match = $this->_check_passwd_match( $rec_passwd );

	list($has_auth_modify_permit, $is_owner, $show_passwd) = 
		$this->_has_auth_modify( $rec_uid, $passwd_match );

	$arr = array(
		'has_auth_modify_permit' => $has_auth_modify_permit,
		'has_auth_modify_auto'   => $this->_has_auth_modify_auto(   $rec_uid, $passwd_match ),
		'has_auth_delete_permit' => $this->_has_auth_delete_permit( $rec_uid, $passwd_match ),
		'has_auth_delete_auto'   => $this->_has_auth_delete_auto(   $rec_uid, $passwd_match ),
		'is_owner'               => $is_owner,
		'show_passwd'            => $show_passwd,
		'flag_passwd_match'      => $this->_flag_passwd_match,
		'flag_passwd_incorrect'  => $this->_flag_passwd_incorrect,
	);

	return $arr;
}

function _check_passwd_match( $rec_passwd )
{
	$this->_flag_passwd_match     = false;
	$this->_flag_passwd_incorrect = false;

	$request = $this->_post->get_post_int('request');

	list($passwd, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	if ( $flag_passwd || $flag_code )
	{
		if( $rec_passwd == md5( $passwd ))
		{
			if( $flag_code || $request )
			{
				$this->_flag_passwd_match = true;
			}
			return true;
		}

		$this->_flag_passwd_incorrect = true;
	}

	return false;
}

function _has_auth_modify( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->_has_auth_owner( 'auth_modify_arr', $rec_uid, $flag_passwd );

	if ( $flag_passwd && $show_passwd )
	{
		$is_permit = true;
		$is_owner  = true;
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function _has_auth_modify_auto( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->_has_auth_owner( 'auth_modify_auto_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function _has_auth_delete_permit( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->_has_auth_owner( 'auth_delete_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function _has_auth_delete_auto( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->_has_auth_owner( 'auth_delete_auto_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function _has_auth( $name )
{
	$ret = $this->_config_handler->has_auth( $name );
	return $ret;
}

function _has_auth_owner( $name, $rec_uid, $flag_passwd )
{
	$ret = $this->_config_handler->has_auth_owner( $name, $rec_uid, $flag_passwd );
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>